/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.subapptypeeditor.editors;

import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.fordiac.ide.application.editors.SubApplicationEditorInput;
import org.eclipse.fordiac.ide.fbtypeeditor.editors.IFBTEditorPart;
import org.eclipse.fordiac.ide.fbtypeeditor.network.viewer.CompositeAndSubAppInstanceViewerInput;
import org.eclipse.fordiac.ide.fbtypeeditor.network.viewer.CompositeInstanceViewer;
import org.eclipse.fordiac.ide.model.helpers.FordiacMarkerHelper;
import org.eclipse.fordiac.ide.model.libraryElement.CFBInstance;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.model.ui.editors.AbstractBreadCrumbEditor;
import org.eclipse.fordiac.ide.model.ui.editors.HandlerHelper;
import org.eclipse.fordiac.ide.subapptypeeditor.Activator;
import org.eclipse.fordiac.ide.subapptypeeditor.editors.TypedSubAppNetworkEditor;
import org.eclipse.fordiac.ide.subapptypeeditor.editors.UnTypedSubAppNetworkEditor;
import org.eclipse.fordiac.ide.subapptypeeditor.providers.TypedSubappProviderAdapterFactory;
import org.eclipse.fordiac.ide.subapptypeeditor.viewer.SubappInstanceViewer;
import org.eclipse.fordiac.ide.typemanagement.FBTypeEditorInput;
import org.eclipse.fordiac.ide.typemanagement.navigator.FBTypeLabelProvider;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;

public class SubAppNetworkBreadCrumbEditor
extends AbstractBreadCrumbEditor
implements IFBTEditorPart {
    private CommandStack commandStack;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof FBTypeEditorInput)) {
            throw new IllegalArgumentException("SubAppNetworkBreadCrumbEditor is only suitable for FBTypeEditorInputs");
        }
        IEditorSite siteToUse = site;
        ISelectionProvider selProvider = null;
        if (siteToUse instanceof MultiPageEditorSite) {
            siteToUse = (IEditorSite)((MultiPageEditorSite)siteToUse).getMultiPageEditor().getSite();
            selProvider = siteToUse.getSelectionProvider();
        }
        super.init(siteToUse, input);
        if (selProvider != null) {
            siteToUse.setSelectionProvider(selProvider);
        }
        this.setTitleImage(FordiacImage.ICON_FB_NETWORK.getImage());
        this.setPartName("FB Network");
    }

    public FBTypeEditorInput getEditorInput() {
        return (FBTypeEditorInput)super.getEditorInput();
    }

    private SubAppType getSubAppType() {
        return (SubAppType)this.getEditorInput().getContent();
    }

    protected Composite createPageContainer(Composite parent) {
        Composite pageContainer = new Composite(parent, 0);
        pageContainer.setLayoutData((Object)new GridData(1808));
        return pageContainer;
    }

    protected void addPages() {
        try {
            TypedSubAppNetworkEditor initialEditor = new TypedSubAppNetworkEditor();
            initialEditor.setCommonCommandStack(this.getCommandStack());
            int pagenum = this.addPage((IEditorPart)initialEditor, (IEditorInput)this.getEditorInput());
            this.getModelToEditorNumMapping().put(this.getSubAppType(), pagenum);
        }
        catch (PartInitException e) {
            Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
        }
    }

    protected EditorPart createEditorPart(Object model) {
        if (model instanceof SubApp) {
            if (((SubApp)model).isTyped()) {
                return new SubappInstanceViewer();
            }
            UnTypedSubAppNetworkEditor editor = new UnTypedSubAppNetworkEditor();
            editor.setCommonCommandStack(this.getCommandStack());
            editor.setTypeLib(this.getEditorInput().getPaletteEntry().getTypeLibrary());
            return editor;
        }
        if (model instanceof CFBInstance) {
            return new CompositeInstanceViewer();
        }
        return null;
    }

    protected IEditorInput createEditorInput(Object model) {
        if (model instanceof SubApp) {
            SubApp subApp = (SubApp)model;
            if (subApp.isTyped() || subApp.isContainedInTypedInstance()) {
                return new CompositeAndSubAppInstanceViewerInput((FBNetworkElement)subApp);
            }
            return new SubApplicationEditorInput(subApp);
        }
        if (model instanceof CFBInstance) {
            return new CompositeAndSubAppInstanceViewerInput((FBNetworkElement)((FB)model));
        }
        return null;
    }

    protected AdapterFactoryContentProvider createBreadcrumbContentProvider() {
        return new AdapterFactoryContentProvider((AdapterFactory)new TypedSubappProviderAdapterFactory());
    }

    protected AdapterFactoryLabelProvider createBreadcrumbLabelProvider() {
        return new FBTypeLabelProvider();
    }

    protected Object getInitialModel(String itemPath) {
        return this.getSubAppType();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public CommandStack getCommandStack() {
        return this.commandStack;
    }

    public String getContributorId() {
        return "property.contributor.fb";
    }

    protected void gotoFBNetworkElement(Object object) {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
    }

    public boolean outlineSelectionChanged(Object selectedElement) {
        if (selectedElement instanceof EObject && EcoreUtil.isAncestor((EObject)this.getSubAppType().getFBNetwork(), (EObject)((EObject)selectedElement))) {
            if (selectedElement instanceof FBNetwork) {
                selectedElement = ((FBNetwork)selectedElement).eContainer();
            }
            if (selectedElement instanceof FBNetworkElement || selectedElement instanceof SubAppType) {
                FB refElement = null;
                if (selectedElement instanceof FB) {
                    refElement = (FB)selectedElement;
                    selectedElement = refElement.eContainer().eContainer();
                }
                this.getBreadcrumb().setInput(selectedElement);
                if (refElement != null) {
                    HandlerHelper.selectElement((Object)refElement, (IEditorPart)this.getActiveEditor());
                }
                return true;
            }
        }
        return false;
    }

    public void setCommonCommandStack(CommandStack commandStack) {
        this.commandStack = commandStack;
    }

    public boolean isMarkerTarget(IMarker marker) {
        try {
            Map attrs = marker.getAttributes();
            return FordiacMarkerHelper.markerTargetsFBNetworkElement((Map)attrs) || FordiacMarkerHelper.markerTargetsConnection((Map)attrs) || FordiacMarkerHelper.markerTargetsValue((Map)attrs);
        }
        catch (CoreException e) {
            Activator.getDefault().logError("Could not get marker attributes", (Exception)((Object)e));
            return false;
        }
    }

    public void reloadType(FBType type) {
        if (type instanceof SubAppType) {
            this.getEditorInput().setFbType(type);
            this.removePage(this.getActivePage());
            this.createPages();
            this.getBreadcrumb().setInput((Object)type);
        } else {
            EditorUtils.CloseEditor.run((IEditorPart)this);
        }
    }

    public Object getSelectableEditPart() {
        GraphicalViewer viewer = (GraphicalViewer)this.getAdapter(GraphicalViewer.class);
        return viewer.getRootEditPart();
    }
}

