/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.tools;

import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gef.tools.SelectionTool;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Cursor;

public class AdvancedPanningSelectionTool
extends SelectionTool {
    private static final int MOUSE_LEFT = 1;
    private static final int MOUSE_MIDDLE = 2;
    private static final int MOUSE_RIGHT = 3;
    private boolean isSpaceBarDown;
    private Point viewLocation;
    protected static final int PAN = 128;
    protected static final int PAN_IN_PROGRESS = 256;
    protected static final int MAX_STATE = 256;

    protected boolean acceptSpaceBar(KeyEvent e) {
        return e.character == ' ' && (e.stateMask & SWT.MODIFIER_MASK) == 0;
    }

    protected Cursor getDefaultCursor() {
        if (this.isInState(384)) {
            return Cursors.HAND;
        }
        return super.getDefaultCursor();
    }

    protected boolean handleButtonDown(int which) {
        if (this.getCurrentViewer().getControl() instanceof FigureCanvas) {
            this.viewLocation = ((FigureCanvas)this.getCurrentViewer().getControl()).getViewport().getViewLocation();
        }
        switch (which) {
            case 3: {
                this.refreshCursor();
                this.updateTargetRequest();
                ((SelectionRequest)this.getTargetRequest()).setLastButtonPressed(which);
                this.updateTargetUnderMouse();
                EditPart editpart = this.getTargetEditPart();
                if (editpart != null) {
                    this.setDragTracker(editpart.getDragTracker(this.getTargetRequest()));
                    this.lockTargetEditPart(editpart);
                }
                return true;
            }
            case 1: {
                if (!this.stateTransition(128, 256)) break;
                return true;
            }
            case 2: {
                this.isSpaceBarDown = true;
                if (this.stateTransition(1, 128)) {
                    this.stateTransition(128, 256);
                    this.refreshCursor();
                }
                return true;
            }
        }
        return super.handleButtonDown(which);
    }

    protected boolean handleButtonUp(int which) {
        if (1 == which && this.isSpaceBarDown && this.stateTransition(256, 128)) {
            return true;
        }
        if (1 == which && this.stateTransition(256, 1)) {
            this.refreshCursor();
            return true;
        }
        if (2 == which) {
            if (this.stateTransition(256, 1)) {
                this.isSpaceBarDown = false;
                this.refreshCursor();
            }
            return true;
        }
        return super.handleButtonUp(which);
    }

    protected boolean handleDrag() {
        if (this.isInState(256) && this.getCurrentViewer().getControl() instanceof FigureCanvas) {
            FigureCanvas canvas = (FigureCanvas)this.getCurrentViewer().getControl();
            canvas.scrollTo(this.viewLocation.x - this.getDragMoveDelta().width, this.viewLocation.y - this.getDragMoveDelta().height);
            return true;
        }
        return super.handleDrag();
    }

    protected boolean handleFocusLost() {
        if (this.isInState(384)) {
            this.setState(1);
            this.refreshCursor();
            return true;
        }
        return super.handleFocusLost();
    }

    protected boolean handleKeyDown(KeyEvent e) {
        if (this.acceptSpaceBar(e)) {
            this.isSpaceBarDown = true;
            if (this.stateTransition(1, 128)) {
                this.refreshCursor();
            }
            return true;
        }
        if (this.stateTransition(128, 1)) {
            this.refreshCursor();
            this.isSpaceBarDown = false;
            return true;
        }
        if (this.isInState(256)) {
            this.isSpaceBarDown = false;
        }
        return super.handleKeyDown(e);
    }

    protected boolean handleKeyUp(KeyEvent e) {
        if (this.acceptSpaceBar(e)) {
            this.isSpaceBarDown = false;
            if (this.stateTransition(128, 1)) {
                this.refreshCursor();
            }
            return true;
        }
        return super.handleKeyUp(e);
    }

    public Point getLocation() {
        return new Point(this.getCurrentInput().getMouseLocation());
    }

    public EditPart getTargetEditPart() {
        return super.getTargetEditPart();
    }
}

