/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.router;

import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.fordiac.ide.gef.Activator;
import org.eclipse.fordiac.ide.gef.router.AdjustableConnectionRouterNoJumplinksFactory;
import org.eclipse.fordiac.ide.gef.router.IConnectionRouterFactory;

public final class RouterUtil {
    public static ConnectionRouter getConnectionRouter(IFigure container) {
        return RouterUtil.getConnectionRouterFactory(container).getConnectionRouter(container);
    }

    public static IConnectionRouterFactory getConnectionRouterFactory(IFigure container) {
        HashMap<String, IConnectionRouterFactory> connectionRouter = new HashMap<String, IConnectionRouterFactory>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elems = registry.getConfigurationElementsFor("org.eclipse.fordiac.ide.gef", "ConnectionRouterProvider");
        int i = 0;
        while (i < elems.length) {
            IConfigurationElement element = elems[i];
            try {
                Object object = element.createExecutableExtension("class");
                String name = element.getAttribute("name");
                if (object instanceof IConnectionRouterFactory) {
                    IConnectionRouterFactory routerFactory = (IConnectionRouterFactory)object;
                    connectionRouter.put(name, routerFactory);
                }
            }
            catch (CoreException corex) {
                Activator.getDefault().logError("Error loading ConnectionRouter", (Exception)((Object)corex));
            }
            ++i;
        }
        String router = Activator.getDefault().getPreferenceStore().getString("ConnectionRouter");
        IConnectionRouterFactory factory = (IConnectionRouterFactory)connectionRouter.get(router);
        if (factory == null) {
            factory = new AdjustableConnectionRouterNoJumplinksFactory();
        }
        return factory;
    }

    private RouterUtil() {
        throw new UnsupportedOperationException("RouterUtil utility class should not be instantiated!");
    }
}

