/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.properties;

import org.eclipse.fordiac.ide.gef.properties.AbstractSection;
import org.eclipse.fordiac.ide.model.commands.change.ChangeArraySizeCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCommentCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeDataTypeCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeNameCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeValueCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeVariableOrderCommand;
import org.eclipse.fordiac.ide.model.commands.create.CreateInternalVariableCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteInternalVariableCommand;
import org.eclipse.fordiac.ide.model.commands.insert.InsertVariableCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.edit.providers.DataLabelProvider;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.ui.editors.DataTypeDropdown;
import org.eclipse.fordiac.ide.model.ui.widgets.OpenStructMenu;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.ui.widget.AddDeleteReorderListWidget;
import org.eclipse.fordiac.ide.ui.widget.CommandExecutor;
import org.eclipse.fordiac.ide.ui.widget.I4diacTableUtil;
import org.eclipse.fordiac.ide.ui.widget.TableWidgetFactory;
import org.eclipse.fordiac.ide.util.IdentifierVerifyListener;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class InternalVarsSection
extends AbstractSection
implements I4diacTableUtil {
    private static final String IV_NAME = "NAME";
    private static final String IV_TYPE = "TYPE";
    private static final String IV_ARRAY = "ARRAY_SIZE";
    private static final String IV_INIT = "INITIAL_VALUE";
    private static final String IV_COMMENT = "COMMENT";
    private TableViewer internalVarsViewer;
    private DataTypeDropdown typeDropDown;

    protected BaseFBType getType() {
        return (BaseFBType)this.type;
    }

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        this.createSuperControls = false;
        super.createControls(parent, tabbedPropertySheetPage);
        this.createInternalVarsControls(parent);
        TableWidgetFactory.enableCopyPasteCut((Object)tabbedPropertySheetPage);
        OpenStructMenu.addTo((TableViewer)this.internalVarsViewer);
    }

    public void createInternalVarsControls(Composite parent) {
        Composite composite = this.getWidgetFactory().createComposite(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        AddDeleteReorderListWidget buttons = new AddDeleteReorderListWidget();
        buttons.createControls(composite, (FormToolkit)this.getWidgetFactory());
        this.internalVarsViewer = TableWidgetFactory.createTableViewer((Composite)composite);
        InternalVarsSection.configureTableLayout(this.internalVarsViewer.getTable());
        this.internalVarsViewer.setColumnProperties(new String[]{IV_NAME, IV_TYPE, IV_COMMENT, IV_INIT, IV_ARRAY});
        this.internalVarsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.internalVarsViewer.setLabelProvider((IBaseLabelProvider)new DataLabelProvider());
        this.internalVarsViewer.setCellModifier((ICellModifier)new InternalVarsCellModifier());
        buttons.bindToTableViewer(this.internalVarsViewer, (CommandExecutor)this, ref -> new CreateInternalVariableCommand(this.getType(), this.getInsertionIndex(), this.getName(), this.getDataType()), ref -> new DeleteInternalVariableCommand(this.getType(), (VarDeclaration)ref), ref -> new ChangeVariableOrderCommand(this.getType().getInternalVars(), (VarDeclaration)ref, true), ref -> new ChangeVariableOrderCommand(this.getType().getInternalVars(), (VarDeclaration)ref, false));
    }

    private DataType getDataType() {
        VarDeclaration varInternal = this.getLastSelectedVariable();
        return varInternal != null ? varInternal.getType() : null;
    }

    private String getName() {
        VarDeclaration varInternal = this.getLastSelectedVariable();
        return varInternal != null ? varInternal.getName() : null;
    }

    private int getInsertionIndex() {
        VarDeclaration varInternal = this.getLastSelectedVariable();
        if (varInternal == null) {
            return this.getType().getInternalVars().size();
        }
        return this.getType().getInternalVars().indexOf((Object)varInternal) + 1;
    }

    private VarDeclaration getLastSelectedVariable() {
        IStructuredSelection selection = this.internalVarsViewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return null;
        }
        return (VarDeclaration)selection.toList().get(selection.toList().size() - 1);
    }

    private static void configureTableLayout(Table table) {
        TableColumn column1 = new TableColumn(table, 16384);
        column1.setText(FordiacMessages.Name);
        TableColumn column2 = new TableColumn(table, 16384);
        column2.setText(FordiacMessages.Type);
        TableColumn column3 = new TableColumn(table, 16384);
        column3.setText(FordiacMessages.Comment);
        TableColumn column4 = new TableColumn(table, 16384);
        column4.setText(FordiacMessages.InitialValue);
        TableColumn column5 = new TableColumn(table, 16384);
        column5.setText(FordiacMessages.ArraySize);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(2, 30));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(2, 30));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 20));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 20));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(3, 50));
        table.setLayout((Layout)layout);
    }

    private CellEditor[] createCellEditors(Table table) {
        TextCellEditor varNameEditor = new TextCellEditor((Composite)table);
        ((Text)varNameEditor.getControl()).addVerifyListener((VerifyListener)new IdentifierVerifyListener());
        this.typeDropDown = new DataTypeDropdown(this.getDataTypeLib(), this.internalVarsViewer);
        return new CellEditor[]{varNameEditor, this.typeDropDown, new TextCellEditor((Composite)table), new TextCellEditor((Composite)table), new TextCellEditor((Composite)table)};
    }

    @Override
    protected void setInputCode() {
        this.internalVarsViewer.setCellModifier(null);
    }

    public void refresh() {
        CommandStack commandStackBuffer = this.commandStack;
        this.commandStack = null;
        if (this.type != null) {
            this.internalVarsViewer.setInput((Object)this.getType().getInternalVars());
        }
        this.commandStack = commandStackBuffer;
    }

    @Override
    protected void setInputInit() {
        this.internalVarsViewer.setCellEditors(this.createCellEditors(this.internalVarsViewer.getTable()));
    }

    public TableViewer getViewer() {
        return this.internalVarsViewer;
    }

    public Object getEntry(int index) {
        return this.getType().getInternalVars().get(index);
    }

    public void addEntry(Object entry, int index, CompoundCommand cmd) {
        if (entry instanceof VarDeclaration) {
            VarDeclaration varEntry = (VarDeclaration)entry;
            cmd.add((Command)new InsertVariableCommand(this.getType().getInternalVars(), varEntry, index));
        }
    }

    public Object removeEntry(int index, CompoundCommand cmd) {
        VarDeclaration entry = (VarDeclaration)this.getEntry(index);
        cmd.add((Command)new DeleteInternalVariableCommand(this.getType(), entry));
        return entry;
    }

    public void executeCompoundCommand(CompoundCommand cmd) {
        this.executeCommand((Command)cmd);
        this.getViewer().refresh();
    }

    private final class InternalVarsCellModifier
    implements ICellModifier {
        private InternalVarsCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            VarDeclaration varInternal = (VarDeclaration)element;
            switch (property) {
                case "NAME": {
                    return varInternal.getName();
                }
                case "TYPE": {
                    return varInternal.getTypeName();
                }
                case "COMMENT": {
                    return varInternal.getComment();
                }
                case "ARRAY_SIZE": {
                    return Integer.toString(varInternal.getArraySize());
                }
            }
            return varInternal.getValue() == null ? "" : varInternal.getValue().getValue();
        }

        public void modify(Object element, String property, Object value) {
            TableItem tableItem = (TableItem)element;
            VarDeclaration data = (VarDeclaration)tableItem.getData();
            ChangeValueCommand cmd = null;
            switch (property) {
                case "NAME": {
                    cmd = new ChangeNameCommand((INamedElement)data, value.toString());
                    break;
                }
                case "TYPE": {
                    DataType type = InternalVarsSection.this.typeDropDown.getType((String)value);
                    if (type == null) {
                        return;
                    }
                    cmd = new ChangeDataTypeCommand(data, type);
                    break;
                }
                case "COMMENT": {
                    cmd = new ChangeCommentCommand((INamedElement)data, value.toString());
                    break;
                }
                case "ARRAY_SIZE": {
                    cmd = new ChangeArraySizeCommand(data, value.toString());
                    break;
                }
                default: {
                    cmd = new ChangeValueCommand(data, value.toString());
                }
            }
            InternalVarsSection.this.executeCommand((Command)cmd);
            InternalVarsSection.this.internalVarsViewer.refresh((Object)data);
        }
    }
}

