/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.properties;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.gef.properties.AbstractEditInterfaceSection;
import org.eclipse.fordiac.ide.model.Palette.AdapterTypePaletteEntry;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.viewers.IContentProvider;

public abstract class AbstractEditInterfaceAdapterSection
extends AbstractEditInterfaceSection {
    @Override
    protected IContentProvider getOutputsContentProvider() {
        return new AdapterInterfaceContentProvider(false);
    }

    @Override
    protected IContentProvider getInputsContentProvider() {
        return new AdapterInterfaceContentProvider(true);
    }

    @Override
    protected String[] fillTypeCombo() {
        ArrayList list = new ArrayList();
        if (this.getType() != null && this.getPalette() != null) {
            this.getPalette().getAdapterTypesSorted().forEach(adpType -> {
                boolean bl = list.add(adpType.getLabel());
            });
        }
        return list.toArray(new String[list.size()]);
    }

    protected AdapterType getLastUsedAdapterType(InterfaceList interfaceList, IInterfaceElement interfaceElement, boolean isInput) {
        if (interfaceElement != null) {
            return (AdapterType)interfaceElement.getType();
        }
        EList<AdapterDeclaration> adapterList = AbstractEditInterfaceAdapterSection.getAdapterList(interfaceList, isInput);
        if (!adapterList.isEmpty()) {
            return ((AdapterDeclaration)adapterList.get(adapterList.size() - 1)).getType();
        }
        return ((AdapterTypePaletteEntry)((Map.Entry)this.getPalette().getAdapterTypes().get(0)).getValue()).getType();
    }

    @Override
    protected int getInsertingIndex(IInterfaceElement interfaceElement, boolean isInput) {
        if (interfaceElement != null) {
            InterfaceList interfaceList = (InterfaceList)interfaceElement.eContainer();
            return this.getInsertingIndex(interfaceElement, AbstractEditInterfaceAdapterSection.getAdapterList(interfaceList, isInput));
        }
        return -1;
    }

    private static EList<AdapterDeclaration> getAdapterList(InterfaceList interfaceList, boolean isInput) {
        return isInput ? interfaceList.getSockets() : interfaceList.getPlugs();
    }

    public void addEntry(Object entry, int index, CompoundCommand cmd) {
        if (entry instanceof AdapterDeclaration) {
            cmd.add((Command)this.newInsertCommand((IInterfaceElement)((AdapterDeclaration)entry), this.isInputsViewer(), index));
        }
    }

    protected static class AdapterInterfaceContentProvider
    extends AbstractEditInterfaceSection.InterfaceContentProvider {
        public AdapterInterfaceContentProvider(boolean inputs) {
            super(inputs);
        }

        @Override
        protected Object[] getInputs(Object inputElement) {
            InterfaceList interfaceList = AdapterInterfaceContentProvider.getInterfaceListFromInput(inputElement);
            if (interfaceList != null) {
                return interfaceList.getSockets().toArray();
            }
            return new Object[0];
        }

        @Override
        protected Object[] getOutputs(Object inputElement) {
            InterfaceList interfaceList = AdapterInterfaceContentProvider.getInterfaceListFromInput(inputElement);
            if (interfaceList != null) {
                return interfaceList.getPlugs().toArray();
            }
            return new Object[0];
        }
    }
}

