/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.handles;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.gef.policies.ModifiedMoveHandle;
import org.eclipse.fordiac.ide.gef.tools.ScrollingConnectionEndpointTracker;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.handles.ConnectionEndpointHandle;
import org.eclipse.gef.tools.ConnectionEndpointTracker;

public class ScrollingConnectionEndpointHandle
extends ConnectionEndpointHandle {
    public ScrollingConnectionEndpointHandle(ConnectionEditPart owner, int endPoint) {
        super(owner, endPoint);
    }

    protected void init() {
        super.init();
        this.setPreferredSize(13, 13);
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension dim = super.getPreferredSize(wHint, hHint).getCopy();
        double zoomFactor = this.getZoomFactor();
        if ((double)dim.height * zoomFactor < 5.0) {
            dim.height = (int)(5.0 / zoomFactor);
        }
        if ((double)dim.width * zoomFactor < 5.0) {
            dim.width = (int)(5.0 / zoomFactor);
        }
        return dim;
    }

    protected double getZoomFactor() {
        return ((ScalableFreeformRootEditPart)this.getOwner().getRoot()).getZoomManager().getZoom();
    }

    protected DragTracker createDragTracker() {
        if (this.isFixed()) {
            return null;
        }
        ConnectionEndpointTracker tracker = this.createConnectionEndPointTracker((ConnectionEditPart)this.getOwner());
        if (this.getEndPoint() == 2) {
            tracker.setCommandName("Reconnection source");
        } else {
            tracker.setCommandName("Reconnection target");
        }
        tracker.setDefaultCursor(this.getCursor());
        return tracker;
    }

    protected ConnectionEndpointTracker createConnectionEndPointTracker(ConnectionEditPart connectionEditPart) {
        return new ScrollingConnectionEndpointTracker(connectionEditPart);
    }

    public void paintFigure(Graphics g) {
        Rectangle r = this.getBounds().getShrinked(1, 1);
        g.setLineStyle(1);
        g.setLineWidth(2);
        g.setXORMode(false);
        g.setForegroundColor(ModifiedMoveHandle.getSelectionColor());
        g.setBackgroundColor(ModifiedMoveHandle.getSelectionColor());
        if (this.isPrimary()) {
            g.drawRoundRectangle(r, 5, 5);
        }
        g.setAlpha(50);
        g.fillRoundRectangle(r, 5, 5);
        g.setAlpha(255);
        this.paintHandleCenter(g, r);
    }

    protected void paintHandleCenter(Graphics g, Rectangle r) {
        int shrinkVal = this.getInnerShrinkVal();
        r.shrink(shrinkVal, shrinkVal);
        g.fillRoundRectangle(r, r.height / 2, r.height / 2);
    }

    protected int getInnerShrinkVal() {
        int shrinkVal = 2;
        if ((double)shrinkVal * this.getZoomFactor() < 2.0) {
            shrinkVal = (int)(2.0 / this.getZoomFactor());
        }
        return shrinkVal;
    }
}

