/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.figures;

import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Geometry;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.model.data.AnyType;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterConnection;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.DataConnection;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.util.ColorHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

public class HideableConnection
extends PolylineConnection {
    private static final int CONNECTION_SELECTION_TOLERANCE = 6;
    public static final int BEND_POINT_BEVEL_SIZE = 5;
    private static final int NORMAL_DOUBLE_LINE_WIDTH = 3;
    private static final int DOUBLE_LINE_AMPLIFICATION = 2;
    private boolean hidden = false;
    private String label = "";
    private final Rectangle moveRect = new Rectangle();
    private Connection model;
    private Color lighterColor;

    public void setModel(Connection newModel) {
        this.model = newModel;
    }

    public Connection getModel() {
        return this.model;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void setForegroundColor(Color fg) {
        super.setForegroundColor(fg);
        if (this.isAdapterConnectionOrStructConnection()) {
            this.lighterColor = ColorHelper.lighter((Color)fg);
        }
    }

    protected void outlineShape(Graphics g) {
        if (this.isHidden()) {
            int[] startLine = new int[]{this.getStart().x, this.getStart().y, this.getStart().x + 20, this.getStart().y};
            int[] endLine = new int[]{this.getEnd().x, this.getEnd().y, this.getEnd().x - 20, this.getEnd().y};
            g.drawPolyline(startLine);
            g.drawPolyline(endLine);
            Dimension dim = FigureUtilities.getTextExtents((String)this.label, (Font)g.getFont());
            g.drawText(this.label, new Point(this.getEnd().x - dim.width - 25, this.getEnd().y - dim.height / 2));
            this.moveRect.x = this.getEnd().x - dim.width - 25;
            this.moveRect.y = this.getEnd().y - dim.height / 2;
            this.moveRect.width = 5;
            this.moveRect.height = 5;
        } else if (this.isAdapterConnectionOrStructConnection()) {
            this.drawDoublePolyline(g, this.getBeveledPoints());
        } else {
            g.drawPolyline(this.getBeveledPoints());
        }
    }

    private boolean isAdapterConnectionOrStructConnection() {
        if (this.model instanceof DataConnection) {
            DataType dataType;
            IInterfaceElement refElement = this.model.getSource();
            if (refElement == null) {
                refElement = this.model.getDestination();
            }
            if ((dataType = refElement.getType()) instanceof AnyType && dataType == IecTypes.GenericTypes.ANY && refElement == this.model.getSource()) {
                refElement = this.getModel().getDestination();
            }
            return refElement != null && refElement.getType() instanceof StructuredType;
        }
        return this.model instanceof AdapterConnection;
    }

    private void drawDoublePolyline(Graphics g, PointList beveledPoints) {
        g.drawPolyline(beveledPoints);
        g.setLineWidth(this.getLineWidth() / 3);
        if (g.getAbsoluteScale() >= 1.0) {
            g.setForegroundColor(this.lighterColor);
            g.drawPolyline(beveledPoints);
        }
    }

    public Rectangle getBounds() {
        return super.getBounds().getExpanded(2, 2);
    }

    public void setLineWidth(int w) {
        int width = w;
        if (this.isAdapterConnectionOrStructConnection()) {
            width = Math.max(w * 2, 3);
        }
        super.setLineWidth(width);
    }

    protected boolean shapeContainsPoint(int x, int y) {
        return Geometry.polylineContainsPoint((PointList)this.getPoints(), (int)x, (int)y, (int)(this.getLineWidth() + 6));
    }

    private PointList getBeveledPoints() {
        PointList beveledPoints = new PointList();
        beveledPoints.addPoint(this.getPoints().getFirstPoint());
        int i = 1;
        while (i < this.getPoints().size() - 1) {
            Point before = this.getPoints().getPoint(i - 1);
            Point after = this.getPoints().getPoint(i + 1);
            int verDistance = Math.abs(before.y - after.y);
            int horDistance = Math.abs(before.y - after.y);
            int bevelSize = 5;
            if (verDistance < 10) {
                bevelSize = verDistance / 2;
            }
            if (horDistance < 10) {
                bevelSize = horDistance / 2;
            }
            beveledPoints.addPoint(HideableConnection.calculatedBeveledPoint(this.getPoints().getPoint(i), before, bevelSize));
            beveledPoints.addPoint(HideableConnection.calculatedBeveledPoint(this.getPoints().getPoint(i), after, bevelSize));
            ++i;
        }
        beveledPoints.addPoint(this.getPoints().getLastPoint());
        return beveledPoints;
    }

    private static Point calculatedBeveledPoint(Point refPoint, Point otherPoint, int bevelSize) {
        if (refPoint.x - otherPoint.x == 0) {
            return new Point(refPoint.x, refPoint.y + (refPoint.y - otherPoint.y > 0 ? -bevelSize : bevelSize));
        }
        return new Point(refPoint.x + (refPoint.x - otherPoint.x > 0 ? -bevelSize : bevelSize), refPoint.y);
    }
}

