/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.editors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.AlignmentRetargetAction;
import org.eclipse.gef.ui.actions.DeleteRetargetAction;
import org.eclipse.gef.ui.actions.RedoRetargetAction;
import org.eclipse.gef.ui.actions.UndoRetargetAction;
import org.eclipse.gef.ui.actions.ZoomComboContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.RetargetAction;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;

public class GraphicalMultipageEditorContributor
extends MultiPageEditorActionBarContributor {
    private ActionRegistry registry = new ActionRegistry();
    private List<RetargetAction> retargetActions = new ArrayList<RetargetAction>();
    private List<String> globalActionKeys = new ArrayList<String>();
    private ZoomComboContributionItem zoomCombo;

    public void setActiveEditor(IEditorPart editor) {
        this.setGlobalActionHandler((ActionRegistry)editor.getAdapter(ActionRegistry.class));
        super.setActiveEditor(editor);
    }

    public void setActivePage(IEditorPart activeEditor) {
        if (activeEditor != null) {
            this.setGlobalActionHandler((ActionRegistry)activeEditor.getAdapter(ActionRegistry.class));
            this.zoomCombo.setZoomManager((ZoomManager)activeEditor.getAdapter(ZoomManager.class));
        }
    }

    private void setGlobalActionHandler(ActionRegistry editorRegistry) {
        IActionBars bars = this.getActionBars();
        for (String id : this.globalActionKeys) {
            if (editorRegistry != null) {
                bars.setGlobalActionHandler(id, editorRegistry.getAction((Object)id));
                continue;
            }
            bars.setGlobalActionHandler(id, null);
        }
    }

    protected void buildActions() {
        this.addRetargetAction((RetargetAction)new UndoRetargetAction());
        this.addRetargetAction((RetargetAction)new RedoRetargetAction());
        this.addRetargetAction((RetargetAction)new DeleteRetargetAction());
        this.addRetargetAction((RetargetAction)new AlignmentRetargetAction(1));
        this.addRetargetAction((RetargetAction)new AlignmentRetargetAction(2));
        this.addRetargetAction((RetargetAction)new AlignmentRetargetAction(4));
        this.addRetargetAction((RetargetAction)new AlignmentRetargetAction(8));
        this.addRetargetAction((RetargetAction)new AlignmentRetargetAction(16));
        this.addRetargetAction((RetargetAction)new AlignmentRetargetAction(32));
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        toolBarManager.add(this.getAction(ActionFactory.UNDO.getId()));
        toolBarManager.add(this.getAction(ActionFactory.REDO.getId()));
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IContributionItem)new Separator());
        String[] zoomStrings = new String[]{ZoomManager.FIT_ALL, ZoomManager.FIT_HEIGHT, ZoomManager.FIT_WIDTH};
        this.zoomCombo = new ZoomComboContributionItem((IPartService)this.getPage(), zoomStrings);
        toolBarManager.add((IContributionItem)this.zoomCombo);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add(this.getAction("org.eclipse.gef.align_left"));
        toolBarManager.add(this.getAction("org.eclipse.gef.align_center"));
        toolBarManager.add(this.getAction("org.eclipse.gef.align_right"));
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add(this.getAction("org.eclipse.gef.align_top"));
        toolBarManager.add(this.getAction("org.eclipse.gef.align_middle"));
        toolBarManager.add(this.getAction("org.eclipse.gef.align_bottom"));
    }

    protected IAction getAction(String id) {
        return this.getActionRegistry().getAction((Object)id);
    }

    protected ActionRegistry getActionRegistry() {
        return this.registry;
    }

    protected void addRetargetAction(RetargetAction action) {
        this.addAction((IAction)action);
        this.retargetActions.add(action);
        this.getPage().addPartListener((IPartListener)action);
        this.addGlobalActionKey(action.getId());
    }

    protected void addAction(IAction action) {
        this.getActionRegistry().registerAction(action);
    }

    protected void addGlobalActionKey(String key) {
        this.globalActionKeys.add(key);
    }

    protected void declareGlobalActionKeys() {
        this.addGlobalActionKey(ActionFactory.SELECT_ALL.getId());
    }

    public void init(IActionBars bars) {
        this.buildActions();
        this.declareGlobalActionKeys();
        super.init(bars);
    }
}

