/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.draw2d;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Insets;

public class AdvancedLineBorder
extends LineBorder {
    private static final int ALPHA_MAX_VALUE = 255;
    private int side = 0;
    private int style = 1;
    private int alpha = 255;

    public AdvancedLineBorder(int side) {
        this.side = side;
    }

    public AdvancedLineBorder(int side, int style) {
        this.side = side;
        this.style = style;
    }

    public AdvancedLineBorder() {
    }

    public Insets getInsets(IFigure figure) {
        int north = 0;
        int east = 0;
        int south = 0;
        int west = 0;
        if ((this.side & 1) != 0) {
            north = this.getWidth();
        }
        if ((this.side & 0x10) != 0) {
            east = this.getWidth();
        }
        if ((this.side & 4) != 0) {
            south = this.getWidth();
        }
        if ((this.side & 8) != 0) {
            west = this.getWidth();
        }
        return new Insets(north, west, south, east);
    }

    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        graphics.setAlpha(this.alpha);
        tempRect.setBounds(AdvancedLineBorder.getPaintRectangle((IFigure)figure, (Insets)insets));
        graphics.setLineWidth(this.getWidth());
        if (this.getColor() != null) {
            graphics.setForegroundColor(this.getColor());
        }
        graphics.setLineStyle(this.style);
        int yLowerBound = AdvancedLineBorder.tempRect.y + AdvancedLineBorder.tempRect.height - this.getWidth() / 4;
        if ((this.side & 1) != 0) {
            graphics.drawLine(AdvancedLineBorder.tempRect.x, AdvancedLineBorder.tempRect.y, AdvancedLineBorder.tempRect.x + AdvancedLineBorder.tempRect.width, AdvancedLineBorder.tempRect.y);
        }
        if ((this.side & 0x10) != 0) {
            int xRightBound = AdvancedLineBorder.tempRect.x + AdvancedLineBorder.tempRect.width - this.getWidth() / 4;
            graphics.drawLine(xRightBound, AdvancedLineBorder.tempRect.y, xRightBound, yLowerBound);
        }
        if ((this.side & 4) != 0) {
            graphics.drawLine(AdvancedLineBorder.tempRect.x, yLowerBound, AdvancedLineBorder.tempRect.x + AdvancedLineBorder.tempRect.width, yLowerBound);
        }
        if ((this.side & 8) != 0) {
            graphics.drawLine(AdvancedLineBorder.tempRect.x, AdvancedLineBorder.tempRect.y, AdvancedLineBorder.tempRect.x, yLowerBound);
        }
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public void setAlpha(int alpha) {
        if (this.alpha != alpha) {
            this.alpha = alpha;
        }
    }

    public int getAlpha() {
        return this.alpha;
    }

    public boolean isOpaque() {
        return this.alpha >= 255;
    }
}

