/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.FreeformViewport;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.parts.ScrollableThumbnail;
import org.eclipse.draw2d.parts.Thumbnail;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class DiagramOutlinePage
extends Page
implements IContentOutlinePage,
IAdaptable {
    private static final int THUMBNAIL_BORDER_MARGIN = 3;
    private PageBook pageBook;
    private Canvas overview;
    private LightweightSystem lws;
    private Thumbnail thumbnail;
    private DisposeListener disposeListener = ev -> this.removeThumbnail();
    private GraphicalViewer graphicalViewer;

    public DiagramOutlinePage(GraphicalViewer graphicalViewer) {
        this.graphicalViewer = graphicalViewer;
    }

    public void createControl(Composite parent) {
        this.pageBook = new PageBook(parent, 0);
        this.overview = new Canvas((Composite)this.pageBook, 0);
        this.lws = new LightweightSystem(this.overview);
        this.pageBook.showPage((Control)this.overview);
        if (this.thumbnail == null) {
            GraphicalViewer viewer = this.getGraphicalViewer();
            this.graphicalViewer = null;
            this.viewerChanged(viewer);
        }
    }

    public void dispose() {
        this.removeThumbnail();
        this.removeDisposeListener();
        super.dispose();
    }

    public Control getControl() {
        return this.pageBook;
    }

    private void removeThumbnail() {
        if (this.thumbnail != null) {
            this.thumbnail.deactivate();
            this.thumbnail = null;
        }
    }

    private void removeDisposeListener() {
        if (this.graphicalViewer != null) {
            this.getViewerControl().removeDisposeListener(this.disposeListener);
        }
    }

    public void viewerChanged(GraphicalViewer graphicalViewer) {
        this.removeThumbnail();
        this.removeDisposeListener();
        this.graphicalViewer = graphicalViewer;
        this.thumbnail = this.createNewThumbnail();
        if (this.thumbnail != null) {
            this.thumbnail.setVisible(true);
        }
        if (!this.overview.isDisposed()) {
            this.overview.redraw();
        }
    }

    private Thumbnail createNewThumbnail() {
        RootEditPart rep;
        if (this.graphicalViewer != null && (rep = this.graphicalViewer.getRootEditPart()) instanceof ScalableFreeformRootEditPart) {
            ScalableFreeformRootEditPart root = (ScalableFreeformRootEditPart)rep;
            FreeformViewport viewport = (FreeformViewport)root.getFigure();
            ScrollableThumbnail newThumbnail = new ScrollableThumbnail((Viewport)viewport);
            newThumbnail.setBorder((Border)new MarginBorder(3));
            newThumbnail.setSource(viewport.getContents());
            this.lws.setContents((IFigure)newThumbnail);
            this.getViewerControl().addDisposeListener(e -> this.removeThumbnail());
            return newThumbnail;
        }
        return null;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == ZoomManager.class && this.getGraphicalViewer() != null) {
            return adapter.cast(this.getGraphicalViewer().getProperty(ZoomManager.class.toString()));
        }
        return null;
    }

    public void setFocus() {
        if (this.getControl() != null) {
            this.getControl().setFocus();
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public ISelection getSelection() {
        return null;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public void setSelection(ISelection selection) {
    }

    protected GraphicalViewer getGraphicalViewer() {
        return this.graphicalViewer;
    }

    protected FigureCanvas getViewerControl() {
        return (FigureCanvas)this.getGraphicalViewer().getControl();
    }
}

