/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemmanagement.changelistener;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.fordiac.ide.model.NameRepository;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.dataexport.AbstractTypeExporter;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.systemmanagement.Activator;
import org.eclipse.fordiac.ide.systemmanagement.ISystemEditor;
import org.eclipse.fordiac.ide.systemmanagement.Messages;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.fordiac.ide.systemmanagement.changelistener.IEditorFileChangeListener;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;
import org.eclipse.fordiac.ide.ui.editors.FordiacEditorMatchingStrategy;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class FordiacResourceChangeListener
implements IResourceChangeListener {
    private final SystemManager systemManager;
    private final Collection<PaletteEntry> changedFiles;
    IResourceDeltaVisitor visitor = delta -> {
        switch (delta.getKind()) {
            case 4: {
                return this.handleResourceChanged(delta);
            }
            case 2: {
                return this.handleResourceRemoved(delta);
            }
            case 1: {
                if (4096 == (delta.getFlags() & 0x1000)) {
                    return this.handleResourceMovedFrom(delta);
                }
                return this.handleResourceCopy(delta);
            }
        }
        return true;
    };
    static final Pattern systemNamePattern = Pattern.compile("\\<System\\p{javaWhitespace}+(Comment=\".*\"\\p{javaWhitespace}+)?Name=\"([^\"]*)");
    private static FordiacEditorMatchingStrategy editorMatching = new FordiacEditorMatchingStrategy();

    public FordiacResourceChangeListener(SystemManager systemManager) {
        this.systemManager = systemManager;
        this.changedFiles = new HashSet<PaletteEntry>();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 1) {
            IResourceDelta rootDelta = event.getDelta();
            try {
                rootDelta.accept(this.visitor);
                if (!this.changedFiles.isEmpty()) {
                    this.handleChangedFiles();
                }
            }
            catch (CoreException e) {
                Activator.getDefault().logError("Couldn't process resource delta", (Exception)((Object)e));
            }
        }
    }

    private void handleChangedFiles() {
        Display.getDefault().syncExec(() -> {
            List<IEditorPart> changedOpenedDirtyEditors = this.collectOpenedEditors();
            List<IEditorFileChangeListener> editorListener = changedOpenedDirtyEditors.stream().filter(IEditorFileChangeListener.class::isInstance).map(IEditorFileChangeListener.class::cast).collect(Collectors.toList());
            this.changedFiles.clear();
            FordiacResourceChangeListener.handleFileRefreshWIzards(editorListener);
        });
    }

    private static void handleFileRefreshWIzards(List<IEditorFileChangeListener> editorListener) {
        int code = -1;
        for (IEditorFileChangeListener editor : editorListener) {
            if (!((IEditorPart)editor).isDirty()) {
                editor.reloadFile();
                continue;
            }
            if (code == -1) {
                code = FordiacResourceChangeListener.openFileChangedDialog(editor);
            }
            switch (code) {
                case 0: {
                    editor.reloadFile();
                    code = -1;
                    break;
                }
                case 1: {
                    editor.reloadFile();
                    break;
                }
                case 2: {
                    code = -1;
                    break;
                }
                case 3: {
                    return;
                }
                default: {
                    Activator.getDefault().logError(String.valueOf(code) + " is not a valid dialog output");
                }
            }
        }
    }

    public static int openFileChangedDialog(IEditorFileChangeListener editor) {
        IFile file = editor.getFile();
        String info = MessageFormat.format(Messages.AutomationSystemEditor_Info, file.getFullPath().toOSString());
        MessageDialog dialog = new MessageDialog(((IEditorPart)editor).getSite().getShell(), Messages.AutomationSystemEditor_Title, null, info, 2, new String[]{Messages.FordiacResourceChangeListener_0, Messages.FordiacResourceChangeListener_1, Messages.FordiacResourceChangeListener_2, Messages.FordiacResourceChangeListener_3}, 0);
        return dialog.open();
    }

    private List<IEditorPart> collectOpenedEditors() {
        ArrayList<IEditorPart> changedOpenedDirtyEditors = new ArrayList<IEditorPart>();
        IEditorPart activeEditor = null;
        for (PaletteEntry entry : this.changedFiles) {
            IEditorPart findEditor = EditorUtils.findEditor(editor -> editor.getEditorInput() instanceof FileEditorInput && ((FileEditorInput)editor.getEditorInput()).getFile().equals((Object)entry.getFile()));
            if (findEditor == EditorUtils.getCurrentActiveEditor()) {
                activeEditor = findEditor;
                findEditor = null;
            }
            if (findEditor == null) continue;
            changedOpenedDirtyEditors.add(findEditor);
        }
        if (activeEditor != null) {
            changedOpenedDirtyEditors.add(0, activeEditor);
        }
        return changedOpenedDirtyEditors;
    }

    private static boolean isSystemFile(IFile file) {
        return "sys".equalsIgnoreCase(file.getFileExtension());
    }

    private boolean handleResourceChanged(IResourceDelta delta) {
        if (FordiacResourceChangeListener.isFileChange(delta)) {
            this.collectPaletteEntries(delta);
        } else if (16384 == delta.getFlags()) {
            if (delta.getAffectedChildren(1).length != 0) {
                this.systemManager.notifyListeners();
            } else if (delta.getAffectedChildren(2).length != 0) {
                this.handleProjectRemove(delta);
                return false;
            }
        } else if (delta.getResource().getType() == 4) {
            return this.checkForErrorMarkerChanges(delta);
        }
        return true;
    }

    public boolean checkForErrorMarkerChanges(IResourceDelta delta) {
        IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
        int n = iResourceDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta d = iResourceDeltaArray[n2];
            if (131072 == (d.getFlags() & 0x20000)) {
                this.systemManager.notifyListeners();
                return false;
            }
            ++n2;
        }
        return true;
    }

    private void collectPaletteEntries(IResourceDelta delta) {
        IFile file = (IFile)delta.getResource();
        PaletteEntry paletteEntryForFile = TypeLibrary.getPaletteEntryForFile((IFile)file);
        if (paletteEntryForFile == null) {
            paletteEntryForFile = this.systemManager.getPaletteEntry(file);
        }
        if (paletteEntryForFile != null && paletteEntryForFile.getLastModificationTimestamp() != file.getModificationStamp()) {
            this.changedFiles.add(paletteEntryForFile);
        }
    }

    private static boolean isFileChange(IResourceDelta delta) {
        return delta.getResource().getType() == 1 && delta.getFlags() != 131072;
    }

    private boolean handleResourceRemoved(IResourceDelta delta) {
        if (delta.getFlags() == 8192) {
            return false;
        }
        switch (delta.getResource().getType()) {
            case 1: {
                this.handleFileDelete(delta);
                break;
            }
            case 4: {
                this.handleProjectRemove(delta);
                return false;
            }
        }
        return true;
    }

    private boolean handleResourceMovedFrom(IResourceDelta delta) {
        switch (delta.getResource().getType()) {
            case 1: {
                this.handleFileMove(delta);
                break;
            }
            case 4: {
                this.handleProjectRename(delta);
                break;
            }
        }
        return true;
    }

    private boolean handleResourceCopy(IResourceDelta delta) {
        switch (delta.getResource().getType()) {
            case 1: {
                this.handleFileCopy(delta);
                break;
            }
            case 2: {
                return true;
            }
            case 4: {
                return true;
            }
        }
        return false;
    }

    private void handleFileDelete(IResourceDelta delta) {
        TypeLibrary typeLib = TypeLibrary.getTypeLibrary((IProject)delta.getResource().getProject());
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(delta.getResource().getFullPath());
        if (FordiacResourceChangeListener.isSystemFile(file)) {
            this.systemManager.removeSystem(file);
        } else {
            PaletteEntry entry = TypeLibrary.getPaletteEntryForFile((IFile)file);
            if (entry != null) {
                FordiacResourceChangeListener.closeAllEditorsForFile(file);
                typeLib.removePaletteEntry(entry);
            }
        }
    }

    private void handleFileCopy(IResourceDelta delta) {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(delta.getResource().getFullPath());
        if (file.getProject().isOpen() && delta.getFlags() != 131072) {
            if (FordiacResourceChangeListener.isSystemFile(file)) {
                this.renameSystemFileCopy(file);
            } else {
                TypeLibrary typeLib = TypeLibrary.getTypeLibrary((IProject)delta.getResource().getProject());
                PaletteEntry paletteEntryForFile = TypeLibrary.getPaletteEntryForFile((IFile)file);
                if (paletteEntryForFile == null) {
                    PaletteEntry entry = typeLib.createPaletteEntry(file);
                    if (entry != null) {
                        FordiacResourceChangeListener.updatePaletteEntry(file, entry);
                    }
                } else if (!file.equals((Object)paletteEntryForFile.getFile())) {
                    FordiacResourceChangeListener.autoRenameExistingType(file, paletteEntryForFile);
                }
            }
        }
    }

    protected static void autoRenameExistingType(final IFile file, final PaletteEntry paletteEntryForFile) {
        WorkspaceJob job = new WorkspaceJob(String.valueOf(Messages.FordiacResourceChangeListener_4) + file.getName()){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                LibraryElement type = paletteEntryForFile.getType();
                String oldName = type.getName();
                String newName = NameRepository.createUniqueTypeName((LibraryElement)type);
                if (newName == null || newName.equals(oldName)) {
                    return Status.CANCEL_STATUS;
                }
                String oldPath = file.getFullPath().toOSString();
                String newPath = FordiacResourceChangeListener.replaceLast(oldPath, oldName, newName);
                try {
                    file.move((IPath)new Path(newPath), true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)file.getProject());
        job.schedule();
    }

    public static String replaceLast(String text, String regex, String replacement) {
        return text.replaceFirst("(?s)(.*)" + regex, "$1" + replacement);
    }

    private void renameSystemFileCopy(final IFile file) {
        WorkspaceJob job = new WorkspaceJob(String.valueOf(Messages.FordiacResourceChangeListener_5) + file.getName()){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                AutomationSystem system;
                boolean wrongName = false;
                String newTypeName = TypeLibrary.getTypeNameFromFile((IFile)file);
                try {
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (Scanner scanner = new Scanner(file.getContents());){
                        String name = scanner.findWithinHorizon(systemNamePattern, 0);
                        wrongName = name != null && !name.endsWith("\"" + newTypeName);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    Activator.getDefault().logError(e.getMessage(), e);
                }
                if (wrongName && (system = FordiacResourceChangeListener.this.systemManager.getSystem(file)) != null && !newTypeName.equals(system.getName())) {
                    system.setName(TypeLibrary.getTypeNameFromFile((IFile)file));
                    SystemManager.saveSystem(system);
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)file.getProject());
        job.schedule();
    }

    private void handleProjectRename(IResourceDelta delta) {
        IProject oldProject = ResourcesPlugin.getWorkspace().getRoot().getProject(delta.getMovedFromPath().lastSegment());
        IProject newProject = delta.getResource().getProject();
        TypeLibrary.renameProject((IProject)oldProject, (IProject)newProject);
        this.systemManager.renameProject(oldProject, newProject);
    }

    private void handleFileMove(IResourceDelta delta) {
        IFile src = ResourcesPlugin.getWorkspace().getRoot().getFile(delta.getMovedFromPath());
        if (src.getParent().equals((Object)delta.getResource().getParent())) {
            this.handleFileRename(delta, src);
        } else {
            IFile dst = ResourcesPlugin.getWorkspace().getRoot().getFile(delta.getResource().getFullPath());
            if (!src.getProject().equals((Object)dst.getProject())) {
                if (src.getProject().exists()) {
                    this.handleFileMoveBetweenProjects(src, dst);
                } else {
                    this.handleFileAfterProjectRename(src, dst);
                }
            } else {
                PaletteEntry entry = TypeLibrary.getPaletteEntryForFile((IFile)src);
                if (entry != null) {
                    entry.setFile(dst);
                }
            }
            FordiacResourceChangeListener.updateEditorInput(src, dst);
        }
    }

    private void handleFileMoveBetweenProjects(IFile src, IFile dst) {
        if (FordiacResourceChangeListener.isSystemFile(src)) {
            this.systemManager.moveSystemToNewProject(src, dst);
        } else {
            TypeLibrary srcTypeLib = TypeLibrary.getTypeLibrary((IProject)src.getProject());
            PaletteEntry entry = srcTypeLib.getPaletteEntry(src);
            if (entry != null) {
                srcTypeLib.removePaletteEntry(entry);
                entry.setFile(dst);
                TypeLibrary dstTypeLib = TypeLibrary.getTypeLibrary((IProject)src.getProject());
                dstTypeLib.addPaletteEntry(entry);
            }
        }
    }

    private void handleFileAfterProjectRename(IFile src, IFile dst) {
        if (FordiacResourceChangeListener.isSystemFile(src)) {
            this.systemManager.updateSystemFile(dst.getProject(), src, dst);
        } else {
            TypeLibrary typeLib = TypeLibrary.getTypeLibrary((IProject)dst.getProject());
            PaletteEntry entry = typeLib.getPaletteEntry(src);
            if (entry == null) {
                typeLib.createPaletteEntry(dst);
            } else {
                entry.setFile(dst);
            }
        }
    }

    private void handleFileRename(IResourceDelta delta, IFile src) {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(delta.getResource().getFullPath());
        if (FordiacResourceChangeListener.isSystemFile(file)) {
            this.renameSystemFile(file);
        } else {
            FordiacResourceChangeListener.handleTypeRename(delta, src, file);
        }
        this.systemManager.notifyListeners();
    }

    private static void handleTypeRename(IResourceDelta delta, IFile src, IFile file) {
        TypeLibrary typeLibrary = TypeLibrary.getTypeLibrary((IProject)delta.getResource().getProject());
        PaletteEntry entry = TypeLibrary.getPaletteEntryForFile((IFile)src);
        if (src.equals((Object)entry.getFile())) {
            FordiacResourceChangeListener.updatePaletteEntry(file, entry);
        } else {
            FordiacResourceChangeListener.updatePaletteEntry(file, typeLibrary.createPaletteEntry(file));
        }
    }

    private void renameSystemFile(final IFile file) {
        WorkspaceJob job = new WorkspaceJob(String.valueOf(Messages.FordiacResourceChangeListener_7) + file.getName()){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                String newTypeName;
                AutomationSystem system = FordiacResourceChangeListener.this.systemManager.getSystem(file);
                if (system != null && !(newTypeName = TypeLibrary.getTypeNameFromFile((IFile)file)).equals(system.getName())) {
                    system.setName(TypeLibrary.getTypeNameFromFile((IFile)file));
                    SystemManager.saveSystem(system);
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)file.getProject());
        job.schedule();
    }

    private static void updatePaletteEntry(IFile newFile, final PaletteEntry entry) {
        if (entry != null) {
            final String newTypeName = TypeLibrary.getTypeNameFromFile((IFile)newFile);
            entry.getTypeLibrary().removePaletteEntry(entry);
            entry.setLabel(newTypeName);
            entry.setFile(newFile);
            entry.getTypeLibrary().addPaletteEntry(entry);
            WorkspaceJob job = new WorkspaceJob("Save Renamed type: " + entry.getLabel()){

                public IStatus runInWorkspace(IProgressMonitor monitor) {
                    LibraryElement type = entry.getType();
                    if (type != null && !newTypeName.equals(type.getName())) {
                        type.setName(newTypeName);
                        this.saveType(entry);
                    }
                    return Status.OK_STATUS;
                }

                private void saveType(PaletteEntry entry2) {
                    AbstractTypeExporter.saveType((PaletteEntry)entry2);
                }
            };
            job.setRule((ISchedulingRule)newFile.getProject());
            job.schedule();
        }
    }

    private void handleProjectRemove(IResourceDelta delta) {
        IProject project = delta.getResource().getProject();
        FordiacResourceChangeListener.closeAllProjectRelatedEditors(project);
        this.systemManager.removeProject(project);
        TypeLibrary.removeProject((IProject)project);
    }

    private static void closeAllProjectRelatedEditors(IProject project) {
        Display.getDefault().asyncExec(() -> EditorUtils.closeEditorsFiltered(editor -> {
            IEditorInput input = editor.getEditorInput();
            if (input instanceof FileEditorInput && project.equals((Object)((FileEditorInput)input).getFile().getProject())) {
                return true;
            }
            if (editor instanceof ISystemEditor) {
                AutomationSystem system = ((ISystemEditor)editor).getSystem();
                return project.equals((Object)system.getSystemFile().getProject());
            }
            return false;
        }));
    }

    private static void closeAllEditorsForFile(IFile file) {
        Display.getDefault().asyncExec(() -> EditorUtils.closeEditorsFiltered(editor -> {
            IEditorInput input = editor.getEditorInput();
            return input instanceof FileEditorInput && file.equals((Object)((FileEditorInput)input).getFile());
        }));
    }

    private static void updateEditorInput(IFile src, IFile dst) {
        Display.getDefault().syncExec(() -> {
            IEditorReference[] editorReferences;
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IEditorReference[] iEditorReferenceArray = editorReferences = activePage.getEditorReferences();
            int n = editorReferences.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference editorReference = iEditorReferenceArray[n2];
                IEditorPart editor = editorReference.getEditor(false);
                if (editor != null) {
                    IEditorInput input = editor.getEditorInput();
                    if (src.equals((Object)((FileEditorInput)input).getFile()) && editor instanceof IEditorFileChangeListener) {
                        ((IEditorFileChangeListener)editor).updateEditorInput(new FileEditorInput(dst));
                    }
                } else if (editorMatching.matches(editorReference, (IEditorInput)new FileEditorInput(src))) {
                    activePage.closeEditors(new IEditorReference[]{editorReference}, false);
                }
                ++n2;
            }
        });
    }
}

