/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemmanagement;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.fordiac.ide.model.virtualDNS.VirtualDNSFactory;
import org.eclipse.fordiac.ide.model.virtualDNS.VirtualDNSManagement;
import org.eclipse.fordiac.ide.model.virtualDNS.util.VirtualDNSAdapterFactory;
import org.eclipse.fordiac.ide.systemmanagement.Activator;
import org.eclipse.fordiac.ide.systemmanagement.extension.ITagProvider;

public class VirtualDNSTagProvider
implements ITagProvider {
    private static final String VIRTUAL_DNS_FILE_NAME = "virtualDNS.dns";
    private final ResourceSet virtualResSet = new ResourceSetImpl();
    private VirtualDNSManagement virtualDNSManagement;
    private static Map<String, Object> options = new HashMap<String, Object>();
    private static final String ENCODING_UTF_8 = "UTF-8";

    public VirtualDNSTagProvider() {
        this.virtualResSet.getAdapterFactories().add((Object)new VirtualDNSAdapterFactory());
        options.put("ENCODING", ENCODING_UTF_8);
        options.put("DISABLE_NOTIFY", Boolean.TRUE);
        options.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        options.put("PROCESS_DANGLING_HREF", "RECORD");
    }

    @Override
    public boolean loadTagConfiguration(IPath loadPath) {
        IPath path = loadPath.append(VIRTUAL_DNS_FILE_NAME);
        if (path.toFile().exists()) {
            URI uri = URI.createFileURI((String)path.toOSString());
            Resource resource = null;
            resource = this.virtualResSet.getResource(uri, true);
            try {
                resource.load(options);
                EObject rootObject = (EObject)resource.getContents().get(0);
                if (rootObject instanceof VirtualDNSManagement) {
                    this.virtualDNSManagement = (VirtualDNSManagement)rootObject;
                    return true;
                }
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean saveTagConfiguration(IPath savePath) {
        boolean ok = true;
        IPath path = savePath.append(VIRTUAL_DNS_FILE_NAME);
        URI uri = URI.createFileURI((String)path.toOSString());
        File modelfile = new File(path.toOSString());
        Resource resource = null;
        try {
            resource = modelfile.exists() ? this.virtualResSet.getResource(uri, true) : this.virtualResSet.createResource(uri);
            resource.getContents().clear();
            resource.getContents().add((Object)this.virtualDNSManagement);
            resource.save(options);
        }
        catch (Exception e) {
            Activator.getDefault().logError(e.getMessage(), e);
            ok = false;
        }
        return ok;
    }

    @Override
    public Object getModelObject() {
        return this.virtualDNSManagement;
    }

    @Override
    public String getReplacedString(String value) {
        return this.virtualDNSManagement.getReplacedString(value);
    }

    @Override
    public void initialzeNewTagProvider() {
        if (this.virtualDNSManagement == null) {
            this.virtualDNSManagement = VirtualDNSFactory.eINSTANCE.createVirtualDNSManagement();
        }
    }
}

