/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemmanagement;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.PaletteFactory;
import org.eclipse.fordiac.ide.model.Palette.SystemPaletteEntry;
import org.eclipse.fordiac.ide.model.dataexport.SystemExporter;
import org.eclipse.fordiac.ide.model.dataimport.SystemImporter;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.systemmanagement.Activator;
import org.eclipse.fordiac.ide.systemmanagement.ISystemEditor;
import org.eclipse.fordiac.ide.systemmanagement.changelistener.DistributedSystemListener;
import org.eclipse.fordiac.ide.systemmanagement.changelistener.FordiacResourceChangeListener;
import org.eclipse.fordiac.ide.systemmanagement.extension.ITagProvider;
import org.eclipse.fordiac.ide.systemmanagement.util.SystemPaletteManagement;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;
import org.eclipse.swt.widgets.Display;

public enum SystemManager {
    INSTANCE;

    public static final String FORDIAC_PROJECT_NATURE_ID = "org.eclipse.fordiac.ide.systemmanagement.FordiacNature";
    public static final String OLD_DISTRIBUTED_PROJECT_NATURE_ID = "org.fordiac.systemManagement.DistributedNature";
    public static final String SYSTEM_FILE_ENDING = "sys";
    public static final String SYSTEM_FILE_ENDING_WITH_DOT = ".sys";
    public static final String TYPE_LIB_FOLDER_NAME = "Type Library";
    private final Map<IProject, Map<IFile, AutomationSystem>> allSystemsInWS = new HashMap<IProject, Map<IFile, AutomationSystem>>();
    private final Map<IProject, ArrayList<ITagProvider>> tagProviders = new HashMap<IProject, ArrayList<ITagProvider>>();
    private final List<DistributedSystemListener> listeners = new ArrayList<DistributedSystemListener>();

    private SystemManager() {
        try {
            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
        }
        TypeLibrary.loadToolLibrary();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new FordiacResourceChangeListener(this));
    }

    public static boolean isSystemFile(Object entry) {
        return entry instanceof IFile && SYSTEM_FILE_ENDING.equalsIgnoreCase(((IFile)entry).getFileExtension());
    }

    public IProject createNew4diacProject(String projectName, IPath location, boolean importDefaultPalette, IProgressMonitor monitor) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(project.getName());
        if (!Platform.getLocation().equals((Object)location)) {
            description.setLocation(location);
        }
        description.setNatureIds(SystemManager.getNatureIDs());
        project.create(description, monitor);
        project.open(monitor);
        if (importDefaultPalette) {
            SystemPaletteManagement.copyToolTypeLibToDestination((IContainer)project.getFolder(TYPE_LIB_FOLDER_NAME));
        }
        this.getProjectSystems(project);
        return project;
    }

    public synchronized AutomationSystem createNewSystem(IContainer location, String name) {
        IFile systemFile = location.getFile((IPath)new Path(String.valueOf(name) + SYSTEM_FILE_ENDING_WITH_DOT));
        Map<IFile, AutomationSystem> projectSystems = this.getProjectSystems(location.getProject());
        AutomationSystem system = projectSystems.computeIfAbsent(systemFile, SystemImporter::createAutomationSystem);
        SystemPaletteEntry entry = PaletteFactory.eINSTANCE.createSystemPaletteEntry();
        entry.setFile(systemFile);
        entry.setType((LibraryElement)system);
        system.setPaletteEntry((PaletteEntry)entry);
        SystemManager.saveSystem(system);
        return system;
    }

    public synchronized void removeProject(IProject project) {
        this.allSystemsInWS.remove(project);
        this.notifyListeners();
    }

    public synchronized void renameProject(IProject oldProject, IProject newProject) {
        Map<IFile, AutomationSystem> projectSystems = this.allSystemsInWS.remove(oldProject);
        if (projectSystems != null) {
            this.allSystemsInWS.put(newProject, projectSystems);
        }
    }

    public synchronized AutomationSystem replaceSystemFromFile(AutomationSystem system, IFile file) {
        this.removeSystem(system);
        return INSTANCE.getSystem(file);
    }

    public void removeSystem(AutomationSystem system) {
        this.removeSystem(system.getSystemFile());
    }

    public synchronized void removeSystem(IFile systemFile) {
        Map<IFile, AutomationSystem> projectSystems = this.getProjectSystems(systemFile.getProject());
        AutomationSystem refSystem = projectSystems.remove(systemFile);
        if (refSystem != null) {
            SystemManager.closeAllSystemEditors(refSystem);
            this.notifyListeners();
        }
    }

    public synchronized void moveSystemToNewProject(IFile oldSystemFile, IFile newSystemFile) {
        Map<IFile, AutomationSystem> projectSystems = this.getProjectSystems(oldSystemFile.getProject());
        AutomationSystem system = projectSystems.remove(oldSystemFile);
        if (system != null) {
            system.setSystemFile(newSystemFile);
            Map<IFile, AutomationSystem> newProjectSystems = this.getProjectSystems(oldSystemFile.getProject());
            newProjectSystems.put(newSystemFile, system);
            this.notifyListeners();
        }
    }

    public synchronized void updateSystemFile(IProject targetProject, IFile oldSystemFile, IFile newSystemFile) {
        Map<IFile, AutomationSystem> projectSystems = this.getProjectSystems(targetProject);
        AutomationSystem system = projectSystems.remove(oldSystemFile);
        if (system != null) {
            system.setSystemFile(newSystemFile);
            projectSystems.put(newSystemFile, system);
        }
    }

    private static AutomationSystem initSystem(IFile systemFile) {
        if (systemFile.exists()) {
            SystemPaletteEntry entry = PaletteFactory.eINSTANCE.createSystemPaletteEntry();
            entry.setFile(systemFile);
            AutomationSystem type = (AutomationSystem)entry.getType();
            type.setPaletteEntry((PaletteEntry)entry);
            return type;
        }
        return null;
    }

    public static void saveTagProvider(AutomationSystem system, ITagProvider tagProvider) {
        IProject project = system.getSystemFile().getProject();
        IPath projectPath = project.getLocation();
        tagProvider.saveTagConfiguration(projectPath);
    }

    public String getReplacedString(AutomationSystem system, String value) {
        ArrayList<ITagProvider> tagProvider = this.getTagProviderList(system.getSystemFile().getProject());
        String result = null;
        for (ITagProvider iTagProvider : tagProvider) {
            result = iTagProvider.getReplacedString(value);
            if (result != null) break;
        }
        return result;
    }

    public static void saveSystem(AutomationSystem system) {
        SystemManager.saveSystem(system, system.getSystemFile());
    }

    public static void saveSystem(AutomationSystem system, IFile file) {
        Assert.isNotNull((Object)system.getPaletteEntry());
        system.getPaletteEntry().setLastModificationTimestamp(file.getModificationStamp() + 1L);
        SystemExporter systemExporter = new SystemExporter(system);
        systemExporter.saveSystem(file);
    }

    public synchronized AutomationSystem getSystem(IFile systemFile) {
        Map<IFile, AutomationSystem> projectSystems = this.getProjectSystems(systemFile.getProject());
        return projectSystems.computeIfAbsent(systemFile, sysFile -> {
            long startTime = System.currentTimeMillis();
            AutomationSystem system = SystemManager.initSystem(systemFile);
            long endTime = System.currentTimeMillis();
            Activator.getDefault().logInfo("Loading time for System (" + systemFile.getName() + "): " + (endTime - startTime) + " ms");
            return system;
        });
    }

    public synchronized Map<IFile, AutomationSystem> getProjectSystems(IProject project) {
        return this.allSystemsInWS.computeIfAbsent(project, p -> {
            this.loadTagProviders(project);
            return new HashMap();
        });
    }

    private void loadTagProviders(IProject project) {
        ArrayList<ITagProvider> providers = this.getTagProviderList(project);
        if (project.exists()) {
            IConfigurationElement[] elems;
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] iConfigurationElementArray = elems = registry.getConfigurationElementsFor("org.eclipse.fordiac.ide.systemmanagement", "tagProvider");
            int n = elems.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                try {
                    ITagProvider tagProvider;
                    Object object = element.createExecutableExtension("Interface");
                    if (object instanceof ITagProvider && (tagProvider = (ITagProvider)object).loadTagConfiguration(project.getLocation())) {
                        providers.add(tagProvider);
                    }
                }
                catch (CoreException corex) {
                    Activator.getDefault().logError("Error loading TagProviders!", (Exception)((Object)corex));
                }
                ++n2;
            }
        }
    }

    public ITagProvider getTagProvider(Class<?> class1, AutomationSystem system) {
        ArrayList<ITagProvider> tagProviderList = this.getTagProviderList(system.getSystemFile().getProject());
        for (ITagProvider iTagProvider : tagProviderList) {
            if (!iTagProvider.getClass().equals(class1)) continue;
            return iTagProvider;
        }
        ITagProvider provider = null;
        try {
            Object obj = class1.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (obj instanceof ITagProvider) {
                provider = (ITagProvider)obj;
                provider.initialzeNewTagProvider();
                SystemManager.saveTagProvider(system, provider);
                tagProviderList.add(provider);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            Activator.getDefault().logError("Error on creating TagProvider instance!", e);
            return null;
        }
        return provider;
    }

    private ArrayList<ITagProvider> getTagProviderList(IProject project) {
        return this.tagProviders.computeIfAbsent(project, p -> new ArrayList());
    }

    private static String[] getNatureIDs() {
        return new String[]{FORDIAC_PROJECT_NATURE_ID};
    }

    private static void closeAllSystemEditors(AutomationSystem refSystem) {
        Display.getDefault().asyncExec(() -> EditorUtils.closeEditorsFiltered(editor -> editor instanceof ISystemEditor && refSystem.equals(((ISystemEditor)editor).getSystem())));
    }

    public void notifyListeners() {
        this.listeners.forEach(DistributedSystemListener::distributedSystemWorkspaceChanged);
    }

    public void addWorkspaceListener(DistributedSystemListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public PaletteEntry getPaletteEntry(IFile file) {
        Map<IFile, AutomationSystem> map = this.allSystemsInWS.get(file.getProject());
        if (map == null) {
            return null;
        }
        AutomationSystem automationSystem = map.get(file);
        if (automationSystem == null) {
            return null;
        }
        return automationSystem.getPaletteEntry();
    }
}

