/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.properties;

import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.Messages;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.ChangeSequenceNameCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.CreateTransactionCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.DeleteTransactionCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.contentprovider.ServiceSequenceContentProvider;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts.ServiceSequenceEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.properties.AbstractServiceSection;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCommentCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeTransactionOrderCommand;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.OutputPrimitive;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceSequence;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceTransaction;
import org.eclipse.fordiac.ide.ui.widget.AddDeleteReorderListWidget;
import org.eclipse.fordiac.ide.ui.widget.CommandExecutor;
import org.eclipse.fordiac.ide.ui.widget.TableWidgetFactory;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class ServiceSequenceSection
extends AbstractServiceSection {
    private TableViewer transactionsViewer;
    private Text nameText;
    private Text commentText;
    private static final String INDEX = "index";
    private static final String INPUT_PRIMIIVE = "input primitive";
    private static final String OUTPUT_PRIMIIVES = "output primitives";

    protected ServiceSequence getType() {
        return (ServiceSequence)this.type;
    }

    protected ServiceSequence getInputType(Object input) {
        if (input instanceof ServiceSequenceEditPart) {
            return ((ServiceSequenceEditPart)((Object)input)).getModel();
        }
        if (input instanceof ServiceSequence) {
            return (ServiceSequence)input;
        }
        return null;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        this.createSuperControls = false;
        super.createControls(parent, tabbedPropertySheetPage);
        Composite section = this.getWidgetFactory().createComposite(parent);
        section.setLayout((Layout)new GridLayout(1, false));
        section.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite typeAndComment = this.getWidgetFactory().createComposite(section);
        typeAndComment.setLayout((Layout)new GridLayout(1, false));
        typeAndComment.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createTypeAndCommentSection(typeAndComment);
        Composite transactionSection = this.getWidgetFactory().createComposite(section);
        transactionSection.setLayout((Layout)new GridLayout(1, false));
        transactionSection.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createTransactionSection(transactionSection);
        this.transactionsViewer.setContentProvider((IContentProvider)new ServiceSequenceContentProvider());
        TableWidgetFactory.enableCopyPasteCut((Object)tabbedPropertySheetPage);
    }

    private void createTypeAndCommentSection(Composite parent) {
        Group typeAndCommentGroup = this.getWidgetFactory().createGroup(parent, Messages.ServiceSequenceSection_ServiceSequence);
        typeAndCommentGroup.setLayout((Layout)new GridLayout(4, false));
        typeAndCommentGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.getWidgetFactory().createCLabel((Composite)typeAndCommentGroup, Messages.ServiceSection_Name);
        this.nameText = this.createGroupText((Composite)typeAndCommentGroup, true);
        this.nameText.setLayoutData((Object)new GridData(4, 0, false, false));
        this.nameText.addModifyListener(e -> {
            ChangeSequenceNameCommand cmd = new ChangeSequenceNameCommand(this.nameText.getText(), this.getType());
            this.executeCommand(cmd);
        });
        this.getWidgetFactory().createCLabel((Composite)typeAndCommentGroup, Messages.ServiceSection_Comment);
        this.commentText = this.createGroupText((Composite)typeAndCommentGroup, true);
        this.commentText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.commentText.addModifyListener(e -> {
            ChangeCommentCommand cmd = new ChangeCommentCommand((INamedElement)this.getType(), this.commentText.getText());
            this.executeCommand((Command)cmd);
        });
    }

    private void createTransactionSection(Composite parent) {
        Group transactionGroup = this.getWidgetFactory().createGroup(parent, Messages.ServiceSequenceSection_Transaction);
        transactionGroup.setLayout((Layout)new GridLayout(2, false));
        transactionGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        AddDeleteReorderListWidget buttons = new AddDeleteReorderListWidget();
        buttons.createControls((Composite)transactionGroup, (FormToolkit)this.getWidgetFactory());
        this.transactionsViewer = ServiceSequenceSection.createTableViewer(transactionGroup);
        this.configureButtonList(buttons, this.transactionsViewer);
    }

    private void configureButtonList(AddDeleteReorderListWidget buttons, TableViewer transactionsViewer) {
        buttons.bindToTableViewer(transactionsViewer, (CommandExecutor)this, ref -> ServiceSequenceSection.newCreateCommand(this.getType(), (ServiceTransaction)ref), ref -> ServiceSequenceSection.newDeleteCommand((ServiceTransaction)ref), ref -> ServiceSequenceSection.newOrderCommand((ServiceTransaction)ref, true), ref -> ServiceSequenceSection.newOrderCommand((ServiceTransaction)ref, false));
    }

    private static Command newOrderCommand(ServiceTransaction ref, boolean up) {
        return new ChangeTransactionOrderCommand(ref, up);
    }

    private static Command newDeleteCommand(ServiceTransaction ref) {
        return new DeleteTransactionCommand(ref);
    }

    private static CreateTransactionCommand newCreateCommand(ServiceSequence serviceSequence, ServiceTransaction ref) {
        return new CreateTransactionCommand(serviceSequence, ref);
    }

    private static TableViewer createTableViewer(Group parent) {
        TableViewer viewer = TableWidgetFactory.createTableViewer((Composite)parent);
        viewer.getTable().setLayout(ServiceSequenceSection.createTableLayout(viewer.getTable()));
        viewer.setColumnProperties(ServiceSequenceSection.getColumnProperties());
        viewer.setLabelProvider((IBaseLabelProvider)new TransactionLabelProvider());
        return viewer;
    }

    private static String[] getColumnProperties() {
        return new String[]{INDEX, INPUT_PRIMIIVE, OUTPUT_PRIMIIVES};
    }

    private static Layout createTableLayout(Table table) {
        TableColumn indexColumn = new TableColumn(table, 16384);
        indexColumn.setText(Messages.ServiceSequenceSection_Index);
        TableColumn inputPrimitiveColumn = new TableColumn(table, 16384);
        inputPrimitiveColumn.setText(Messages.ServiceSequenceSection_InputPrimitive);
        TableColumn outputPrimitiveColumn = new TableColumn(table, 16384);
        outputPrimitiveColumn.setText(Messages.ServiceSequenceSection_OutputPrimitives);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(80));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(125));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(300));
        return layout;
    }

    public void refresh() {
        CommandStack commandStackBuffer = this.commandStack;
        this.commandStack = null;
        if (this.type != null) {
            this.nameText.setText(this.getType().getName() != null ? this.getType().getName() : "");
            this.commentText.setText(this.getType().getComment() != null ? this.getType().getComment() : "");
            this.transactionsViewer.setInput((Object)this.getType());
        }
        this.commandStack = commandStackBuffer;
    }

    protected void setInputCode() {
        this.nameText.setEnabled(false);
        this.commentText.setEnabled(false);
        this.transactionsViewer.setInput(null);
    }

    protected void setInputInit() {
    }

    protected static class TransactionLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private static final int INDEX_COL_INDEX = 0;
        private static final int INPUT_PRIMITIVE_COL_INDEX = 1;
        private static final int OUTPUT_PRIMITIVE_COL_INDEX = 2;

        protected TransactionLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof ServiceTransaction) {
                ServiceTransaction transaction = (ServiceTransaction)element;
                switch (columnIndex) {
                    case 0: {
                        return String.valueOf(transaction.getServiceSequence().getServiceTransaction().indexOf((Object)transaction) + 1);
                    }
                    case 1: {
                        return transaction.getInputPrimitive().getEvent();
                    }
                    case 2: {
                        return TransactionLabelProvider.getOutputPrimitives(transaction);
                    }
                }
            }
            return element.toString();
        }

        private static String getOutputPrimitives(ServiceTransaction transaction) {
            StringBuilder sb = new StringBuilder();
            for (OutputPrimitive outputPrimitive : transaction.getOutputPrimitive()) {
                sb.append(outputPrimitive.getEvent());
                sb.append("; ");
            }
            return sb.toString();
        }
    }
}

