/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.fordiac.ide.fb.interpreter.OpSem.BasicFBTypeRuntime;
import org.eclipse.fordiac.ide.fb.interpreter.OpSem.EventManager;
import org.eclipse.fordiac.ide.fb.interpreter.OpSem.EventOccurrence;
import org.eclipse.fordiac.ide.fb.interpreter.OpSem.FBRuntimeAbstract;
import org.eclipse.fordiac.ide.fb.interpreter.OpSem.OperationalSemanticsFactory;
import org.eclipse.fordiac.ide.fb.interpreter.OpSem.Transaction;
import org.eclipse.fordiac.ide.fb.interpreter.mm.utils.EventManagerUtils;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts.ServiceSequenceEditPart;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ECState;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.InputPrimitive;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.OutputPrimitive;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceSequence;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceTransaction;
import org.eclipse.fordiac.ide.test.fb.interpreter.infra.AbstractInterpreterTest;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.handlers.HandlerUtil;

public class RecordServiceSequenceHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        for (Object selected : selection.toList()) {
            ServiceSequence seq = RecordServiceSequenceHandler.getSequence(selected);
            if (seq == null) continue;
            ArrayList<String> events = new ArrayList<String>();
            RecordSequenceDialog dialog = new RecordSequenceDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), events);
            dialog.open();
            BasicFBType fbType = (BasicFBType)seq.getService().getFBType();
            EventManager eventManager = RecordServiceSequenceHandler.createEventManager(fbType, events);
            EventManagerUtils.process((EventManager)eventManager);
            for (Transaction transaction : eventManager.getTransactions()) {
                RecordServiceSequenceHandler.convertTransactionToServiceModel(seq, fbType, transaction);
            }
        }
        return Status.OK_STATUS;
    }

    private static void convertTransactionToServiceModel(ServiceSequence seq, BasicFBType fbType, Transaction transaction) {
        ServiceTransaction serviceTransaction = LibraryElementFactory.eINSTANCE.createServiceTransaction();
        seq.getServiceTransaction().add((Object)serviceTransaction);
        InputPrimitive inputPrimitive = LibraryElementFactory.eINSTANCE.createInputPrimitive();
        inputPrimitive.setEvent(transaction.getInputEventOccurrence().getEvent().getName());
        inputPrimitive.setInterface(fbType.getService().getLeftInterface());
        serviceTransaction.setInputPrimitive(inputPrimitive);
        for (EventOccurrence outputEvent : transaction.getOutputEventOccurences()) {
            OutputPrimitive outputPrimitive = LibraryElementFactory.eINSTANCE.createOutputPrimitive();
            outputPrimitive.setEvent(outputEvent.getEvent().getName());
            outputPrimitive.setInterface(fbType.getService().getLeftInterface());
            serviceTransaction.getOutputPrimitive().add((Object)outputPrimitive);
        }
    }

    private static EventManager createEventManager(BasicFBType fb, List<String> events) {
        if (fb.getService() == null) {
            fb.setService(AbstractInterpreterTest.createEmptyServiceModel());
        }
        ResourceSetImpl reset = new ResourceSetImpl();
        Resource resource = reset.createResource(URI.createURI((String)("platform:/resource/" + fb.getName() + ".xmi")));
        EventManager eventManager = OperationalSemanticsFactory.eINSTANCE.createEventManager();
        resource.getContents().add((Object)eventManager);
        BasicFBTypeRuntime basicFBTypeRT = OperationalSemanticsFactory.eINSTANCE.createBasicFBTypeRuntime();
        basicFBTypeRT.setBasicfbtype(fb);
        EList stateList = basicFBTypeRT.getBasicfbtype().getECC().getECState();
        ECState startState = (ECState)stateList.stream().filter(ECState::isStartState).collect(Collectors.toList()).get(0);
        basicFBTypeRT.setActiveState(startState);
        for (String inputEvent : events) {
            EventOccurrence eventOccurrence = OperationalSemanticsFactory.eINSTANCE.createEventOccurrence();
            Event eventPin = (Event)fb.getInterfaceList().getInterfaceElement(inputEvent);
            if (eventPin == null) {
                throw new IllegalArgumentException("input primitive: event " + inputEvent + " does not exist");
            }
            eventOccurrence.setEvent(eventPin);
            Transaction transaction = OperationalSemanticsFactory.eINSTANCE.createTransaction();
            transaction.setInputEventOccurrence(eventOccurrence);
            eventManager.getTransactions().add((Object)transaction);
        }
        ((Transaction)eventManager.getTransactions().get(0)).getInputEventOccurrence().setFbRuntime((FBRuntimeAbstract)basicFBTypeRT);
        return eventManager;
    }

    public void setEnabled(Object evaluationContext) {
        ISelection selection = (ISelection)HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
        if (selection instanceof StructuredSelection) {
            Object selected = ((StructuredSelection)selection).getFirstElement();
            if (selected instanceof EditPart) {
                selected = ((EditPart)selected).getModel();
            }
            if (selected instanceof ServiceSequence) {
                this.setBaseEnabled(((ServiceSequence)selected).getService().getFBType() instanceof BasicFBType);
            }
        }
    }

    private static ServiceSequence getSequence(Object selected) {
        if (selected instanceof ServiceSequenceEditPart) {
            return ((ServiceSequenceEditPart)((Object)selected)).getModel();
        }
        if (selected instanceof ServiceSequence) {
            return (ServiceSequence)selected;
        }
        return null;
    }

    public static class RecordSequenceDialog
    extends MessageDialog {
        private Text text;
        private final List<String> events;

        public RecordSequenceDialog(Shell parentShell, List<String> events) {
            super(parentShell, "Record Sequence (separated by ;)", null, "Input Events:", 2, 0, new String[]{"Run"});
            this.events = events;
        }

        protected Control createCustomArea(Composite parent) {
            Composite container = new Composite(parent, 0);
            GridLayout layout = new GridLayout(2, false);
            container.setLayout((Layout)layout);
            this.text = new Text(container, 0);
            this.text.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
            return container;
        }

        protected void buttonPressed(int buttonId) {
            this.events.addAll(this.getEvents());
            super.buttonPressed(buttonId);
        }

        public List<String> getEvents() {
            return Arrays.asList(this.text.getText().split(";"));
        }
    }
}

