/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.ChangePrimitiveEventCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.ChangePrimitiveParameterCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts.ConnectingConnectionEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts.InputPrimitiveEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts.OutputPrimitiveEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts.PrimitiveConnection;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts.PrimitiveConnectionEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts.ServicePrimitiveDirectEditManager;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts.TransactionEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.figures.AdvancedFixedAnchor;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.figures.PrimitiveFigure;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.policies.DeletePrimitiveEditPolicy;
import org.eclipse.fordiac.ide.gef.FixedAnchor;
import org.eclipse.fordiac.ide.gef.editparts.AbstractDirectEditableEditPart;
import org.eclipse.fordiac.ide.gef.editparts.ZoomScalableFreeformRootEditPart;
import org.eclipse.fordiac.ide.gef.policies.EmptyXYLayoutEditPolicy;
import org.eclipse.fordiac.ide.gef.policies.IChangeStringEditPart;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.Primitive;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.DirectEditManager;

public abstract class AbstractPrimitiveEditPart
extends AbstractDirectEditableEditPart
implements NodeEditPart,
IChangeStringEditPart {
    private final PrimitiveConnection connection;
    protected FixedAnchor srcAnchor;
    protected FixedAnchor dstAnchor;
    protected AdvancedFixedAnchor srcNeighbourAnchor;
    protected AdvancedFixedAnchor dstNeighbourAnchor;
    private final Adapter adapter = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            AbstractPrimitiveEditPart.this.refresh();
        }
    };

    protected AbstractPrimitiveEditPart(PrimitiveConnection connection) {
        this.connection = connection;
    }

    public void activate() {
        if (!this.isActive()) {
            this.getModel().eAdapters().add((Object)this.adapter);
        }
        super.activate();
    }

    public void deactivate() {
        if (this.isActive()) {
            this.getModel().eAdapters().remove((Object)this.adapter);
        }
        super.deactivate();
    }

    public PrimitiveConnection getPrimitiveConnection() {
        return this.connection;
    }

    public PrimitiveFigure getFigure() {
        return (PrimitiveFigure)super.getFigure();
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        PrimitiveFigure figure = this.getFigure();
        if (this.getModel() != null) {
            figure.setInterfaceDirection(this.isLeftInterface());
            figure.setNameLabelText(this.getModel().getEvent());
            figure.setParameterLabelText(this.getModel().getParameters());
            this.connection.setInputDirection(this.isLeftInterface());
        }
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        if (connection instanceof PrimitiveConnectionEditPart) {
            this.srcAnchor = this.getPrimitiveConnSourceAnchor();
            return this.srcAnchor;
        }
        if (connection instanceof ConnectingConnectionEditPart) {
            this.srcNeighbourAnchor = this.getConnectingConnSourceAnchor();
            return this.srcNeighbourAnchor;
        }
        return null;
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        if (connection instanceof PrimitiveConnectionEditPart) {
            this.dstAnchor = this.getPrimitiveConnTargetAnchor();
            return this.dstAnchor;
        }
        if (connection instanceof ConnectingConnectionEditPart) {
            this.dstNeighbourAnchor = this.getConnectingConnTargetAnchor();
            return this.dstNeighbourAnchor;
        }
        return null;
    }

    protected abstract FixedAnchor getPrimitiveConnSourceAnchor();

    protected abstract AdvancedFixedAnchor getConnectingConnSourceAnchor();

    protected abstract FixedAnchor getPrimitiveConnTargetAnchor();

    protected abstract AdvancedFixedAnchor getConnectingConnTargetAnchor();

    public Primitive getModel() {
        return (Primitive)super.getModel();
    }

    protected TransactionEditPart getCastedParent() {
        return (TransactionEditPart)this.getParent();
    }

    protected boolean isLeftInterface() {
        return this.getModel().getInterface().isLeftInterface();
    }

    protected IFigure createFigure() {
        return new PrimitiveFigure(this.isLeftInterface(), this.getModel().getEvent(), this.getModel().getParameters());
    }

    public Label getNameLabel() {
        return this.getFigure().getNameLabel();
    }

    public Figure getCenterFigure() {
        return this.getFigure().getCenterFigure();
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return null;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new DeletePrimitiveEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new DirectEditPolicy(){

            protected Command getDirectEditCommand(DirectEditRequest request) {
                String[] values;
                if (this.getHost() instanceof AbstractPrimitiveEditPart && (values = (String[])request.getCellEditor().getValue()) != null) {
                    int selected = Integer.parseInt(values[0]);
                    List<String> events = AbstractPrimitiveEditPart.getRelevantEvents(this.getHost(), (Primitive)this.getHost().getModel());
                    String ev = null;
                    CompoundCommand commands = new CompoundCommand();
                    if (selected >= 0 && selected < events.size()) {
                        ev = events.get(selected);
                        commands.add((Command)new ChangePrimitiveEventCommand(AbstractPrimitiveEditPart.this.getModel(), ev));
                    }
                    if (values[1] != null) {
                        commands.add((Command)new ChangePrimitiveParameterCommand(AbstractPrimitiveEditPart.this.getModel(), values[1]));
                    }
                    return commands;
                }
                return null;
            }

            protected void showCurrentEditValue(DirectEditRequest request) {
            }
        });
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new EmptyXYLayoutEditPolicy());
    }

    protected DirectEditManager createDirectEditManager() {
        return new ServicePrimitiveDirectEditManager((GraphicalEditPart)this, this.getModel(), this.getFigure().getNameLabel(), this.getZoomManager(), (FigureCanvas)this.getViewer().getControl());
    }

    private ZoomManager getZoomManager() {
        return ((ZoomScalableFreeformRootEditPart)this.getRoot()).getZoomManager();
    }

    public void performDirectEdit() {
        this.getManager().show();
    }

    private static List<String> getRelevantEvents(EditPart editPart, Primitive primitive) {
        ArrayList<String> events;
        block3: {
            block2: {
                events = new ArrayList<String>();
                if (!(editPart instanceof InputPrimitiveEditPart)) break block2;
                for (Event event : primitive.getService().getFBType().getInterfaceList().getEventInputs()) {
                    events.add(event.getName());
                }
                break block3;
            }
            if (!(editPart instanceof OutputPrimitiveEditPart)) break block3;
            for (Event event : primitive.getService().getFBType().getInterfaceList().getEventOutputs()) {
                events.add(event.getName());
            }
        }
        return events;
    }

    public int getFeatureID() {
        return 0;
    }

    public EObject getElement() {
        return this.getModel();
    }

    public Label getLabel() {
        return this.getNameLabel();
    }

    public INamedElement getINamedElement() {
        return null;
    }
}

