/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.typelibrary;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.fordiac.ide.model.Activator;
import org.eclipse.fordiac.ide.model.NamedElementComparator;
import org.eclipse.fordiac.ide.model.Palette.DataTypePaletteEntry;
import org.eclipse.fordiac.ide.model.data.DataFactory;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;

public final class DataTypeLibrary {
    private final Map<String, DataType> typeMap = new HashMap<String, DataType>();
    private final Map<String, DataTypePaletteEntry> derivedTypeMap = new HashMap<String, DataTypePaletteEntry>();

    public DataTypeLibrary() {
        this.initElementaryTypes();
        this.initGenericTypes();
    }

    public void addPaletteEntry(DataTypePaletteEntry entry) {
        this.derivedTypeMap.put(entry.getLabel(), entry);
    }

    public void removePaletteEntry(DataTypePaletteEntry entry) {
        this.derivedTypeMap.remove(entry.getLabel());
    }

    private void initElementaryTypes() {
        Arrays.asList(IecTypes.ElementaryTypes.getAllElementaryType()).forEach(type -> {
            DataType dataType = this.typeMap.put(type.getName(), (DataType)type);
        });
    }

    private void initGenericTypes() {
        Arrays.asList(IecTypes.GenericTypes.getAllGenericTypes()).forEach(type -> {
            DataType dataType = this.typeMap.put(type.getName(), (DataType)type);
        });
    }

    public Map<String, DataTypePaletteEntry> getDerivedDataTypes() {
        return this.derivedTypeMap;
    }

    public List<DataType> getDataTypes() {
        ArrayList<DataType> dataTypes = new ArrayList<DataType>(this.typeMap.size() + this.derivedTypeMap.size());
        dataTypes.addAll(this.typeMap.values());
        dataTypes.addAll(this.derivedTypeMap.values().stream().map(DataTypePaletteEntry::getType).filter(Objects::nonNull).collect(Collectors.toList()));
        return dataTypes;
    }

    public List<DataType> getDataTypesSorted() {
        List<DataType> dataTypes = this.getDataTypes();
        Collections.sort(dataTypes, NamedElementComparator.INSTANCE);
        return dataTypes;
    }

    public DataType getType(String name) {
        if (name == null) {
            return this.typeMap.get("ANY");
        }
        DataType type = this.typeMap.get(name);
        if (type == null && (type = this.getDerivedType(name)) == null) {
            Activator.getDefault().logInfo("Missing Datatype: " + name);
            type = DataFactory.eINSTANCE.createElementaryType();
            type.setName(name);
            this.typeMap.put(name, type);
        }
        return type;
    }

    public DataType getTypeIfExists(String name) {
        DataType dataType = this.typeMap.get(name.toUpperCase());
        if (dataType != null) {
            return dataType;
        }
        return this.getDerivedType(name);
    }

    public List<StructuredType> getStructuredTypes() {
        List<StructuredType> types = this.getDerivedDataTypes().entrySet().stream().filter(entry -> ((DataTypePaletteEntry)entry.getValue()).getType() instanceof StructuredType).map(entry -> (StructuredType)((DataTypePaletteEntry)entry.getValue()).getType()).collect(Collectors.toList());
        types.add((StructuredType)this.getType("ANY_STRUCT"));
        return types;
    }

    public List<StructuredType> getStructuredTypesSorted() {
        List<StructuredType> structTypes = this.getStructuredTypes();
        Collections.sort(structTypes, NamedElementComparator.INSTANCE);
        return structTypes;
    }

    private DataType getDerivedType(String name) {
        DataTypePaletteEntry entry = this.derivedTypeMap.get(name);
        if (entry != null) {
            return entry.getType();
        }
        return null;
    }

    public StructuredType getStructuredType(String name) {
        DataType derivedType = this.getDerivedType(name);
        if (derivedType instanceof StructuredType) {
            return (StructuredType)derivedType;
        }
        return (StructuredType)this.typeMap.get("ANY_STRUCT");
    }
}

