/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.helpers;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.Activator;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.PaletteFactory;
import org.eclipse.fordiac.ide.model.dataimport.ErrorMarkerBuilder;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerFBNElement;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerRef;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Position;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;

public final class FordiacMarkerHelper {
    public static final String TARGET_TYPE = "Target.Type";
    private static final String FB_NETWORK_ELEMENT_TARGET = "FBNetworkElement";
    private static final String CONNECTION_TARGET = "Connection";
    private static final String VALUE_TARGET = "Value";
    private static final Map<Long, ErrorMarkerRef> markers = new ConcurrentHashMap<Long, ErrorMarkerRef>();

    public static ErrorMarkerRef getMarkerRefById(Long id) {
        return markers.get(id);
    }

    public static boolean markerTargetsFBNetworkElement(Map<String, Object> attrs) {
        return FB_NETWORK_ELEMENT_TARGET.equals(attrs.get(TARGET_TYPE));
    }

    public static boolean markerTargetsConnection(Map<String, Object> attrs) {
        return CONNECTION_TARGET.equals(attrs.get(TARGET_TYPE));
    }

    public static boolean markerTargetsValue(Map<String, Object> attrs) {
        return VALUE_TARGET.equals(attrs.get(TARGET_TYPE));
    }

    public static void addTargetIdentifier(EObject element, Map<String, Object> attrs) {
        String targetIdentifier = FordiacMarkerHelper.getTargetIdentifier(element);
        if (targetIdentifier != null) {
            attrs.put(TARGET_TYPE, targetIdentifier);
        }
    }

    public static void addLocation(INamedElement element, Map<String, Object> attrs) {
        String location = FordiacMarkerHelper.getLocation(element);
        if (location != null) {
            attrs.put("location", location);
        }
    }

    public static String getTargetIdentifier(EObject element) {
        if (element instanceof FBNetworkElement) {
            return FB_NETWORK_ELEMENT_TARGET;
        }
        if (element instanceof Connection) {
            return CONNECTION_TARGET;
        }
        if (element instanceof Value) {
            return VALUE_TARGET;
        }
        return null;
    }

    public static String getLocation(EObject element) {
        if (element instanceof FBNetworkElement) {
            return FordiacMarkerHelper.getFBNElementLocation((FBNetworkElement)element);
        }
        if (element instanceof FBNetwork) {
            return FordiacMarkerHelper.getFBNetworkLocation((FBNetwork)element);
        }
        return null;
    }

    private static String getFBNElementLocation(FBNetworkElement element) {
        EObject container = element.eContainer().eContainer();
        if (container instanceof FBType) {
            return element.getName();
        }
        StringBuilder builder = new StringBuilder(element.getName());
        FordiacMarkerHelper.createHierarchicalName(element.eContainer().eContainer(), builder);
        return builder.toString();
    }

    private static String getFBNetworkLocation(FBNetwork element) {
        EObject container = element.eContainer();
        if (container instanceof FBType) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        FordiacMarkerHelper.createHierarchicalName(container, builder);
        if (builder.length() > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    private static void createHierarchicalName(EObject container, StringBuilder builder) {
        EObject runner = container;
        while (runner instanceof SubApp) {
            SubApp parent = (SubApp)runner;
            builder.insert(0, '.');
            builder.insert(0, parent.getName());
            runner = parent.getFbNetwork().eContainer();
        }
        if (runner instanceof Application) {
            builder.insert(0, '.');
            builder.insert(0, ((Application)runner).getName());
        }
        if (runner instanceof Resource) {
            builder.insert(0, '.');
            builder.insert(0, ((Resource)runner).getName());
            if (runner.eContainer() != null) {
                builder.insert(0, '.');
                builder.insert(0, ((Device)runner.eContainer()).getName());
            }
        }
    }

    public static void createMarkerInFile(ErrorMarkerBuilder errorMarker) {
        IFile file = FordiacMarkerHelper.getFileFromRef(errorMarker.getErrorMarkerRef());
        FordiacMarkerHelper.createMarkerInFile(errorMarker, file);
    }

    public static void createMarkerInFile(ErrorMarkerBuilder errorMarker, IFile file) {
        Assert.isNotNull((Object)file);
        try {
            IMarker marker = file.createMarker("org.eclipse.core.resources.problemmarker", errorMarker.getAttributes());
            if (marker.exists() && errorMarker.getErrorMarkerRef() != null) {
                markers.put(marker.getId(), errorMarker.getErrorMarkerRef());
                errorMarker.addId(marker.getId());
            }
        }
        catch (CoreException e) {
            Activator.getDefault().logError("could not create error marker", (Exception)((Object)e));
        }
    }

    private FordiacMarkerHelper() {
        throw new UnsupportedOperationException("FordiacMarkerHelper should not be instantiated");
    }

    public static ErrorMarkerBuilder deleteErrorMarker(ErrorMarkerRef ie) {
        IFile file = FordiacMarkerHelper.getFileFromRef(ie);
        return FordiacMarkerHelper.deleteMarkerInJob(file, ie);
    }

    private static ErrorMarkerBuilder deleteMarkerInJob(IFile f, ErrorMarkerRef ie) {
        long markerId = ie.getFileMarkerId();
        final IMarker marker = f.getMarker(markerId);
        ie.setFileMarkerId(0L);
        markers.remove(markerId);
        WorkspaceJob job = new WorkspaceJob(MessageFormat.format(Messages.FordiacMarkerHelper_RemoveErrorMarkersFromFile, f.getName())){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                try {
                    marker.delete();
                }
                catch (CoreException e) {
                    Activator.getDefault().logError("Could not delete error marker", (Exception)((Object)e));
                }
                return Status.OK_STATUS;
            }
        };
        ErrorMarkerBuilder errorMarkerAttribute = new ErrorMarkerBuilder(marker, ie);
        job.setRule((ISchedulingRule)f.getProject());
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException e) {
            Activator.getDefault().logError("Delete marker Job interrupted", e);
            Thread.currentThread().interrupt();
        }
        return errorMarkerAttribute;
    }

    private static IFile getFileFromRef(ErrorMarkerRef ie) {
        EObject rootContainer = EcoreUtil.getRootContainer((EObject)ie);
        IFile systemFile = null;
        if (rootContainer instanceof AutomationSystem) {
            systemFile = ((AutomationSystem)rootContainer).getSystemFile();
        } else if (rootContainer instanceof FBType) {
            systemFile = ((FBType)rootContainer).getPaletteEntry().getFile();
        }
        Assert.isNotNull((Object)systemFile);
        return systemFile;
    }

    public static ErrorMarkerBuilder createErrorMarkerBuilder(Map<String, Object> attrs, int lineNumber) {
        attrs.put("lineNumber", lineNumber);
        return new ErrorMarkerBuilder(attrs, null);
    }

    public static ErrorMarkerBuilder createConnectionErrorMarkerBuilder(String message, FBNetwork fbNetwork, String sourceIdentifier, String destinationIdentifier, int lineNumber) {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("message", message);
        FordiacMarkerHelper.addTargetIdentifier(LibraryElementFactory.eINSTANCE.createDataConnection(), attrs);
        String location = String.valueOf(FordiacMarkerHelper.getLocation(fbNetwork)) + "." + sourceIdentifier + " -> " + destinationIdentifier;
        attrs.put("location", location);
        return FordiacMarkerHelper.createErrorMarkerBuilder(attrs, lineNumber);
    }

    public static ErrorMarkerBuilder createValueErrorMarkerBuilder(String message, Value value, int lineNumber) {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("message", message);
        FordiacMarkerHelper.addTargetIdentifier(value, attrs);
        IInterfaceElement ie = (IInterfaceElement)value.eContainer();
        String location = String.valueOf(FordiacMarkerHelper.getLocation(ie.getFBNetworkElement())) + "." + ie.getName();
        attrs.put("location", location);
        ErrorMarkerBuilder builder = FordiacMarkerHelper.createErrorMarkerBuilder(attrs, lineNumber);
        builder.setErrorMarkerRef(value);
        return builder;
    }

    public static ErrorMarkerBuilder createErrorMarker(String message, INamedElement errorLocation, int lineNumber) {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("message", message);
        FordiacMarkerHelper.addLocation(errorLocation, attrs);
        FordiacMarkerHelper.addTargetIdentifier(errorLocation, attrs);
        return FordiacMarkerHelper.createErrorMarkerBuilder(attrs, lineNumber);
    }

    public static ErrorMarkerFBNElement createErrorMarkerFB(String name) {
        ErrorMarkerFBNElement createErrorMarkerFBNElement = LibraryElementFactory.eINSTANCE.createErrorMarkerFBNElement();
        createErrorMarkerFBNElement.setName(name);
        createErrorMarkerFBNElement.setInterface(LibraryElementFactory.eINSTANCE.createInterfaceList());
        Position position = LibraryElementFactory.eINSTANCE.createPosition();
        position.setX(0);
        position.setY(0);
        createErrorMarkerFBNElement.setPosition(position);
        return createErrorMarkerFBNElement;
    }

    public static FBNetworkElement createTypeErrorMarkerFB(String typeFbElement, TypeLibrary typeLibrary, EClass typeClass, EClass entryClass) {
        ErrorMarkerFBNElement errorFb = FordiacMarkerHelper.createErrorMarkerFB(typeFbElement);
        FBType fbType = (FBType)LibraryElementFactory.eINSTANCE.create(typeClass);
        PaletteEntry entry = (PaletteEntry)PaletteFactory.eINSTANCE.create(entryClass);
        entry.setType(fbType);
        entry.setLabel(typeFbElement);
        fbType.setPaletteEntry(entry);
        fbType.setName(typeFbElement);
        fbType.setInterfaceList(LibraryElementFactory.eINSTANCE.createInterfaceList());
        errorFb.setInterface(fbType.getInterfaceList().copy());
        errorFb.setPaletteEntry(entry);
        typeLibrary.getErrorTypeLib().addPaletteEntry(entry);
        return errorFb;
    }
}

