/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataimport;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.fordiac.ide.model.CoordinateConverter;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.NameRepository;
import org.eclipse.fordiac.ide.model.Palette.AdapterTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.FBTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.PaletteFactory;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.dataimport.CommonElementImporter;
import org.eclipse.fordiac.ide.model.dataimport.ConnectionHelper;
import org.eclipse.fordiac.ide.model.dataimport.ErrorMarkerBuilder;
import org.eclipse.fordiac.ide.model.dataimport.exceptions.TypeImportException;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.helpers.FordiacMarkerHelper;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterConnection;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.ConnectionRoutingData;
import org.eclipse.fordiac.ide.model.libraryElement.DataConnection;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerFBNElement;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerInterface;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerRef;
import org.eclipse.fordiac.ide.model.libraryElement.EventConnection;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.EventTypeLibrary;

class FBNetworkImporter
extends CommonElementImporter {
    private final FBNetwork fbNetwork;
    private final InterfaceList interfaceList;
    protected final Map<String, FBNetworkElement> fbNetworkElementMap = new HashMap<String, FBNetworkElement>();

    public FBNetworkImporter(CommonElementImporter importer) {
        this(importer, LibraryElementFactory.eINSTANCE.createFBNetwork(), LibraryElementFactory.eINSTANCE.createInterfaceList());
    }

    public FBNetworkImporter(CommonElementImporter importer, FBNetwork fbNetwork, InterfaceList interfaceList) {
        super(importer);
        this.fbNetwork = fbNetwork;
        this.interfaceList = interfaceList;
        fbNetwork.getNetworkElements().forEach(element -> {
            FBNetworkElement fBNetworkElement = this.fbNetworkElementMap.put(element.getName(), (FBNetworkElement)element);
        });
    }

    protected FBNetworkImporter(CommonElementImporter importer, FBNetwork fbNetwork) {
        this(importer, fbNetwork, LibraryElementFactory.eINSTANCE.createInterfaceList());
    }

    public FBNetwork getFbNetwork() {
        return this.fbNetwork;
    }

    public void parseFBNetwork(String networkNodeName) throws TypeImportException, XMLStreamException {
        this.processChildren(networkNodeName, this::handleFBNetworkChild);
    }

    protected boolean handleFBNetworkChild(String name) throws XMLStreamException, TypeImportException {
        switch (name) {
            case "FB": {
                this.parseFB();
                break;
            }
            case "EventConnections": {
                this.parseConnectionList(LibraryElementPackage.eINSTANCE.getEventConnection(), this.fbNetwork.getEventConnections(), "EventConnections");
                break;
            }
            case "DataConnections": {
                this.parseConnectionList(LibraryElementPackage.eINSTANCE.getDataConnection(), this.fbNetwork.getDataConnections(), "DataConnections");
                break;
            }
            case "AdapterConnections": {
                this.parseConnectionList(LibraryElementPackage.eINSTANCE.getAdapterConnection(), this.fbNetwork.getAdapterConnections(), "AdapterConnections");
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    protected void parseFB() throws TypeImportException, XMLStreamException {
        String typeFbElement = this.getAttributeValue("Type");
        FBNetworkElement fb = this.createFBInstance(typeFbElement);
        this.readNameCommentAttributes(fb);
        this.getXandY(fb);
        this.fbNetwork.getNetworkElements().add((Object)fb);
        this.fbNetworkElementMap.put(fb.getName(), fb);
        this.parseFBChildren(fb, "FB");
        if (fb.getPaletteEntry() == null || fb instanceof ErrorMarkerRef) {
            ErrorMarkerBuilder e = FordiacMarkerHelper.createErrorMarker(MessageFormat.format("Type ({0}) could not be loaded for FB: {1}", typeFbElement, fb.getName()), fb, this.getLineNumber());
            e.setErrorMarkerRef((ErrorMarkerRef)((Object)fb));
            this.errorMarkerAttributes.add(e);
        }
    }

    private FBNetworkElement createFBInstance(String typeFbElement) {
        FBType type;
        FB fb = LibraryElementFactory.eINSTANCE.createFB();
        FBTypePaletteEntry entry = this.getTypeEntry(typeFbElement);
        if (entry != null) {
            type = entry.getFBType();
            if (type instanceof CompositeFBType) {
                fb = LibraryElementFactory.eINSTANCE.createCFBInstance();
            } else if ("STRUCT_MUX".equals(type.getName())) {
                fb = LibraryElementFactory.eINSTANCE.createMultiplexer();
            } else if ("STRUCT_DEMUX".equals(type.getName())) {
                fb = LibraryElementFactory.eINSTANCE.createDemultiplexer();
            }
        } else {
            return FordiacMarkerHelper.createTypeErrorMarkerFB(typeFbElement, this.getTypeLibrary(), LibraryElementFactory.eINSTANCE.createFBType().eClass(), PaletteFactory.eINSTANCE.createFBTypePaletteEntry().eClass());
        }
        fb.setInterface(type.getInterfaceList().copy());
        fb.setPaletteEntry(entry);
        return fb;
    }

    protected <T extends Connection> void parseConnectionList(EClass conType, EList<T> connectionlist, String parentNodeName) throws XMLStreamException, TypeImportException {
        this.processChildren(parentNodeName, name -> {
            Object connection = this.parseConnection(conType);
            if (connection != null) {
                connectionlist.add(connection);
            }
            this.proceedToEndElementNamed("Connection");
            return true;
        });
    }

    private <T extends Connection> T parseConnection(EClass conType) {
        Connection connection = (Connection)LibraryElementFactory.eINSTANCE.create(conType);
        connection.setResTypeConnection(false);
        String sourceElement = this.getAttributeValue("Source");
        String destinationElement = this.getAttributeValue("Destination");
        ConnectionHelper.ConnectionBuilder builder = new ConnectionHelper.ConnectionBuilder(sourceElement, destinationElement);
        IInterfaceElement destinationEndPoint = this.getConnectionEndPoint(destinationElement, conType, true, builder);
        builder.setDestinationEndpoint(destinationEndPoint);
        IInterfaceElement sourceEndPoint = this.getConnectionEndPoint(sourceElement, conType, false, builder);
        builder.setSourceEndpoint(sourceEndPoint);
        builder.validate();
        if (builder.isValidConnection()) {
            connection.setSource(builder.getSourceEndpoint());
            connection.setDestination(builder.getDestinationEndpoint());
        }
        if (builder.isMissingConnectionDestination()) {
            this.handleMissingConnectionDestination(connection, builder);
        }
        if (builder.isMissingConnectionDestinationEndpoint()) {
            this.handleMissingConnectionDestinationEnpoint(connection, builder);
        }
        if (builder.isMissingConnectionSource()) {
            this.handleMissingConnectionSource(connection, builder);
        }
        if (builder.isMissingConnectionSourceEndpoint()) {
            this.handleMissingConnectionSourceEndpoint(connection, builder);
        }
        if (builder.isMissingSourceAndDestEndpoint()) {
            this.handleMissingSrcAndDestEnpoint(connection, builder);
        }
        if (builder.getConnectionState().contains((Object)ConnectionHelper.ConnectionState.MISSING_TYPE)) {
            return null;
        }
        String commentElement = this.getAttributeValue("Comment");
        if (commentElement != null) {
            connection.setComment(commentElement);
        }
        this.parseConnectionRouting(connection);
        return (T)connection;
    }

    protected void handleMissingConnectionSource(Connection connection, ConnectionHelper.ConnectionBuilder builder) {
        ErrorMarkerBuilder e = FordiacMarkerHelper.createConnectionErrorMarkerBuilder(Messages.FBNetworkImporter_ConnectionSourceMissing, this.getFbNetwork(), builder.getSource(), builder.getDestination(), this.getLineNumber());
        this.errorMarkerAttributes.add(e);
        ErrorMarkerFBNElement sourceFB = FordiacMarkerHelper.createErrorMarkerFB(builder.getSourceFbName());
        builder.setSrcInterfaceList(sourceFB.getInterface());
        this.getFbNetwork().getNetworkElements().add((Object)sourceFB);
        sourceFB.setName(NameRepository.createUniqueName(sourceFB, sourceFB.getName()));
        FBNetworkImporter.createErrorMarkerInterface(connection, builder, false, e);
    }

    protected void handleMissingConnectionSourceEndpoint(Connection connection, ConnectionHelper.ConnectionBuilder builder) {
        ErrorMarkerBuilder e = FordiacMarkerHelper.createConnectionErrorMarkerBuilder(MessageFormat.format(Messages.FBNetworkImporter_ConnectionSourceNotFound, builder.getSource()), this.getFbNetwork(), builder.getSource(), builder.getDestination(), this.getLineNumber());
        this.errorMarkerAttributes.add(e);
        FBNetworkImporter.createErrorMarkerInterface(connection, builder, false, e);
    }

    protected void handleMissingConnectionDestination(Connection connection, ConnectionHelper.ConnectionBuilder connectionBuilder) {
        ErrorMarkerBuilder e = FordiacMarkerHelper.createConnectionErrorMarkerBuilder(Messages.FBNetworkImporter_ConnectionDestinationMissing, this.getFbNetwork(), connectionBuilder.getSource(), null, this.getLineNumber());
        this.errorMarkerAttributes.add(e);
        ErrorMarkerFBNElement destinationFb = FordiacMarkerHelper.createErrorMarkerFB(connectionBuilder.getDestFbName());
        connectionBuilder.setDestInterfaceList(destinationFb.getInterface());
        this.getFbNetwork().getNetworkElements().add((Object)destinationFb);
        destinationFb.setName(NameRepository.createUniqueName(destinationFb, destinationFb.getName()));
        FBNetworkImporter.createErrorMarkerInterface(connection, connectionBuilder, true, e);
    }

    private void handleMissingSrcAndDestEnpoint(Connection connection, ConnectionHelper.ConnectionBuilder connectionBuilder) {
        DataType pinType = this.determineConnectionType(connection);
        ErrorMarkerInterface srcEndpoint = ConnectionHelper.createErrorMarkerInterface(pinType, connectionBuilder.getSourcePinName(), false, connectionBuilder.getSrcInterfaceList());
        ErrorMarkerInterface destEndpoint = ConnectionHelper.createErrorMarkerInterface(pinType, connectionBuilder.getDestinationPinName(), true, connectionBuilder.getDestInterfaceList());
        this.createMissingErrorMarker(connectionBuilder, srcEndpoint, Messages.FBNetworkImporter_ConnectionSourceNotFound);
        this.createMissingErrorMarker(connectionBuilder, destEndpoint, Messages.FBNetworkImporter_ConnectionDestinationNotFound);
        connection.setSource(srcEndpoint);
        connection.setDestination(destEndpoint);
    }

    private DataType determineConnectionType(Connection connection) {
        if (connection instanceof EventConnection) {
            return EventTypeLibrary.getInstance().getType(null);
        }
        if (connection instanceof AdapterConnection) {
            AdapterTypePaletteEntry entry = this.getPalette().getAdapterTypeEntry("ANY_ADAPTER");
            if (entry != null) {
                return entry.getType();
            }
            return LibraryElementFactory.eINSTANCE.createAdapterType();
        }
        if (connection instanceof DataConnection) {
            return IecTypes.GenericTypes.ANY;
        }
        return null;
    }

    private void createMissingErrorMarker(ConnectionHelper.ConnectionBuilder builder, ErrorMarkerInterface endpoint, String errorMsg) {
        if (this.errorMarkerAttributes.stream().noneMatch(e -> e.getErrorMarkerRef().equals(endpoint))) {
            ErrorMarkerBuilder e2 = FordiacMarkerHelper.createConnectionErrorMarkerBuilder(MessageFormat.format(errorMsg, builder.getSource()), this.getFbNetwork(), builder.getSource(), builder.getDestination(), this.getLineNumber());
            e2.setErrorMarkerRef(endpoint);
            this.errorMarkerAttributes.add(e2);
        }
    }

    private static void createErrorMarkerInterface(Connection connection, ConnectionHelper.ConnectionBuilder connectionBuilder, boolean isInput, ErrorMarkerBuilder e) {
        InterfaceList ieList;
        String pinName = isInput ? connectionBuilder.getDestinationPinName() : connectionBuilder.getSourcePinName();
        IInterfaceElement oppositeEndpoint = isInput ? connectionBuilder.getSourceEndpoint() : connectionBuilder.getDestinationEndpoint();
        InterfaceList interfaceList = ieList = isInput ? connectionBuilder.getDestInterfaceList() : connectionBuilder.getSrcInterfaceList();
        if (oppositeEndpoint == null) {
            connectionBuilder.getConnectionState().add(ConnectionHelper.ConnectionState.MISSING_TYPE);
            return;
        }
        DataType type = oppositeEndpoint.getType();
        if (type == null) {
            type = IecTypes.GenericTypes.ANY;
        }
        ErrorMarkerInterface errorMarkerInterface = ConnectionHelper.createErrorMarkerInterface(type, pinName, isInput, ieList);
        e.setErrorMarkerRef(errorMarkerInterface);
        IInterfaceElement repairedEndpoint = ConnectionHelper.createRepairInterfaceElement(oppositeEndpoint, pinName);
        if (repairedEndpoint != null) {
            errorMarkerInterface.setRepairedEndpoint(repairedEndpoint);
        }
        if (isInput) {
            connection.setSource(oppositeEndpoint);
            connection.setDestination(errorMarkerInterface);
        } else {
            connection.setSource(errorMarkerInterface);
            connection.setDestination(oppositeEndpoint);
        }
    }

    protected <T extends Connection> void handleMissingConnectionDestinationEnpoint(T connection, ConnectionHelper.ConnectionBuilder builder) {
        ErrorMarkerBuilder e = FordiacMarkerHelper.createConnectionErrorMarkerBuilder(MessageFormat.format(Messages.FBNetworkImporter_ConnectionDestinationNotFound, builder.getDestination()), this.getFbNetwork(), builder.getSource(), builder.getDestination(), this.getLineNumber());
        this.errorMarkerAttributes.add(e);
        FBNetworkImporter.createErrorMarkerInterface(connection, builder, true, e);
    }

    private void parseConnectionRouting(Connection connection) {
        String dyElement;
        String dx2Element;
        ConnectionRoutingData routingData = LibraryElementFactory.eINSTANCE.createConnectionRoutingData();
        String dx1Element = this.getAttributeValue("dx1");
        if (dx1Element != null) {
            routingData.setDx1(FBNetworkImporter.parseConnectionValue(dx1Element));
        }
        if ((dx2Element = this.getAttributeValue("dx2")) != null) {
            routingData.setDx2(FBNetworkImporter.parseConnectionValue(dx2Element));
        }
        if ((dyElement = this.getAttributeValue("dy")) != null) {
            routingData.setDy(FBNetworkImporter.parseConnectionValue(dyElement));
        }
        connection.setRoutingData(routingData);
    }

    private IInterfaceElement getConnectionEndPoint(String path, EClass conType, boolean isInput, ConnectionHelper.ConnectionBuilder builder) {
        FBNetworkElement element;
        if (path == null) {
            return null;
        }
        String[] split = path.split("\\.");
        if (1 == split.length) {
            if (isInput) {
                builder.setDestInterfaceList(this.interfaceList);
            } else {
                builder.setSrcInterfaceList(this.interfaceList);
            }
            return this.getContainingInterfaceElement(path, conType, isInput);
        }
        if (split.length >= 2 && (element = this.findFBNetworkElement(split[0])) != null) {
            InterfaceList ieList = element.getInterface();
            if (isInput) {
                builder.setDestInterfaceList(ieList);
            } else {
                builder.setSrcInterfaceList(ieList);
            }
            return FBNetworkImporter.getInterfaceElement(ieList, path.substring(split[0].length() + 1), conType, isInput);
        }
        return null;
    }

    protected IInterfaceElement getContainingInterfaceElement(String interfaceElement, EClass conType, boolean isInput) {
        return FBNetworkImporter.getInterfaceElement(this.interfaceList, interfaceElement, conType, !isInput);
    }

    private static IInterfaceElement getInterfaceElement(InterfaceList il, String interfaceElement, EClass conType, boolean isInput) {
        EList<? extends IInterfaceElement> ieList = FBNetworkImporter.getInterfaceElementList(il, conType, isInput);
        for (IInterfaceElement ie : ieList) {
            if (!ie.getName().equals(interfaceElement)) continue;
            return ie;
        }
        return null;
    }

    private static EList<? extends IInterfaceElement> getInterfaceElementList(InterfaceList il, EClass conType, boolean isInput) {
        if (isInput) {
            if (LibraryElementPackage.eINSTANCE.getEventConnection() == conType) {
                return il.getEventInputs();
            }
            if (LibraryElementPackage.eINSTANCE.getDataConnection() == conType) {
                return il.getInputVars();
            }
            if (LibraryElementPackage.eINSTANCE.getAdapterConnection().equals(conType)) {
                return il.getSockets();
            }
        } else {
            if (LibraryElementPackage.eINSTANCE.getEventConnection() == conType) {
                return il.getEventOutputs();
            }
            if (LibraryElementPackage.eINSTANCE.getDataConnection() == conType) {
                return il.getOutputVars();
            }
            if (LibraryElementPackage.eINSTANCE.getAdapterConnection().equals(conType)) {
                return il.getPlugs();
            }
        }
        return null;
    }

    protected FBNetworkElement findFBNetworkElement(String fbName) {
        return this.fbNetworkElementMap.get(fbName);
    }

    protected static VarDeclaration getVarNamed(InterfaceList interfaceList, String varName, boolean input) {
        VarDeclaration retVal;
        boolean hasType = true;
        if (interfaceList.eContainer() instanceof FB) {
            boolean bl = hasType = ((FB)interfaceList.eContainer()).getPaletteEntry() != null;
        }
        if (hasType) {
            retVal = interfaceList.getVariable(varName);
            if (retVal != null && retVal.isIsInput() != input) {
                retVal = null;
            }
        } else {
            retVal = FBNetworkImporter.createVarDecl(interfaceList, varName, input);
        }
        return retVal;
    }

    private static VarDeclaration createVarDecl(InterfaceList interfaceList, String varName, boolean input) {
        VarDeclaration variable = LibraryElementFactory.eINSTANCE.createVarDeclaration();
        variable.setName(varName);
        variable.setIsInput(input);
        if (input) {
            interfaceList.getInputVars().add((Object)variable);
        } else {
            interfaceList.getOutputVars().add((Object)variable);
        }
        return variable;
    }

    private static int parseConnectionValue(String value) {
        try {
            return CoordinateConverter.INSTANCE.convertFrom1499XML(value);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    @Override
    protected LibraryElement createRootModelElement() {
        return null;
    }

    @Override
    protected String getStartElementName() {
        return null;
    }

    @Override
    protected CommonElementImporter.IChildHandler getBaseChildrenHandler() {
        return null;
    }
}

