/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.fordiac.ide.FordiacLogListener;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImageURLStreamHandlerService;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.util.StatusHandler;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.osgi.service.prefs.BackingStoreException;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.fordiac.ide";
    private static Activator plugin;
    private ILogListener listener;

    public void start(BundleContext context) throws Exception {
        FordiacImageURLStreamHandlerService.getInstance().register();
        super.start(context);
        Activator.setPluginInstance(this);
        Activator.setPreferences();
        Activator.setVersionAndBuildID(context);
        this.addLogListener();
        Activator.disableJFaceErrorMessages();
    }

    private static void setPreferences() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.core.resources");
        prefs.putBoolean("refresh.enabled", true);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, e.getMessage(), (Throwable)e));
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.removeLogListener();
        Activator.setPluginInstance(null);
        super.stop(context);
    }

    private static synchronized void setPluginInstance(Activator instance) {
        plugin = instance;
    }

    public static Activator getDefault() {
        return plugin;
    }

    private static void disableJFaceErrorMessages() {
        Policy.setStatusHandler((StatusHandler)new StatusHandler(){

            public void show(IStatus status, String title) {
            }
        });
    }

    private void addLogListener() {
        this.listener = new FordiacLogListener();
        Platform.addLogListener((ILogListener)this.listener);
    }

    private void removeLogListener() {
        if (this.listener != null) {
            Platform.removeLogListener((ILogListener)this.listener);
            this.listener = null;
        }
    }

    private static void setVersionAndBuildID(BundleContext context) {
        Version v = context.getBundle().getVersion();
        String version = String.valueOf(v.getMajor()) + "." + v.getMinor() + "." + v.getMicro();
        System.setProperty("org.eclipse.fordiac.ide.version", version);
        String qualifier = v.getQualifier();
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmm");
            Date d = sdf.parse(qualifier);
            SimpleDateFormat sdfVisu = new SimpleDateFormat("yyyy-MM-dd_HHmm");
            qualifier = sdfVisu.format(d);
        }
        catch (Exception exception) {}
        System.setProperty("org.eclipse.fordiac.ide.buildid", qualifier);
    }
}

