/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.fordiac.ide.model.Palette.AdapterTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.DataTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.DeviceTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.FBTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.ResourceTypeEntry;
import org.eclipse.fordiac.ide.model.Palette.SegmentTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.SubApplicationTypePaletteEntry;
import org.eclipse.fordiac.ide.model.dataexport.AbstractTypeExporter;
import org.eclipse.fordiac.ide.model.dataimport.ADPImporter;
import org.eclipse.fordiac.ide.model.dataimport.DEVImporter;
import org.eclipse.fordiac.ide.model.dataimport.DataTypeImporter;
import org.eclipse.fordiac.ide.model.dataimport.FBTImporter;
import org.eclipse.fordiac.ide.model.dataimport.RESImporter;
import org.eclipse.fordiac.ide.model.dataimport.SEGImporter;
import org.eclipse.fordiac.ide.model.dataimport.SubAppTImporter;
import org.eclipse.fordiac.ide.model.dataimport.TypeImporter;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.typemanagement.preferences.TypeManagementPreferencesHelper;

public class TypeFromTemplateCreator {
    private final IFile targetTypeFile;
    private final File typeTemplate;

    public TypeFromTemplateCreator(IFile targetTypeFile, File typeTemplate) {
        this.targetTypeFile = targetTypeFile;
        this.typeTemplate = typeTemplate;
    }

    public PaletteEntry createTypeFromTemplate() {
        PaletteEntry entry = TypeLibrary.getTypeLibrary((IProject)this.targetTypeFile.getProject()).createPaletteEntry(this.targetTypeFile);
        TypeImporter importer = this.getTypeImporter(entry);
        if (importer != null) {
            importer.loadElement();
            LibraryElement type = importer.getElement();
            type.setName(TypeLibrary.getTypeNameFromFile((IFile)this.targetTypeFile));
            TypeFromTemplateCreator.setupIdentifcationAndVersionInfo(type);
            this.performTypeSpecificSetup(type);
            entry.setLastModificationTimestamp(this.targetTypeFile.getModificationStamp());
            entry.setType(type);
            AbstractTypeExporter.saveType((PaletteEntry)entry);
            return entry;
        }
        return null;
    }

    protected void performTypeSpecificSetup(LibraryElement type) {
    }

    private TypeImporter getTypeImporter(PaletteEntry entry) {
        if (entry instanceof AdapterTypePaletteEntry) {
            return new ADPImporter(entry.getFile()){

                protected InputStream getInputStream() throws IOException {
                    return Files.newInputStream(TypeFromTemplateCreator.this.typeTemplate.toPath(), new OpenOption[0]);
                }
            };
        }
        if (entry instanceof DataTypePaletteEntry) {
            return new DataTypeImporter(entry.getFile()){

                protected InputStream getInputStream() throws IOException {
                    return Files.newInputStream(TypeFromTemplateCreator.this.typeTemplate.toPath(), new OpenOption[0]);
                }
            };
        }
        if (entry instanceof DeviceTypePaletteEntry) {
            return new DEVImporter(entry.getFile()){

                protected InputStream getInputStream() throws IOException {
                    return Files.newInputStream(TypeFromTemplateCreator.this.typeTemplate.toPath(), new OpenOption[0]);
                }
            };
        }
        if (entry instanceof FBTypePaletteEntry) {
            return new FBTImporter(entry.getFile()){

                protected InputStream getInputStream() throws IOException {
                    return Files.newInputStream(TypeFromTemplateCreator.this.typeTemplate.toPath(), new OpenOption[0]);
                }
            };
        }
        if (entry instanceof ResourceTypeEntry) {
            return new RESImporter(entry.getFile()){

                protected InputStream getInputStream() throws IOException {
                    return Files.newInputStream(TypeFromTemplateCreator.this.typeTemplate.toPath(), new OpenOption[0]);
                }
            };
        }
        if (entry instanceof SegmentTypePaletteEntry) {
            return new SEGImporter(entry.getFile()){

                protected InputStream getInputStream() throws IOException {
                    return Files.newInputStream(TypeFromTemplateCreator.this.typeTemplate.toPath(), new OpenOption[0]);
                }
            };
        }
        if (entry instanceof SubApplicationTypePaletteEntry) {
            return new SubAppTImporter(entry.getFile()){

                protected InputStream getInputStream() throws IOException {
                    return Files.newInputStream(TypeFromTemplateCreator.this.typeTemplate.toPath(), new OpenOption[0]);
                }
            };
        }
        return null;
    }

    private static void setupIdentifcationAndVersionInfo(LibraryElement type) {
        TypeManagementPreferencesHelper.setupIdentification(type);
        TypeManagementPreferencesHelper.setupVersionInfo(type);
    }
}

