/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.preferences;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterType;
import org.eclipse.fordiac.ide.model.libraryElement.Identification;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.VersionInfo;
import org.eclipse.fordiac.ide.typemanagement.Activator;

public final class TypeManagementPreferencesHelper {
    private TypeManagementPreferencesHelper() {
    }

    public static void setupVersionInfo(LibraryElement type) {
        VersionInfo versionInfo = LibraryElementFactory.eINSTANCE.createVersionInfo();
        TypeManagementPreferencesHelper.setupVersion(versionInfo);
        TypeManagementPreferencesHelper.setupOrganization(versionInfo);
        TypeManagementPreferencesHelper.setupAuthor(versionInfo);
        TypeManagementPreferencesHelper.setupDate(versionInfo);
        TypeManagementPreferencesHelper.setupRemarks(versionInfo);
        if (type instanceof AdapterType) {
            type = ((AdapterType)type).getAdapterFBType();
        }
        type.getVersionInfo().clear();
        type.getVersionInfo().add((Object)versionInfo);
    }

    public static void setupVersion(VersionInfo versionInfo) {
        versionInfo.setVersion(Activator.getDefault().getPreferenceStore().getString("Version"));
    }

    public static void setupOrganization(VersionInfo versionInfo) {
        versionInfo.setOrganization(Activator.getDefault().getPreferenceStore().getString("Organization"));
    }

    public static void setupAuthor(VersionInfo versionInfo) {
        versionInfo.setAuthor(Activator.getDefault().getPreferenceStore().getString("Author"));
    }

    public static void setupDate(VersionInfo versionInfo) {
        versionInfo.setDate(new SimpleDateFormat("yyyy-MM-dd").format(new Date(System.currentTimeMillis())));
    }

    public static void setupRemarks(VersionInfo versionInfo) {
        versionInfo.setRemarks(Activator.getDefault().getPreferenceStore().getString("Remarks"));
    }

    public static void setupIdentification(LibraryElement type) {
        Identification identification = type.getIdentification();
        if (type instanceof AdapterType) {
            type = ((AdapterType)type).getAdapterFBType();
            identification = type.getIdentification();
        }
        if (type.getIdentification() == null) {
            identification = LibraryElementFactory.eINSTANCE.createIdentification();
        }
        TypeManagementPreferencesHelper.setupStandard(identification);
        TypeManagementPreferencesHelper.setupClassification(identification);
        TypeManagementPreferencesHelper.setupTypeDomain(identification);
        TypeManagementPreferencesHelper.setupFunction(identification);
        TypeManagementPreferencesHelper.setupType(identification);
        TypeManagementPreferencesHelper.setupDescription(identification);
        type.setIdentification(identification);
    }

    public static void setupStandard(Identification identification) {
        if (!Activator.getDefault().getPreferenceStore().getString("Standard").isEmpty()) {
            identification.setStandard(Activator.getDefault().getPreferenceStore().getString("Standard"));
        }
    }

    public static void setupClassification(Identification identification) {
        identification.setClassification(Activator.getDefault().getPreferenceStore().getString("Classification"));
    }

    public static void setupTypeDomain(Identification identification) {
        identification.setApplicationDomain(Activator.getDefault().getPreferenceStore().getString("Application Domain"));
    }

    public static void setupFunction(Identification identification) {
        identification.setFunction(Activator.getDefault().getPreferenceStore().getString("Function"));
    }

    public static void setupType(Identification identification) {
        identification.setType(Activator.getDefault().getPreferenceStore().getString("Type"));
    }

    public static void setupDescription(Identification identification) {
        identification.setDescription(Activator.getDefault().getPreferenceStore().getString("Description"));
    }
}

