/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.handlers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.STAlgorithm;
import org.eclipse.fordiac.ide.model.libraryElement.SimpleFBType;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.StructuredTextAlgorithm;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.typemanagement.Activator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.util.LazyStringInputStream;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Pair;

public class ExportXMIHandler
extends AbstractHandler {
    private static final String SYNTHETIC_URI_NAME = "__synthetic";
    private static final String URI_SEPERATOR = ".";
    private static final String FB_URI_EXTENSION = "xtextfbt";
    private static final String ST_URI_EXTENSION = "st";
    private static final IResourceServiceProvider SERVICE_PROVIDER = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(URI.createURI((String)"__synthetic.st"));

    protected URI computeUnusedUri(ResourceSet resourceSet, String fileExtension) {
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, Integer.MAX_VALUE, true);
        for (Integer i : _doubleDotLessThan) {
            boolean _tripleEquals;
            URI syntheticUri = URI.createURI((String)(SYNTHETIC_URI_NAME + i + URI_SEPERATOR + fileExtension));
            Resource _resource = resourceSet.getResource(syntheticUri, false);
            boolean bl = _tripleEquals = _resource == null;
            if (!_tripleEquals) continue;
            return syntheticUri;
        }
        throw new IllegalStateException();
    }

    public void createFBResource(XtextResourceSet resourceSet, SimpleFBType fbType) {
        Resource fbResource = resourceSet.createResource(this.computeUnusedUri((ResourceSet)resourceSet, FB_URI_EXTENSION));
        fbResource.getContents().add((Object)fbType);
        Consumer<AdapterDeclaration> _function = adp -> this.createAdapterResource(resourceSet, (AdapterDeclaration)adp);
        fbType.getInterfaceList().getSockets().forEach(_function);
        Consumer<AdapterDeclaration> _function_1 = adp -> this.createAdapterResource(resourceSet, (AdapterDeclaration)adp);
        fbType.getInterfaceList().getPlugs().forEach(_function_1);
        Consumer<VarDeclaration> _function_2 = v -> this.createStructResource(resourceSet, (VarDeclaration)v);
        fbType.getInterfaceList().getInputVars().forEach(_function_2);
        Consumer<VarDeclaration> _function_3 = v -> this.createStructResource(resourceSet, (VarDeclaration)v);
        fbType.getInterfaceList().getOutputVars().forEach(_function_3);
        Consumer<VarDeclaration> _function_4 = v -> this.createStructResource(resourceSet, (VarDeclaration)v);
        fbType.getInternalVars().forEach(_function_4);
    }

    public void createAdapterResource(XtextResourceSet resourceSet, AdapterDeclaration adapter) {
        Resource adapterResource = resourceSet.createResource(this.computeUnusedUri((ResourceSet)resourceSet, FB_URI_EXTENSION));
        adapterResource.getContents().add((Object)adapter.getType().getAdapterFBType());
    }

    public void createStructResource(XtextResourceSet resourceSet, VarDeclaration variable) {
        DataType _type = variable.getType();
        if (_type instanceof StructuredType) {
            Resource structResource = resourceSet.createResource(this.computeUnusedUri((ResourceSet)resourceSet, FB_URI_EXTENSION));
            DataType _type_1 = variable.getType();
            StructuredType type = (StructuredType)_type_1;
            structResource.getContents().add((Object)type);
            Consumer<VarDeclaration> _function = v -> this.createStructResource(resourceSet, (VarDeclaration)v);
            type.getMemberVariables().forEach(_function);
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            ISelection _currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
            IStructuredSelection selection = (IStructuredSelection)_currentSelection;
            Object _firstElement = null;
            if (selection != null) {
                _firstElement = selection.getFirstElement();
            }
            IFile fbFile = (IFile)_firstElement;
            PaletteEntry entry = TypeLibrary.getPaletteEntryForFile((IFile)fbFile);
            LibraryElement _type = null;
            if (entry != null) {
                _type = entry.getType();
            }
            SimpleFBType simpleType = (SimpleFBType)_type;
            Algorithm _algorithm = null;
            if (simpleType != null) {
                _algorithm = simpleType.getAlgorithm();
            }
            String _text = null;
            if ((STAlgorithm)_algorithm != null) {
                _text = ((STAlgorithm)_algorithm).getText();
            }
            String algorithmText = _text;
            ResourceSet _get = (ResourceSet)SERVICE_PROVIDER.get(ResourceSet.class);
            XtextResourceSet resourceSet = (XtextResourceSet)_get;
            this.createFBResource(resourceSet, simpleType);
            Resource _createResource = resourceSet.createResource(this.computeUnusedUri((ResourceSet)resourceSet, ST_URI_EXTENSION));
            XtextResource resource = (XtextResource)_createResource;
            LazyStringInputStream _lazyStringInputStream = new LazyStringInputStream(algorithmText);
            Pair _mappedTo = Pair.of((Object)XtextResource.OPTION_RESOLVE_ALL, (Object)Boolean.TRUE);
            resource.load((InputStream)_lazyStringInputStream, Collections.unmodifiableMap(CollectionLiterals.newHashMap((Pair[])new Pair[]{_mappedTo})));
            EObject _rootASTElement = resource.getParseResult().getRootASTElement();
            StructuredTextAlgorithm stalg = (StructuredTextAlgorithm)_rootASTElement;
            Consumer<VarDeclaration> _function = v -> this.createStructResource(resourceSet, (VarDeclaration)v);
            stalg.getLocalVariables().forEach(_function);
            Resource.Factory.Registry registry = Resource.Factory.Registry.INSTANCE;
            Map m = registry.getExtensionToFactoryMap();
            XMIResourceFactoryImpl _xMIResourceFactoryImpl = new XMIResourceFactoryImpl();
            m.put("xmi", _xMIResourceFactoryImpl);
            ResourceSetImpl xmiResourceSet = new ResourceSetImpl();
            IPath _makeAbsolute = fbFile.getLocation().makeAbsolute();
            String _plus = _makeAbsolute + ".xmi";
            URI uri = URI.createFileURI((String)new File(_plus).getAbsolutePath());
            Resource xmiRessource = xmiResourceSet.createResource(uri);
            xmiRessource.getContents().add((Object)simpleType);
            xmiRessource.getContents().add((Object)((EObject)resource.getContents().get(0)));
            EcoreUtil.resolveAll((Resource)xmiRessource);
            try {
                xmiRessource.save(Collections.EMPTY_MAP);
            }
            catch (Throwable _t) {
                if (_t instanceof IOException) {
                    IOException e = (IOException)_t;
                    Activator.getDefault().logError(e.getMessage(), e);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            return null;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void setEnabled(Object evaluationContext) {
        Object _firstElement;
        IFile fbFile;
        PaletteEntry entry;
        IStructuredSelection structuredSelection;
        Object _variable = HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
        ISelection selection = (ISelection)_variable;
        if (!selection.isEmpty() && selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1 && structuredSelection.getFirstElement() instanceof IFile && (entry = TypeLibrary.getPaletteEntryForFile((IFile)(fbFile = (IFile)(_firstElement = structuredSelection.getFirstElement())))) != null) {
            LibraryElement _type = entry.getType();
            this.setBaseEnabled(_type instanceof SimpleFBType);
            return;
        }
        this.setBaseEnabled(false);
    }
}

