/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.fordiac.ide.model.IdentifierVerifyer;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.typemanagement.Messages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;

public class RenameType
extends RenameParticipant {
    private String oldName;

    protected boolean initialize(Object element) {
        if (element instanceof IFile) {
            this.oldName = ((IFile)element).getName();
        }
        return element instanceof IFile;
    }

    public String getName() {
        return Messages.RenameType_Name;
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        ResourceChangeChecker resChecker = (ResourceChangeChecker)context.getChecker(ResourceChangeChecker.class);
        IResourceChangeDescriptionFactory deltaFactory = resChecker.getDeltaFactory();
        IResourceDelta delta = deltaFactory.getDelta();
        return this.verifyAffectedChildren(delta.getAffectedChildren());
    }

    private RefactoringStatus verifyAffectedChildren(IResourceDelta[] affectedChildren) {
        IResourceDelta[] iResourceDeltaArray = affectedChildren;
        int n = affectedChildren.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta resourceDelta = iResourceDeltaArray[n2];
            if (resourceDelta.getMovedFromPath() != null) {
                String newName;
                if (resourceDelta.getResource() instanceof IFile && this.nameExistsInTypeLibrary(resourceDelta, newName = ((IFile)resourceDelta.getResource()).getName())) {
                    return RefactoringStatus.createFatalErrorStatus((String)MessageFormat.format(Messages.RenameType_TypeExists, newName));
                }
                String name = this.getTypeName(resourceDelta);
                if (name != null && !IdentifierVerifyer.isValidIdentifier((String)name)) {
                    return this.getWrongIdentifierErrorStatus();
                }
            } else if (resourceDelta.getMovedToPath() == null) {
                return this.verifyAffectedChildren(resourceDelta.getAffectedChildren());
            }
            ++n2;
        }
        return new RefactoringStatus();
    }

    protected boolean nameExistsInTypeLibrary(IResourceDelta resourceDelta, String newName) {
        return !this.oldName.equals(newName) && !newName.equals("a" + this.oldName) && TypeLibrary.getPaletteEntryForFile((IFile)((IFile)resourceDelta.getResource())) != null;
    }

    protected String getTypeName(IResourceDelta resourceDelta) {
        if (resourceDelta.getResource() instanceof IFile) {
            return TypeLibrary.getTypeNameFromFile((IFile)((IFile)resourceDelta.getResource()));
        }
        return null;
    }

    protected RefactoringStatus getWrongIdentifierErrorStatus() {
        return RefactoringStatus.createFatalErrorStatus((String)Messages.RenameType_InvalidIdentifierErrorMessage);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return null;
    }
}

