/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbrtlauncher;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.fordiac.ide.fbrtlauncher.Activator;
import org.eclipse.fordiac.ide.fbrtlauncher.Messages;
import org.eclipse.fordiac.ide.runtime.IRuntimeLauncher;
import org.eclipse.fordiac.ide.runtime.LaunchParameter;
import org.eclipse.fordiac.ide.runtime.LaunchRuntimeException;
import org.eclipse.fordiac.ide.runtime.LaunchRuntimeUtils;
import org.eclipse.jface.util.IPropertyChangeListener;

public class FBRTLauncher
implements IRuntimeLauncher {
    private static final String RMT_FRAME = "RMT_FRAME";
    private final List<LaunchParameter> params = new ArrayList<LaunchParameter>();

    public FBRTLauncher() {
        this.setParam(Messages.FBRTLauncher_LABEL_PortParam, "61505");
        LaunchParameter param = this.setParam(Messages.FBRTLauncher_LABEL_DeviceTypeParam, RMT_FRAME);
        param.setFixedValues(true);
        param.setValues(new String[]{RMT_FRAME, "RMT_DEV"});
    }

    public String getName() {
        return "FBRT";
    }

    public void launch() throws LaunchRuntimeException {
        FBRTLauncher.checkPlatform();
        String javaRte = FBRTLauncher.getJavaRte();
        String runtimePath = this.getRuntimePath();
        String deviceType = this.params.get(1).getValue();
        String fbrtPath = "fb.rt.";
        if (RMT_FRAME.equalsIgnoreCase(deviceType)) {
            fbrtPath = String.valueOf(fbrtPath) + "hmi.";
        }
        String arguments = "-noverify -classpath ./lib" + File.pathSeparatorChar + "./" + new File(runtimePath).getName() + File.pathSeparatorChar + " " + fbrtPath + deviceType + " -n " + deviceType + " -s " + Integer.toString(this.getPortNumber()) + " -p " + Activator.getDefault().getPreferenceStore().getString("libPreference");
        LaunchRuntimeUtils.startRuntime((String)("FBRT " + deviceType + " on port " + Integer.toString(this.getPortNumber())), (String)javaRte, (String)new File(runtimePath).getParentFile().getAbsolutePath(), (String)arguments);
    }

    public String getRuntimePath() {
        return Activator.getDefault().getPreferenceStore().getString("pathPreference");
    }

    private static String getJavaRte() throws LaunchRuntimeException {
        String javaRte = System.getProperty("java.home");
        if (javaRte.isEmpty()) {
            throw new LaunchRuntimeException(Messages.FBRTLauncher_ERROR_MissingJavaVM);
        }
        javaRte = String.valueOf(javaRte) + File.separatorChar + "bin" + File.separatorChar + "java";
        if (FBRTLauncher.isWin32Platform()) {
            javaRte = String.valueOf(javaRte) + ".exe";
        }
        return javaRte;
    }

    private int getPortNumber() throws LaunchRuntimeException {
        int port = Integer.parseInt(this.params.get(0).getValue());
        if (port < 1024 || port > 65535) {
            throw new LaunchRuntimeException(Messages.FBRTLauncher_ERROR_WrongPort);
        }
        return port;
    }

    private static void checkPlatform() throws LaunchRuntimeException {
        boolean isLinux = Platform.getOS().equalsIgnoreCase("linux");
        boolean isMacOS = Platform.getOS().equalsIgnoreCase("macosx");
        if (!(FBRTLauncher.isWin32Platform() || isLinux || isMacOS)) {
            throw new LaunchRuntimeException(Messages.FBRTLauncher_ERROR_MissingPlatform);
        }
    }

    private static boolean isWin32Platform() {
        return Platform.getOS().equalsIgnoreCase("win32");
    }

    public int getNumParameters() {
        return this.params.size();
    }

    public List<LaunchParameter> getParams() {
        return this.params;
    }

    public final LaunchParameter setParam(String name, String value) {
        LaunchParameter param2;
        for (LaunchParameter param2 : this.params) {
            if (!param2.getName().equals(name)) continue;
            param2.setValue(value);
            return param2;
        }
        param2 = new LaunchParameter();
        param2.setName(name);
        param2.setValue(value);
        this.params.add(param2);
        return param2;
    }

    public String getPathPreferenceSettingPageID() {
        return "org.eclipse.fordiac.ide.fbrtlauncher.preferences.FBRTPreferencePage";
    }

    public void addPathPreferenceChangeListener(IPropertyChangeListener listener) {
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(listener);
    }
}

