/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.forte_ng.basic;

import com.google.common.collect.Iterables;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.export.forte_ng.ForteFBTemplate;
import org.eclipse.fordiac.ide.export.forte_ng.ForteLibraryElementTemplate;
import org.eclipse.fordiac.ide.export.forte_ng.st.STAlgorithmFilter;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterEvent;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ECAction;
import org.eclipse.fordiac.ide.model.libraryElement.ECState;
import org.eclipse.fordiac.ide.model.libraryElement.ECTransition;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.OtherAlgorithm;
import org.eclipse.fordiac.ide.model.libraryElement.STAlgorithm;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class BasicFBImplTemplate
extends ForteFBTemplate {
    @Accessors(value={AccessorType.PROTECTED_GETTER})
    private BasicFBType type;
    @Extension
    private STAlgorithmFilter stAlgorithmFilter = new STAlgorithmFilter();

    public BasicFBImplTemplate(BasicFBType type, String name, Path prefix) {
        super(name, prefix, "CBasicFB");
        this.type = type;
    }

    public CharSequence generate() {
        EList _internalVars;
        EList _outputVars;
        EList _inputVars;
        Iterable _plus;
        boolean _isEmpty_2;
        boolean _not_2;
        boolean _isEmpty_1;
        boolean _not_1;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateHeader = this.generateHeader();
        _builder.append((Object)_generateHeader);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateImplIncludes = this.generateImplIncludes();
        _builder.append((Object)_generateImplIncludes);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateFBDefinition = this.generateFBDefinition();
        _builder.append((Object)_generateFBDefinition);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateFBInterfaceDefinition = this.generateFBInterfaceDefinition();
        _builder.append((Object)_generateFBInterfaceDefinition);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateFBInterfaceSpecDefinition = this.generateFBInterfaceSpecDefinition();
        _builder.append((Object)_generateFBInterfaceSpecDefinition);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        boolean _isEmpty = this.type.getInternalVars().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            CharSequence _generateInternalVarDefinition = this.generateInternalVarDefinition((BaseFBType)this.type);
            _builder.append((Object)_generateInternalVarDefinition);
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        boolean bl2 = _not_1 = !(_isEmpty_1 = this.type.getInternalFbs().isEmpty());
        if (_not_1) {
            _builder.newLine();
            CharSequence _generateInteralFbDeclarations = this.generateInteralFbDeclarations((BaseFBType)this.type);
            _builder.append((Object)_generateInteralFbDeclarations);
            _builder.newLineIfNotEmpty();
        }
        boolean bl3 = _not_2 = !(_isEmpty_2 = IterableExtensions.isEmpty((Iterable)Iterables.concat((Iterable)(_plus = Iterables.concat((Iterable)(_inputVars = this.type.getInterfaceList().getInputVars()), (Iterable)(_outputVars = this.type.getInterfaceList().getOutputVars()))), (Iterable)(_internalVars = this.type.getInternalVars()))));
        if (_not_2) {
            EList _inputVars_1 = this.type.getInterfaceList().getInputVars();
            EList _outputVars_1 = this.type.getInterfaceList().getOutputVars();
            Iterable _plus_1 = Iterables.concat((Iterable)_inputVars_1, (Iterable)_outputVars_1);
            EList _internalVars_1 = this.type.getInternalVars();
            Iterable _plus_2 = Iterables.concat((Iterable)_plus_1, (Iterable)_internalVars_1);
            CharSequence _generateInitialValueAssignmentDefinition = this.generateInitialValueAssignmentDefinition(_plus_2);
            _builder.append((Object)_generateInitialValueAssignmentDefinition);
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        CharSequence _generateAlgorithms = this.generateAlgorithms();
        _builder.append((Object)_generateAlgorithms);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateStates = this.generateStates();
        _builder.append((Object)_generateStates);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateECC = this.generateECC();
        _builder.append((Object)_generateECC);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    protected CharSequence generateAlgorithms() {
        StringConcatenation _builder = new StringConcatenation();
        EList _algorithm = this.type.getAlgorithm();
        for (Algorithm alg : _algorithm) {
            CharSequence _generateAlgorithm = this.generateAlgorithm(alg);
            _builder.append((Object)_generateAlgorithm);
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence _generateAlgorithm(Algorithm alg) {
        List _errors = this.getErrors();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Cannot export algorithm ");
        Class<?> _class = alg.getClass();
        _builder.append(_class);
        _errors.add(_builder.toString());
        return "";
    }

    protected CharSequence _generateAlgorithm(OtherAlgorithm alg) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("void ");
        CharSequence _fBClassName = this.getFBClassName();
        _builder.append((Object)_fBClassName);
        _builder.append("::alg_");
        String _name = alg.getName();
        _builder.append(_name);
        _builder.append("(void) {");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("#pragma GCC warning \"Algorithm of type: '");
        String _language = alg.getLanguage();
        _builder.append(_language, "  ");
        _builder.append("' may lead to unexpected results!\"");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("#pragma message (\"warning Algorithm of type: '");
        String _language_1 = alg.getLanguage();
        _builder.append(_language_1, "  ");
        _builder.append("' may lead to unexpected results!\")");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        String _text = alg.getText();
        _builder.append(_text, "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _generateAlgorithm(STAlgorithm alg) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("void ");
        CharSequence _fBClassName = this.getFBClassName();
        _builder.append((Object)_fBClassName);
        _builder.append("::alg_");
        String _name = alg.getName();
        _builder.append(_name);
        _builder.append("(void) {");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        CharSequence _generate = this.stAlgorithmFilter.generate(alg, this.getErrors());
        _builder.append((Object)_generate, "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence generateStates() {
        StringConcatenation _builder = new StringConcatenation();
        EList _eCState = this.type.getECC().getECState();
        for (ECState state : _eCState) {
            CharSequence _generateState = this.generateState(state);
            _builder.append((Object)_generateState);
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence generateState(ECState state) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("void ");
        CharSequence _fBClassName = this.getFBClassName();
        _builder.append((Object)_fBClassName);
        _builder.append("::enterState");
        String _name = state.getName();
        _builder.append(_name);
        _builder.append("(void) {");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("m_nECCState = scm_nState");
        String _name_1 = state.getName();
        _builder.append(_name_1, "  ");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        EList _eCAction = state.getECAction();
        for (ECAction action : _eCAction) {
            Event _output;
            boolean _tripleNotEquals_1;
            boolean _tripleNotEquals;
            Algorithm _algorithm = action.getAlgorithm();
            boolean bl = _tripleNotEquals = _algorithm != null;
            if (_tripleNotEquals) {
                _builder.append("  ");
                _builder.append("alg_");
                String _name_2 = action.getAlgorithm().getName();
                _builder.append(_name_2, "  ");
                _builder.append("();");
                _builder.newLineIfNotEmpty();
            }
            boolean bl2 = _tripleNotEquals_1 = (_output = action.getOutput()) != null;
            if (!_tripleNotEquals_1) continue;
            _builder.append("  ");
            CharSequence _generateSendEvent = this.generateSendEvent(action.getOutput());
            _builder.append((Object)_generateSendEvent, "  ");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _generateSendEvent(Event event) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("sendOutputEvent(scm_nEvent");
        String _name = event.getName();
        _builder.append(_name);
        _builder.append("ID);");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected String getAdapterEventName(AdapterEvent event) {
        return event.getName().split("\\.")[1];
    }

    protected CharSequence _generateSendEvent(AdapterEvent event) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("sendAdapterEvent(scm_n");
        String _name = event.getAdapterDeclaration().getName();
        _builder.append(_name);
        _builder.append("AdpNum, FORTE_");
        String _typeName = event.getAdapterDeclaration().getTypeName();
        _builder.append(_typeName);
        _builder.append("::scm_nEvent");
        String _adapterEventName = this.getAdapterEventName(event);
        _builder.append(_adapterEventName);
        _builder.append("ID);");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence generateECC() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("void ");
        CharSequence _fBClassName = this.getFBClassName();
        _builder.append((Object)_fBClassName);
        _builder.append("::executeEvent(int pa_nEIID){");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("bool bTransitionCleared;");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("do {");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("bTransitionCleared = true;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("switch(m_nECCState) {");
        _builder.newLine();
        EList _eCState = this.type.getECC().getECState();
        for (ECState state : _eCState) {
            boolean _not_1;
            _builder.append("      ");
            _builder.append("case scm_nState");
            String _name = state.getName();
            _builder.append(_name, "      ");
            _builder.append(":");
            _builder.newLineIfNotEmpty();
            EList _outTransitions = state.getOutTransitions();
            boolean _hasElements = false;
            for (ECTransition transition : _outTransitions) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)"\nelse", "        ");
                }
                if (transition.getConditionEvent() != null && !StringExtensions.isNullOrEmpty((String)transition.getConditionExpression())) {
                    _builder.append("      ");
                    _builder.append("  ");
                    _builder.append("if((");
                    CharSequence _generateTransitionEvent = this.generateTransitionEvent(transition.getConditionEvent());
                    _builder.append((Object)_generateTransitionEvent, "        ");
                    _builder.append(" == pa_nEIID) && (");
                    CharSequence _generate = this.stAlgorithmFilter.generate(transition.getConditionExpression(), this.type, this.getErrors());
                    _builder.append((Object)_generate, "        ");
                    _builder.append("))");
                    _builder.newLineIfNotEmpty();
                } else {
                    boolean _tripleNotEquals;
                    Event _conditionEvent = transition.getConditionEvent();
                    boolean bl = _tripleNotEquals = _conditionEvent != null;
                    if (_tripleNotEquals) {
                        _builder.append("      ");
                        _builder.append("  ");
                        _builder.append("if(");
                        CharSequence _generateTransitionEvent_1 = this.generateTransitionEvent(transition.getConditionEvent());
                        _builder.append((Object)_generateTransitionEvent_1, "        ");
                        _builder.append(" == pa_nEIID)");
                        _builder.newLineIfNotEmpty();
                    } else {
                        boolean _not;
                        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)transition.getConditionExpression());
                        boolean bl2 = _not = !_isNullOrEmpty;
                        if (_not) {
                            _builder.append("      ");
                            _builder.append("  ");
                            _builder.append("if(");
                            CharSequence _generate_1 = this.stAlgorithmFilter.generate(transition.getConditionExpression(), this.type, this.getErrors());
                            _builder.append((Object)_generate_1, "        ");
                            _builder.append(")");
                            _builder.newLineIfNotEmpty();
                        } else {
                            _builder.append("      ");
                            _builder.append("  ");
                            _builder.append("if(1)");
                            _builder.newLine();
                        }
                    }
                }
                _builder.append("      ");
                _builder.append("  ");
                _builder.append("  ");
                _builder.append("enterState");
                String _name_1 = transition.getDestination().getName();
                _builder.append(_name_1, "          ");
                _builder.append("();");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("      ");
            _builder.append("  ");
            boolean _isEmpty = state.getOutTransitions().isEmpty();
            boolean bl = _not_1 = !_isEmpty;
            if (_not_1) {
                _builder.append("else");
            }
            _builder.newLineIfNotEmpty();
            _builder.append("      ");
            _builder.append("    ");
            _builder.append("bTransitionCleared  = false; //no transition cleared");
            _builder.newLine();
            _builder.append("      ");
            _builder.append("  ");
            _builder.append("break;");
            _builder.newLine();
        }
        _builder.append("      ");
        _builder.append("default:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("DEVLOG_ERROR(\"The state is not in the valid range! The state value is: %d. The max value can be: ");
        int _size = this.type.getECC().getECState().size();
        _builder.append((Object)_size, "        ");
        _builder.append(".\", m_nECCState.operator TForteUInt16 ());");
        _builder.newLineIfNotEmpty();
        _builder.append("        ");
        _builder.append("m_nECCState = 0; // 0 is always the initial state");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("break;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("pa_nEIID = cg_nInvalidEventID; // we have to clear the event after the first check in order to ensure correct behavior");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("} while(bTransitionCleared);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _generateTransitionEvent(Event event) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("scm_nEvent");
        String _name = event.getName();
        _builder.append(_name);
        _builder.append("ID");
        return _builder;
    }

    protected CharSequence _generateTransitionEvent(AdapterEvent event) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)ForteLibraryElementTemplate.EXPORT_PREFIX);
        String _name = event.getAdapterDeclaration().getName();
        _builder.append(_name);
        _builder.append("().");
        String _adapterEventName = this.getAdapterEventName(event);
        _builder.append(_adapterEventName);
        _builder.append("()");
        return _builder;
    }

    protected CharSequence generateAlgorithm(Algorithm alg) {
        if (alg instanceof OtherAlgorithm) {
            return this._generateAlgorithm((OtherAlgorithm)alg);
        }
        if (alg instanceof STAlgorithm) {
            return this._generateAlgorithm((STAlgorithm)alg);
        }
        if (alg != null) {
            return this._generateAlgorithm(alg);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(alg).toString());
    }

    protected CharSequence generateSendEvent(Event event) {
        if (event instanceof AdapterEvent) {
            return this._generateSendEvent((AdapterEvent)event);
        }
        if (event != null) {
            return this._generateSendEvent(event);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(event).toString());
    }

    protected CharSequence generateTransitionEvent(Event event) {
        if (event instanceof AdapterEvent) {
            return this._generateTransitionEvent((AdapterEvent)event);
        }
        if (event != null) {
            return this._generateTransitionEvent(event);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(event).toString());
    }

    @Pure
    protected BasicFBType getType() {
        return this.type;
    }
}

