/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.autoedit;

import com.google.inject.Inject;
import com.google.inject.MembersInjector;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.xtext.ui.editor.autoedit.AbstractEditStrategy;

public class PartitionInsertEditStrategy
extends AbstractEditStrategy {
    private String left;
    private String right;

    public PartitionInsertEditStrategy(String left, String right) {
        this.left = left;
        this.right = right;
    }

    @Override
    protected void internalCustomizeDocumentCommand(IDocument document, DocumentCommand command) throws BadLocationException {
        if (this.left.length() >= command.text.length() && command.text.length() > 0 && this.left.endsWith(command.text)) {
            ITypedRegion partition = document.getPartition(command.offset);
            if (command.offset != 0 && partition.getLength() == 0 && document.getLength() != 0) {
                ITypedRegion precedingPartition;
                partition = precedingPartition = document.getPartition(command.offset - 1);
            }
            if (partition.getOffset() + partition.getLength() >= command.offset + this.right.length() && !this.left.equals(this.right) && this.right.equals(document.get(command.offset, this.right.length()))) {
                return;
            }
            if (this.isIdentifierPart(document, command.offset + command.length)) {
                return;
            }
            if (this.left.length() > 1) {
                int minDocumentLength = this.left.length() - command.text.length();
                if (minDocumentLength > document.getLength()) {
                    return;
                }
                if (command.offset - minDocumentLength < 0) {
                    return;
                }
                String existingLeftPart = document.get(command.offset - minDocumentLength, minDocumentLength);
                if (!this.left.equals(String.valueOf(existingLeftPart) + command.text)) {
                    return;
                }
            }
            if (this.left.equals(this.right)) {
                String trailingLine;
                String partitionContent = document.get(partition.getOffset(), partition.getLength());
                if (this.count(this.left, partitionContent) % 2 != 0) {
                    return;
                }
                IRegion currentLine = document.getLineInformationOfOffset(command.offset);
                if (partition.getOffset() == command.offset && partition.getOffset() + partition.getLength() > currentLine.getOffset() + currentLine.getLength() && this.count(this.left, trailingLine = document.get(command.offset, currentLine.getLength() - (command.offset - currentLine.getOffset()))) % 2 != 0) {
                    return;
                }
            }
            command.caretOffset = command.offset + command.text.length();
            command.shiftsCaret = false;
            command.text = String.valueOf(command.text) + this.right;
        }
    }

    public static class Factory {
        @Inject
        private MembersInjector<PartitionInsertEditStrategy> injector;

        public PartitionInsertEditStrategy newInstance(String left, String right) {
            PartitionInsertEditStrategy result = new PartitionInsertEditStrategy(left, right);
            this.injector.injectMembers((Object)result);
            return result;
        }
    }
}

