/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemconfiguration.editor;

import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.fordiac.ide.gef.preferences.PaletteFlyoutPreferences;
import org.eclipse.fordiac.ide.gef.utilities.TemplateCreationFactory;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;

public final class SystemConfPaletteFactory {
    public static final PaletteFlyoutPreferences PALETTE_PREFERENCES = new PaletteFlyoutPreferences("SystemConfPaletteFactory.Location", "SystemConfPaletteFactory.Size", "SystemConfPaletteFactory.State");

    public static PaletteRoot createPalette(final AutomationSystem system) {
        final PaletteRoot palette = new PaletteRoot();
        SystemConfPaletteFactory.fillPalette(palette, system.getPalette());
        system.getPalette().eAdapters().add((Object)new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                Display.getDefault().syncExec(() -> {
                    palette.setVisible(false);
                    palette.getChildren().clear();
                    SystemConfPaletteFactory.fillPalette(palette, system.getPalette());
                    palette.setVisible(true);
                });
            }
        });
        return palette;
    }

    private static void fillPalette(PaletteRoot palette, Palette typePalette) {
        SystemConfPaletteFactory.createDevGroup(palette, typePalette);
        SystemConfPaletteFactory.createRESGroup(palette, typePalette);
        SystemConfPaletteFactory.createSEGGroup(palette, typePalette);
    }

    private static PaletteDrawer createDevGroup(PaletteRoot palette, Palette typePalette) {
        PaletteDrawer paletteContainer = new PaletteDrawer("Devices");
        for (Map.Entry entry : typePalette.getDeviceTypes().entrySet()) {
            org.eclipse.gef.palette.PaletteEntry paletteEntry = SystemConfPaletteFactory.createCreationEntry((PaletteEntry)entry.getValue(), FordiacImage.ICON_DEVICE.getImageDescriptor());
            if (paletteEntry == null) continue;
            paletteContainer.add(paletteEntry);
        }
        if (!paletteContainer.getChildren().isEmpty()) {
            palette.add((org.eclipse.gef.palette.PaletteEntry)paletteContainer);
        }
        return paletteContainer;
    }

    private static PaletteDrawer createRESGroup(PaletteRoot palette, Palette typePalette) {
        PaletteDrawer paletteContainer = new PaletteDrawer("Resources");
        for (Map.Entry entry : typePalette.getResourceTypes().entrySet()) {
            org.eclipse.gef.palette.PaletteEntry paletteEntry = SystemConfPaletteFactory.createCreationEntry((PaletteEntry)entry.getValue(), FordiacImage.ICON_RESOURCE.getImageDescriptor());
            if (paletteEntry == null) continue;
            paletteContainer.add(paletteEntry);
        }
        if (!paletteContainer.getChildren().isEmpty()) {
            palette.add((org.eclipse.gef.palette.PaletteEntry)paletteContainer);
        }
        return paletteContainer;
    }

    private static PaletteDrawer createSEGGroup(PaletteRoot palette, Palette typePalette) {
        PaletteDrawer paletteContainer = new PaletteDrawer("Segments");
        for (Map.Entry entry : typePalette.getSegmentTypes().entrySet()) {
            org.eclipse.gef.palette.PaletteEntry paletteEntry = SystemConfPaletteFactory.createCreationEntry((PaletteEntry)entry.getValue(), FordiacImage.ICON_SEGMENT.getImageDescriptor());
            if (paletteEntry == null) continue;
            paletteContainer.add(paletteEntry);
        }
        if (!paletteContainer.getChildren().isEmpty()) {
            palette.add((org.eclipse.gef.palette.PaletteEntry)paletteContainer);
        }
        return paletteContainer;
    }

    private static org.eclipse.gef.palette.PaletteEntry createCreationEntry(PaletteEntry entry, ImageDescriptor desc) {
        LibraryElement type = entry.getType();
        if (type == null) {
            return null;
        }
        return new CombinedTemplateCreationEntry(type.getName(), type.getComment(), (CreationFactory)new TemplateCreationFactory((Object)entry), desc, desc);
    }

    private SystemConfPaletteFactory() {
        throw new UnsupportedOperationException("Class SystemconfPaletteFactory should not be insantiated!");
    }
}

