/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.ui.wizard;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.fordiac.ide.export.ExportException;
import org.eclipse.fordiac.ide.export.IExportFilter;
import org.eclipse.fordiac.ide.export.ui.Activator;
import org.eclipse.fordiac.ide.export.ui.Messages;
import org.eclipse.fordiac.ide.export.ui.wizard.ExportStatusMessageDialog;
import org.eclipse.fordiac.ide.export.ui.wizard.SelectFBTypesWizardPage;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.typelibrary.CMakeListsMarker;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.ide.IDE;

public class FordiacExportWizard
extends Wizard
implements IExportWizard {
    private static final String FORDIAC_EXPORT_SECTION = "4DIAC_EXPORT_SECTION";
    private IStructuredSelection selection;
    private SelectFBTypesWizardPage page;

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        List selectedResources = IDE.computeSelectedResources((IStructuredSelection)currentSelection);
        this.selection = new StructuredSelection(selectedResources);
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        if (settings.getSection(FORDIAC_EXPORT_SECTION) == null) {
            settings.addNewSection(FORDIAC_EXPORT_SECTION);
        }
        this.setDialogSettings(settings);
        this.setWindowTitle(Messages.FordiacExportWizard_LABEL_Window_Title);
    }

    public void addPages() {
        super.addPages();
        this.page = new SelectFBTypesWizardPage(Messages.FordiacExportWizard_WizardPage, this.selection);
        this.page.setDescription(Messages.FordiacExportWizard_DESCRIPTION_WizardPage);
        this.page.setTitle(Messages.FordiacExportWizard_TITLE_WizardPage);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        this.page.saveWidgetValues();
        Exporter exporter = new Exporter(this.page.getSelectedExportFilter(), this.collectExportees(), this.page.getDirectory(), this.page.overwriteWithoutWarning());
        try {
            new ProgressMonitorDialog(this.getShell()).run(false, false, (IRunnableWithProgress)exporter);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            FordiacExportWizard.showExceptionErrorDialog(e);
        }
        catch (Exception e) {
            FordiacExportWizard.showExceptionErrorDialog(e);
        }
        return true;
    }

    protected static void showExceptionErrorDialog(Exception e) {
        Activator.getDefault().logError(e.getMessage(), e);
        MessageBox msg = new MessageBox(Display.getDefault().getActiveShell());
        msg.setMessage(String.valueOf(Messages.FordiacExportWizard_ERROR) + e.getMessage());
        msg.open();
    }

    private final List<LibraryElement> collectExportees() {
        List resources = this.page.getSelectedResources();
        List<LibraryElement> exportees = resources.parallelStream().filter(IFile.class::isInstance).map(exportee -> TypeLibrary.getPaletteEntryForFile((IFile)((IFile)exportee))).filter(Objects::nonNull).map(PaletteEntry::getType).collect(Collectors.toList());
        if (this.page.enableCMakeLists()) {
            exportees.add((LibraryElement)new CMakeListsMarker());
        }
        return exportees;
    }

    private static class Exporter
    implements IRunnableWithProgress {
        private final List<LibraryElement> exportees;
        private final String outputDirectory;
        private final IConfigurationElement conf;
        private final boolean overwriteWithoutWarning;

        public Exporter(IConfigurationElement conf, List<LibraryElement> exportees, String outputDirectory, boolean overwriteWithoutWarning) {
            this.conf = conf;
            this.exportees = exportees;
            this.outputDirectory = outputDirectory;
            this.overwriteWithoutWarning = overwriteWithoutWarning;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask(MessageFormat.format(Messages.FordiacExportWizard_ExportingSelectedTypesUsingExporter, this.conf.getAttribute("name")), this.exportees.size());
            IExportFilter filter = this.createExportFilter();
            if (filter != null) {
                for (LibraryElement type : this.exportees) {
                    this.exportElement(monitor, filter, type);
                    monitor.worked(1);
                }
                Exporter.showErrorWarningSummary(filter);
            }
            monitor.done();
        }

        private void exportElement(IProgressMonitor monitor, IExportFilter filter, LibraryElement type) {
            try {
                if (type instanceof CMakeListsMarker) {
                    monitor.subTask(Messages.FordiacExportWizard_ExportingCMakeLists);
                    filter.export(null, this.outputDirectory, this.overwriteWithoutWarning, type);
                } else {
                    monitor.subTask(MessageFormat.format(Messages.FordiacExportWizard_ExportingType, type.getPaletteEntry().getLabel()));
                    filter.export(type.getPaletteEntry().getFile(), this.outputDirectory, this.overwriteWithoutWarning, type);
                }
            }
            catch (ExportException e) {
                Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
                MessageBox msg = new MessageBox(Display.getDefault().getActiveShell());
                msg.setMessage(String.valueOf(Messages.FordiacExportWizard_ERROR) + e.getMessage());
                msg.open();
            }
        }

        private IExportFilter createExportFilter() {
            IExportFilter filter = null;
            try {
                filter = (IExportFilter)this.conf.createExecutableExtension("class");
            }
            catch (CoreException e) {
                Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
                MessageBox msg = new MessageBox(Display.getDefault().getActiveShell());
                msg.setMessage(String.valueOf(Messages.FordiacExportWizard_ERROR) + e.getMessage());
                msg.open();
            }
            return filter;
        }

        private static void showErrorWarningSummary(IExportFilter filter) {
            if (!filter.getErrors().isEmpty() || !filter.getWarnings().isEmpty()) {
                new ExportStatusMessageDialog(Display.getDefault().getActiveShell(), filter.getWarnings(), filter.getErrors()).open();
            }
        }
    }
}

