/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.utilities;

import org.eclipse.core.resources.IProject;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.fordiac.ide.application.utilities.FBTypeTemplateCreationFactory;
import org.eclipse.fordiac.ide.model.Palette.FBTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.SubApplicationTypePaletteEntry;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.gef.dnd.TemplateTransferDropTargetListener;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.CreationFactory;

public class FbTypeTemplateTransferDropTargetListener
extends TemplateTransferDropTargetListener {
    private final IProject targetProject;

    public FbTypeTemplateTransferDropTargetListener(EditPartViewer viewer, IProject targetProject) {
        super(viewer);
        this.targetProject = targetProject;
    }

    protected void handleDragOver() {
        super.handleDragOver();
        this.getCurrentEvent().feedback = 24;
        if (TemplateTransfer.getInstance().getTemplate() == null) {
            this.getCurrentEvent().detail = 0;
            this.getCurrentEvent().operations = 0;
        } else if (TemplateTransfer.getInstance().getTemplate() instanceof FBTypePaletteEntry) {
            FBTypePaletteEntry entry = (FBTypePaletteEntry)TemplateTransfer.getInstance().getTemplate();
            IProject srcProject = entry.getFile().getProject();
            if (this.targetProject != null && this.targetProject.equals((Object)srcProject)) {
                this.getCurrentEvent().detail = 1;
            } else {
                this.getCurrentEvent().detail = 0;
                this.getCurrentEvent().operations = 0;
            }
        }
    }

    protected void handleDrop() {
        if (!(this.getCurrentEvent().data instanceof FBTypePaletteEntry) && !(this.getCurrentEvent().data instanceof SubApplicationTypePaletteEntry)) {
            return;
        }
        super.handleDrop();
        TemplateTransfer.getInstance().setTemplate(null);
    }

    protected void updateTargetRequest() {
        SnapToHelper helper;
        super.updateTargetRequest();
        if (this.getTargetEditPart() != null && (helper = (SnapToHelper)this.getTargetEditPart().getAdapter(SnapToHelper.class)) != null) {
            PrecisionPoint preciseLocation = new PrecisionPoint(this.getDropLocation());
            PrecisionPoint result = new PrecisionPoint(this.getDropLocation());
            CreateRequest req = this.getCreateRequest();
            helper.snapPoint((Request)req, 192, preciseLocation, result);
            req.setLocation(result.getCopy());
        }
    }

    protected CreationFactory getFactory(Object template) {
        this.getCurrentEvent().detail = 1;
        if (template instanceof FBType || template instanceof FBTypePaletteEntry || template instanceof SubApplicationTypePaletteEntry) {
            return new FBTypeTemplateCreationFactory(template);
        }
        return null;
    }
}

