/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.policies;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.fordiac.ide.application.commands.AddElementsToSubAppCommand;
import org.eclipse.fordiac.ide.application.commands.MoveElementsFromSubAppCommand;
import org.eclipse.fordiac.ide.application.editparts.SubAppForFBNetworkEditPart;
import org.eclipse.fordiac.ide.gef.policies.EmptyXYLayoutEditPolicy;
import org.eclipse.fordiac.ide.gef.policies.ModifiedMoveHandle;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.requests.ChangeBoundsRequest;

public class FBAddToSubAppLayoutEditPolicy
extends EmptyXYLayoutEditPolicy {
    private Figure moveHandle;

    protected Command getAddCommand(Request request) {
        if (FBAddToSubAppLayoutEditPolicy.isDragAndDropRequestFromSubAppToSubApp(request, this.getTargetEditPart(request))) {
            List editParts = ((ChangeBoundsRequest)request).getEditParts();
            SubApp dropSubApp = (SubApp)this.getTargetEditPart(request).getModel();
            List<FBNetworkElement> fbEls = FBAddToSubAppLayoutEditPolicy.collectDraggedFBs(editParts, dropSubApp);
            Point destination = this.getTranslatedAndZoomedPoint((ChangeBoundsRequest)request);
            if (!fbEls.isEmpty()) {
                return new MoveElementsFromSubAppCommand(fbEls, new org.eclipse.swt.graphics.Point(destination.x, destination.y));
            }
            return new AddElementsToSubAppCommand(dropSubApp, editParts);
        }
        return super.getAddCommand(request);
    }

    private static List<FBNetworkElement> collectDraggedFBs(List<EditPart> editParts, SubApp dropSubApp) {
        return editParts.stream().filter(ep -> ep.getModel() instanceof FBNetworkElement).map(ep -> (FBNetworkElement)ep.getModel()).filter(el -> el.isNestedInSubApp() && FBAddToSubAppLayoutEditPolicy.isChildFromDropTarget(el, dropSubApp)).collect(Collectors.toList());
    }

    public static boolean isDragAndDropRequestFromSubAppToSubApp(Request generic, EditPart targetEditPart) {
        return generic instanceof ChangeBoundsRequest && targetEditPart instanceof SubAppForFBNetworkEditPart;
    }

    private static boolean isChildFromDropTarget(FBNetworkElement draggedFB, SubApp dropTarget) {
        if (draggedFB.getOuterFBNetworkElement() == null || draggedFB.getOuterFBNetworkElement().getOuterFBNetworkElement() == null) {
            return false;
        }
        return draggedFB.getOuterFBNetworkElement().getOuterFBNetworkElement().equals(dropTarget);
    }

    private Point getTranslatedAndZoomedPoint(ChangeBoundsRequest request) {
        FigureCanvas viewerControl = (FigureCanvas)this.getTargetEditPart((Request)request).getViewer().getControl();
        Point location = viewerControl.getViewport().getViewLocation();
        return new Point(request.getLocation().x + location.x, request.getLocation().y + location.y).scale(1.0 / this.getZoomManager().getZoom());
    }

    protected void showLayoutTargetFeedback(Request request) {
        if ("add children".equals(request.getType()) && this.moveHandle == null) {
            this.moveHandle = new ModifiedMoveHandle((GraphicalEditPart)this.getTargetEditPart(request), new Insets(1), 3);
            this.addFeedback((IFigure)this.moveHandle);
        }
    }

    private ZoomManager getZoomManager() {
        return ((ScalableFreeformRootEditPart)this.getHost().getRoot()).getZoomManager();
    }

    protected void eraseLayoutTargetFeedback(Request request) {
        if (this.moveHandle != null) {
            this.removeFeedback((IFigure)this.moveHandle);
            this.moveHandle = null;
        }
    }
}

