/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.handlers;

import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.application.actions.MapAction;
import org.eclipse.fordiac.ide.application.editparts.AbstractFBNElementEditPart;
import org.eclipse.fordiac.ide.application.editparts.SubAppForFBNetworkEditPart;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class MapToContributionItem
extends ContributionItem {
    private final IMenuListener mapToListener = this::createDeviceMenu;

    public MapToContributionItem() {
    }

    public MapToContributionItem(String id) {
        super(id);
    }

    public void fill(Menu menu, int index) {
        if (this.getParent() instanceof MenuManager) {
            ((IMenuManager)this.getParent()).addMenuListener(this.mapToListener);
            ((IMenuManager)this.getParent()).setRemoveAllWhenShown(true);
        }
        this.createDeviceMenu((IMenuManager)this.getParent());
    }

    public boolean isEnabled() {
        IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        FBNetwork fbnetwork = (FBNetwork)activeEditor.getAdapter(FBNetwork.class);
        return fbnetwork != null && !fbnetwork.isSubApplicationNetwork() && !fbnetwork.isCFBTypeNetwork();
    }

    private void createDeviceMenu(IMenuManager maptoMenu) {
        IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSelection();
        FBNetwork fbnetwork = (FBNetwork)activeEditor.getAdapter(FBNetwork.class);
        if (MapToContributionItem.isFBorSubAppSelected(selection) && fbnetwork != null) {
            maptoMenu.removeAll();
            EList devices = fbnetwork.getAutomationSystem().getSystemConfiguration().getDevices();
            if (!devices.isEmpty()) {
                for (Device device : devices) {
                    MapToContributionItem.createDeviceMenuEntry(maptoMenu, device);
                }
            } else {
                MapToContributionItem.createEmptyMenuEntry(maptoMenu, Messages.MapToContributionItem_No_Device);
            }
        } else {
            MapToContributionItem.createEmptyMenuEntry(maptoMenu, Messages.MapToContributionItem_No_FB_Or_SubApp_Selected);
        }
    }

    private static boolean isFBorSubAppSelected(ISelection selection) {
        if (selection instanceof StructuredSelection) {
            Object[] objectArray = ((IStructuredSelection)selection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof AbstractFBNElementEditPart || element instanceof SubAppForFBNetworkEditPart) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private static void createDeviceMenuEntry(IMenuManager maptoMenu, Device device) {
        MenuManager deviceMenu = new MenuManager();
        deviceMenu.setMenuText(device.getName() == null ? FordiacMessages.Device : device.getName());
        deviceMenu.setImageDescriptor(FordiacImage.ICON_DEVICE.getImageDescriptor());
        maptoMenu.add((IContributionItem)deviceMenu);
        deviceMenu.fill(((MenuManager)maptoMenu).getMenu(), -1);
        deviceMenu.setRemoveAllWhenShown(true);
        MapToContributionItem.createResourceMenu(deviceMenu, device);
    }

    private static void createResourceMenu(MenuManager parentMenuManager, Device device) {
        IMenuListener listener = manager -> {
            EList resources = device.getResource();
            IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            for (Resource resource : resources) {
                MapAction action = new MapAction((IWorkbenchPart)activeEditor, resource);
                action.setText(resource.getName() == null ? FordiacMessages.Resource : resource.getName());
                action.setImageDescriptor(FordiacImage.ICON_RESOURCE.getImageDescriptor());
                parentMenuManager.add((IAction)action);
            }
        };
        parentMenuManager.addMenuListener(listener);
    }

    private static void createEmptyMenuEntry(IMenuManager maptoMenu, final String message) {
        ContributionItem emptyMenu = new ContributionItem(){

            public void fill(Menu menu, int index) {
                MenuItem item = index == -1 ? new MenuItem(menu, 0) : new MenuItem(menu, 0, index);
                item.setText(message);
                item.setEnabled(false);
            }
        };
        maptoMenu.add((IContributionItem)emptyMenu);
        emptyMenu.fill(((MenuManager)maptoMenu).getMenu(), -1);
    }
}

