/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.editparts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.application.policies.AdapterNodeEditPolicy;
import org.eclipse.fordiac.ide.application.policies.EventNodeEditPolicy;
import org.eclipse.fordiac.ide.application.policies.VariableNodeEditPolicy;
import org.eclipse.fordiac.ide.gef.editparts.InterfaceEditPart;
import org.eclipse.fordiac.ide.model.libraryElement.CFBInstance;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.ui.actions.OpenListenerManager;
import org.eclipse.fordiac.ide.model.ui.editors.HandlerHelper;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.ui.IEditorPart;

public class InterfaceEditPartForFBNetwork
extends InterfaceEditPart {
    protected GraphicalNodeEditPolicy getNodeEditPolicy() {
        if (this.isEvent()) {
            return new EventNodeEditPolicy();
        }
        if (this.isAdapter()) {
            return new AdapterNodeEditPolicy();
        }
        if (this.isVariable()) {
            return new VariableNodeEditPolicy();
        }
        return null;
    }

    protected List<?> getModelSourceConnections() {
        ArrayList connections = new ArrayList(super.getModelSourceConnections());
        if (this.isUnfoldedSubapp()) {
            if (this.isInput()) {
                connections.addAll(this.getModel().getOutputConnections());
            }
            return connections;
        }
        return connections;
    }

    protected List<?> getModelTargetConnections() {
        ArrayList connections = new ArrayList(super.getModelTargetConnections());
        if (this.isUnfoldedSubapp()) {
            if (!this.isInput()) {
                connections.addAll(this.getModel().getInputConnections());
            }
            return connections;
        }
        return connections;
    }

    public void performRequest(Request request) {
        if (request.getType() == "open" && this.canGoInto()) {
            this.goInto();
            return;
        }
        super.performRequest(request);
    }

    private boolean canGoInto() {
        FBNetworkElement element = this.getModel().getFBNetworkElement();
        return element instanceof SubApp || element instanceof CFBInstance;
    }

    protected void goInto() {
        FBNetworkElement element = this.getModel().getFBNetworkElement();
        IInterfaceElement selectionElement = this.getModel();
        if (element instanceof SubApp && InterfaceEditPartForFBNetwork.needsOppositeSubapp((SubApp)element)) {
            element = element.getOpposite();
            selectionElement = element.getInterfaceElement(selectionElement.getName());
        }
        IEditorPart newEditor = OpenListenerManager.openEditor((EObject)element);
        GraphicalViewer viewer = (GraphicalViewer)newEditor.getAdapter(GraphicalViewer.class);
        HandlerHelper.selectElement((Object)selectionElement, (GraphicalViewer)viewer);
    }

    private static boolean needsOppositeSubapp(SubApp subapp) {
        return subapp.isMapped() && EcoreUtil.isAncestor((EObject)subapp.getResource(), (EObject)subapp);
    }

    protected boolean isUnfoldedSubapp() {
        SubApp subapp;
        return this.getModel().getFBNetworkElement() instanceof SubApp && (subapp = (SubApp)this.getModel().getFBNetworkElement()).isUnfolded();
    }
}

