/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.editparts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.fordiac.ide.application.editors.NewInstanceDirectEditManager;
import org.eclipse.fordiac.ide.application.editparts.ErrorMarkerInterfaceEditPart;
import org.eclipse.fordiac.ide.application.editparts.InstanceName;
import org.eclipse.fordiac.ide.application.editparts.InstanceNameEditPart;
import org.eclipse.fordiac.ide.application.figures.FBNetworkElementFigure;
import org.eclipse.fordiac.ide.application.policies.DeleteFBNElementEditPolicy;
import org.eclipse.fordiac.ide.application.policies.FBNElementSelectionPolicy;
import org.eclipse.fordiac.ide.gef.editparts.AbstractPositionableElementEditPart;
import org.eclipse.fordiac.ide.gef.editparts.AbstractViewEditPart;
import org.eclipse.fordiac.ide.gef.editparts.InterfaceEditPart;
import org.eclipse.fordiac.ide.gef.editparts.ZoomScalableFreeformRootEditPart;
import org.eclipse.fordiac.ide.gef.listeners.DiagramFontChangeListener;
import org.eclipse.fordiac.ide.gef.listeners.IFontUpdateListener;
import org.eclipse.fordiac.ide.gef.policies.DragHighlightEditPolicy;
import org.eclipse.fordiac.ide.gef.tools.ScrollingDragEditPartsTracker;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.commands.change.UpdateFBTypeCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Color;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.libraryElement.PositionableElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.ui.preferences.PreferenceConstants;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;

public abstract class AbstractFBNElementEditPart
extends AbstractPositionableElementEditPart {
    private Device referencedDevice;
    private DiagramFontChangeListener fontChangeListener;
    private Adapter interfaceAdapter;
    private final Adapter colorChangeListener = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            if (notification.getFeature() == LibraryElementPackage.eINSTANCE.getColorizableElement_Color()) {
                AbstractFBNElementEditPart.this.backgroundColorChanged((IFigure)AbstractFBNElementEditPart.this.getFigure());
            }
        }
    };
    private IPropertyChangeListener listener;

    protected AbstractFBNElementEditPart() {
    }

    private Adapter getInterfaceAdapter() {
        if (this.interfaceAdapter == null) {
            this.interfaceAdapter = this.createInterfaceAdapter();
            Assert.isNotNull((Object)this.interfaceAdapter);
        }
        return this.interfaceAdapter;
    }

    protected Adapter createInterfaceAdapter() {
        return new EContentAdapter(){

            public void notifyChanged(Notification notification) {
                super.notifyChanged(notification);
                switch (notification.getEventType()) {
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        AbstractFBNElementEditPart.this.refreshChildren();
                        break;
                    }
                }
            }
        };
    }

    public FBNetworkElementFigure getFigure() {
        return (FBNetworkElementFigure)super.getFigure();
    }

    protected Adapter createContentAdapter() {
        return new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                super.notifyChanged(notification);
                AbstractFBNElementEditPart.this.refreshToolTip();
                if (notification.getFeature() == LibraryElementPackage.eINSTANCE.getFBNetworkElement_Mapping()) {
                    AbstractFBNElementEditPart.this.updateDeviceListener();
                }
            }
        };
    }

    protected void updateDeviceListener() {
        Device device = this.findDevice();
        if (device != this.referencedDevice) {
            if (this.referencedDevice != null) {
                this.referencedDevice.eAdapters().remove((Object)this.colorChangeListener);
            }
            this.referencedDevice = device;
            if (this.referencedDevice != null) {
                this.referencedDevice.eAdapters().add((Object)this.colorChangeListener);
            }
            this.backgroundColorChanged((IFigure)this.getFigure());
        }
    }

    public void activate() {
        super.activate();
        this.updateDeviceListener();
        JFaceResources.getFontRegistry().addListener(this.getFontChangeListener());
        if (this.getModel() != null && !this.getModel().getInterface().eAdapters().contains((Object)this.getInterfaceAdapter())) {
            this.getModel().getInterface().eAdapters().add((Object)this.getInterfaceAdapter());
        }
    }

    public void deactivate() {
        super.deactivate();
        if (this.referencedDevice != null) {
            this.referencedDevice.eAdapters().remove((Object)this.colorChangeListener);
        }
        JFaceResources.getFontRegistry().removeListener(this.getFontChangeListener());
        if (this.getModel() != null) {
            this.getModel().getInterface().eAdapters().remove((Object)this.getInterfaceAdapter());
        }
    }

    private IPropertyChangeListener getFontChangeListener() {
        if (this.fontChangeListener == null) {
            this.fontChangeListener = new DiagramFontChangeListener((IFontUpdateListener)this.getFigure());
        }
        return this.fontChangeListener;
    }

    public boolean isOnlyThisOrNothingSelected() {
        List selection = this.getViewer().getSelectedEditParts();
        if (selection.size() > 1) {
            return false;
        }
        if (selection.size() == 1) {
            return selection.get(0) == this;
        }
        return true;
    }

    protected void refreshToolTip() {
        this.getFigure().refreshToolTips();
    }

    protected void refreshComment() {
        this.refreshToolTip();
    }

    public FBNetworkElement getModel() {
        return (FBNetworkElement)super.getModel();
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new DeleteFBNElementEditPolicy());
        this.installEditPolicy("Selection Feedback", (EditPolicy)new FBNElementSelectionPolicy());
        this.removeEditPolicy("DirectEditPolicy");
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new DirectEditPolicy(){

            protected Command getDirectEditCommand(DirectEditRequest request) {
                Object value = request.getCellEditor().getValue();
                if (value instanceof PaletteEntry) {
                    return new UpdateFBTypeCommand(AbstractFBNElementEditPart.this.getModel(), (PaletteEntry)value);
                }
                return null;
            }

            protected void showCurrentEditValue(DirectEditRequest request) {
            }
        });
        this.installEditPolicy("Selection Feedback", (EditPolicy)new DragHighlightEditPolicy());
    }

    public IPropertyChangeListener getPreferenceChangeListener() {
        if (this.listener == null) {
            this.listener = event -> {
                if (event.getProperty().equals("EventConnectionConnectorColor") || PreferenceConstants.isDataConnectorProperty((String)event.getProperty()) || event.getProperty().equals("AdapterConnectionConnectorColor")) {
                    this.getFigure().repaint();
                }
            };
        }
        return this.listener;
    }

    protected void backgroundColorChanged(IFigure figure) {
        Device dev;
        Color color = null;
        if (this.getModel() != null && (dev = this.findDevice()) != null) {
            color = LibraryElementFactory.eINSTANCE.createColor();
            color.setRed(dev.getColor().getRed());
            color.setGreen(dev.getColor().getGreen());
            color.setBlue(dev.getColor().getBlue());
        }
        this.setColor(figure, color);
    }

    private Device findDevice() {
        Resource res = null;
        if (this.getModel() != null && this.getModel().isMapped()) {
            res = this.getModel().getResource();
        }
        return res != null ? res.getDevice() : null;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        if (childEditPart instanceof InterfaceEditPart) {
            InterfaceEditPart interfaceEditPart = (InterfaceEditPart)childEditPart;
            this.getTargetFigure(interfaceEditPart).add(child, this.getInterfaceElementIndex(interfaceEditPart));
        } else {
            this.getFigure().add(child, new GridData(64), index);
        }
    }

    private IFigure getTargetFigure(InterfaceEditPart interfaceEditPart) {
        if (interfaceEditPart.isInput()) {
            if (interfaceEditPart.isEvent()) {
                return this.getFigure().getEventInputs();
            }
            if (interfaceEditPart.isAdapter()) {
                return this.getFigure().getSockets();
            }
            if (interfaceEditPart.isVariable()) {
                return this.getFigure().getDataInputs();
            }
            if (interfaceEditPart instanceof ErrorMarkerInterfaceEditPart) {
                return this.getFigure().getErrorMarkerInput();
            }
        } else {
            if (interfaceEditPart.isEvent()) {
                return this.getFigure().getEventOutputs();
            }
            if (interfaceEditPart.isAdapter()) {
                return this.getFigure().getPlugs();
            }
            if (interfaceEditPart.isVariable()) {
                return this.getFigure().getDataOutputs();
            }
            if (interfaceEditPart instanceof ErrorMarkerInterfaceEditPart) {
                return this.getFigure().getErrorMarkerOutput();
            }
        }
        return this.getFigure();
    }

    private int getInterfaceElementIndex(InterfaceEditPart interfaceEditPart) {
        InterfaceList interfaceList = this.getModel().getInterface();
        if (interfaceEditPart.isInput()) {
            if (interfaceEditPart.isEvent()) {
                return interfaceList.getEventInputs().indexOf((Object)interfaceEditPart.getModel());
            }
            if (interfaceEditPart.isAdapter()) {
                return interfaceList.getSockets().indexOf((Object)interfaceEditPart.getModel());
            }
            if (interfaceEditPart.isVariable()) {
                return interfaceList.getInputVars().indexOf((Object)interfaceEditPart.getModel());
            }
            if (interfaceEditPart instanceof ErrorMarkerInterfaceEditPart) {
                return AbstractFBNElementEditPart.calcErrorMarkerINdex(interfaceEditPart, interfaceList);
            }
        } else {
            if (interfaceEditPart.isEvent()) {
                return interfaceList.getEventOutputs().indexOf((Object)interfaceEditPart.getModel());
            }
            if (interfaceEditPart.isAdapter()) {
                return interfaceList.getPlugs().indexOf((Object)interfaceEditPart.getModel());
            }
            if (interfaceEditPart.isVariable()) {
                return interfaceList.getOutputVars().indexOf((Object)interfaceEditPart.getModel());
            }
            if (interfaceEditPart instanceof ErrorMarkerInterfaceEditPart) {
                return AbstractFBNElementEditPart.calcErrorMarkerINdex(interfaceEditPart, interfaceList);
            }
        }
        return -1;
    }

    private static int calcErrorMarkerINdex(InterfaceEditPart interfaceEditPart, InterfaceList interfaceList) {
        int indexOf = interfaceList.getErrorMarker().indexOf((Object)interfaceEditPart.getModel());
        return indexOf - (int)interfaceList.getErrorMarker().subList(0, indexOf).stream().filter(e -> interfaceEditPart.isInput() ? !e.isIsInput() : e.isIsInput()).count();
    }

    protected void removeChildVisual(EditPart childEditPart) {
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        if (childEditPart instanceof InterfaceEditPart) {
            InterfaceEditPart interfaceEditPart = (InterfaceEditPart)childEditPart;
            this.getTargetFigure(interfaceEditPart).remove(child);
        } else {
            super.removeChildVisual(childEditPart);
        }
    }

    protected List<Object> getModelChildren() {
        ArrayList<Object> elements = new ArrayList<Object>();
        elements.add(new InstanceName(this.getModel()));
        elements.addAll((Collection<Object>)this.getModel().getInterface().getAllInterfaceElements());
        return elements;
    }

    public INamedElement getINamedElement() {
        return this.getModel();
    }

    protected PositionableElement getPositionableElement() {
        return this.getModel();
    }

    public void performRequest(Request request) {
        if (request.getType() == "direct edit" || request.getType() == "open") {
            List children = this.getChildren();
            children.stream().filter(InstanceNameEditPart.class::isInstance).forEach(e -> ((InstanceNameEditPart)((Object)e)).performRequest(request));
            return;
        }
        super.performRequest(request);
    }

    public void performDirectEdit() {
        NewInstanceDirectEditManager directEditManager = this.getManager();
        directEditManager.updateRefPosition(this.getRefPoint());
        directEditManager.show(this.getModel().getTypeName());
    }

    private org.eclipse.swt.graphics.Point getRefPoint() {
        Point typeLabelTopLeft = this.getFigure().getTypeLabel().getBounds().getTopLeft().scale(this.getZoomManager().getZoom());
        FigureCanvas viewerControl = (FigureCanvas)this.getViewer().getControl();
        Point location = viewerControl.getViewport().getViewLocation();
        return new org.eclipse.swt.graphics.Point(typeLabelTopLeft.x - location.x, typeLabelTopLeft.y - location.y);
    }

    private ZoomManager getZoomManager() {
        return ((ZoomScalableFreeformRootEditPart)this.getRoot()).getZoomManager();
    }

    public Label getNameLabel() {
        return null;
    }

    protected void refreshName() {
    }

    protected NewInstanceDirectEditManager getManager() {
        return (NewInstanceDirectEditManager)super.getManager();
    }

    protected DirectEditManager createDirectEditManager() {
        return new NewInstanceDirectEditManager((GraphicalEditPart)this, this.getPalette(), true);
    }

    private Palette getPalette() {
        if (this.getModel().eContainer().eContainer() instanceof FBType) {
            return ((FBType)this.getModel().eContainer().eContainer()).getPaletteEntry().getPalette();
        }
        return this.getModel().getFbNetwork().getAutomationSystem().getPalette();
    }

    public void setTransparency(int value) {
        for (Object ep : this.getChildren()) {
            if (!(ep instanceof AbstractViewEditPart)) continue;
            ((AbstractViewEditPart)ep).setTransparency(value);
        }
        super.setTransparency(value);
    }

    public DragTracker getDragTracker(Request request) {
        return new ScrollingDragEditPartsTracker((EditPart)this);
    }
}

