/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.editors;

import java.util.List;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.edit.providers.ResultListLabelProvider;
import org.eclipse.fordiac.ide.model.typelibrary.PaletteFilter;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class NewInstanceCellEditor
extends TextCellEditor {
    private Composite container;
    private Button menuButton;
    private Shell popupShell;
    private TableViewer tableViewer;
    private PaletteFilter paletteFilter;
    private boolean blockTableSelection = false;
    private PaletteEntry selectedEntry = null;

    public NewInstanceCellEditor() {
    }

    public NewInstanceCellEditor(Composite parent) {
        this(parent, 0);
    }

    public NewInstanceCellEditor(Composite parent, int style) {
        super(parent, style | 0x80 | 0x100 | 0x200);
    }

    public Button getMenuButton() {
        return this.menuButton;
    }

    public void setPalette(Palette palette) {
        this.paletteFilter = new PaletteFilter(palette);
    }

    protected Control createControl(Composite parent) {
        this.container = this.createContainer(parent);
        Text textControl = (Text)super.createControl(this.container);
        this.configureTextControl(textControl);
        this.createTypeMenuButton(this.container);
        this.createPopUpList(this.container);
        this.updateSelectionList(textControl.getText());
        return this.container;
    }

    public Text getText() {
        return this.text;
    }

    protected void focusLost() {
        if (!this.insideAnyEditorArea()) {
            this.fireCancelEditor();
        }
    }

    public void fireCancelEditor() {
        super.fireCancelEditor();
    }

    public void deactivate() {
        if (this.popupShell != null && !this.popupShell.isDisposed()) {
            this.popupShell.setVisible(false);
        }
        super.deactivate();
    }

    protected void handleDefaultSelection(SelectionEvent event) {
        if (!((Text)event.getSource()).getText().isEmpty()) {
            super.handleDefaultSelection(event);
        }
    }

    protected Object doGetValue() {
        if (this.selectedEntry != null) {
            return this.selectedEntry;
        }
        return super.doGetValue();
    }

    private boolean insideAnyEditorArea() {
        Point cursorLocation = this.popupShell.getDisplay().getCursorLocation();
        Point containerRelativeCursor = this.container.getParent().toControl(cursorLocation);
        return this.container.getBounds().contains(containerRelativeCursor) || this.popupShell.getBounds().contains(cursorLocation);
    }

    private Composite createContainer(Composite parent) {
        Composite newContainer = new Composite(parent, 0){

            public void setBounds(int x, int y, int width, int height) {
                super.setBounds(x, y, width, height);
                Point screenPos = this.getParent().toDisplay(this.getLocation());
                Rectangle compositeBounds = this.getBounds();
                NewInstanceCellEditor.this.popupShell.setBounds(screenPos.x, screenPos.y + compositeBounds.height, compositeBounds.width, 150);
                if (!NewInstanceCellEditor.this.popupShell.isVisible()) {
                    NewInstanceCellEditor.this.popupShell.setVisible(true);
                }
            }
        };
        newContainer.setBackground(parent.getBackground());
        newContainer.setForeground(parent.getForeground());
        GridLayout contLayout = new GridLayout(2, false);
        contLayout.horizontalSpacing = 0;
        contLayout.marginTop = 0;
        contLayout.marginBottom = 0;
        contLayout.marginWidth = 0;
        contLayout.marginHeight = 0;
        contLayout.verticalSpacing = 0;
        contLayout.horizontalSpacing = 0;
        newContainer.setLayout((Layout)contLayout);
        return newContainer;
    }

    private void configureTextControl(Text textControl) {
        textControl.setLayoutData((Object)new GridData(4, 4, true, true));
        textControl.setMessage(Messages.NewInstanceCellEditor_SearchForType);
        textControl.addListener(24, event -> this.updateSelectionList(textControl.getText()));
        textControl.addListener(1, event -> this.handleKeyPress(event, textControl));
    }

    private void updateSelectionList(String searchString) {
        this.blockTableSelection = true;
        if (searchString.length() >= 2) {
            List entries = this.paletteFilter.findFBAndSubappTypes(searchString);
            this.tableViewer.setInput((Object)entries);
            if (!entries.isEmpty()) {
                this.selectItemAtIndex(0);
            }
        } else {
            this.tableViewer.setInput(null);
        }
        this.blockTableSelection = false;
    }

    private void handleKeyPress(Event event, Text textControl) {
        switch (event.keyCode) {
            case 0x1000002: {
                if (this.tableViewer.getTable().getItemCount() > 0) {
                    int index = (this.tableViewer.getTable().getSelectionIndex() + 1) % this.tableViewer.getTable().getItemCount();
                    this.selectItemAtIndex(index);
                }
                event.doit = false;
                break;
            }
            case 0x1000001: {
                if (this.tableViewer.getTable().getItemCount() > 0) {
                    int index = this.tableViewer.getTable().getSelectionIndex() - 1;
                    if (index < 0) {
                        index = this.tableViewer.getTable().getItemCount() - 1;
                    }
                    this.selectItemAtIndex(index);
                }
                event.doit = false;
                break;
            }
            case 13: {
                if (this.popupShell.isVisible() && this.tableViewer.getTable().getSelectionIndex() != -1) {
                    this.selectedEntry = (PaletteEntry)this.tableViewer.getStructuredSelection().getFirstElement();
                    textControl.setText(this.selectedEntry.getLabel());
                    break;
                }
                event.doit = false;
                break;
            }
        }
    }

    private void selectItemAtIndex(int index) {
        this.blockTableSelection = true;
        Object element = this.tableViewer.getElementAt(index);
        this.tableViewer.setSelection((ISelection)new StructuredSelection(element), true);
        this.blockTableSelection = false;
    }

    private void createPopUpList(Composite container) {
        this.popupShell = new Shell(container.getShell(), 540680);
        this.popupShell.setLayout((Layout)new FillLayout());
        this.tableViewer = new TableViewer((Composite)this.popupShell, 2820);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new ResultListLabelProvider()));
        new TableColumn(this.tableViewer.getTable(), 0);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        this.tableViewer.getTable().setLayout((Layout)layout);
        this.tableViewer.getControl().addListener(1, event -> {
            if (event.keyCode == 27) {
                this.fireCancelEditor();
            }
        });
        this.tableViewer.addSelectionChangedListener(event -> {
            if (!this.blockTableSelection) {
                this.selectedEntry = (PaletteEntry)this.tableViewer.getStructuredSelection().getFirstElement();
                this.fireApplyEditorValue();
            }
        });
    }

    private void createTypeMenuButton(Composite container) {
        this.menuButton = new Button(container, 0x800000);
        this.menuButton.setImage(FordiacImage.ICON_TYPE_NAVIGATOR.getImage());
    }
}

