/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.commands;

import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.model.commands.create.AbstractConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.AdapterConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.DataConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.EventConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteConnectionCommand;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;

public class ConnectThroughCommand
extends Command {
    private final IInterfaceElement input;
    private final IInterfaceElement output;
    private final CompoundCommand deleteConnectionCommands = new CompoundCommand();
    private final CompoundCommand createConnectionCommands = new CompoundCommand();

    public ConnectThroughCommand(IInterfaceElement input, IInterfaceElement output) {
        this.input = input;
        this.output = output;
    }

    public void execute() {
        this.createDeleteCommands((EList<Connection>)this.input.getInputConnections());
        this.createDeleteCommands((EList<Connection>)this.output.getOutputConnections());
        this.createCreateCommands();
        this.deleteConnectionCommands.execute();
        this.createConnectionCommands.execute();
    }

    public void undo() {
        this.createConnectionCommands.undo();
        this.deleteConnectionCommands.undo();
    }

    public void redo() {
        this.deleteConnectionCommands.redo();
        this.createConnectionCommands.redo();
    }

    private void createDeleteCommands(EList<Connection> connectionList) {
        connectionList.forEach(con -> this.deleteConnectionCommands.add((Command)new DeleteConnectionCommand(con)));
    }

    private void createCreateCommands() {
        for (Connection con : this.input.getInputConnections()) {
            this.output.getOutputConnections().forEach(outconn -> {
                AbstractConnectionCreateCommand cmd = ConnectThroughCommand.getConnectionCreateCommand(this.input);
                cmd.setSource(con.getSource());
                cmd.setDestination(outconn.getDestination());
                this.createConnectionCommands.add((Command)cmd);
            });
        }
    }

    private static AbstractConnectionCreateCommand getConnectionCreateCommand(IInterfaceElement port) {
        FBNetwork parent = port.getFBNetworkElement().getFbNetwork();
        if (port instanceof Event) {
            return new EventConnectionCreateCommand(parent);
        }
        if (port instanceof AdapterDeclaration) {
            return new AdapterConnectionCreateCommand(parent);
        }
        return new DataConnectionCreateCommand(parent);
    }
}

