/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.application.commands.CreateSubAppInterfaceElementCommand;
import org.eclipse.fordiac.ide.application.commands.DeleteSubAppInterfaceElementCommand;
import org.eclipse.fordiac.ide.model.NameRepository;
import org.eclipse.fordiac.ide.model.commands.change.ChangeNameCommand;
import org.eclipse.fordiac.ide.model.commands.change.UnmapCommand;
import org.eclipse.fordiac.ide.model.commands.create.AbstractConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.AdapterConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.DataConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.EventConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteConnectionCommand;
import org.eclipse.fordiac.ide.model.helpers.FBNetworkHelper;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.swt.graphics.Point;

public class AddElementsToSubAppCommand
extends Command {
    private final SubApp targetSubApp;
    private final List<FBNetworkElement> elementsToAdd = new ArrayList<FBNetworkElement>();
    private final Map<IInterfaceElement, IInterfaceElement> sourceToSubAppPin = new HashMap<IInterfaceElement, IInterfaceElement>();
    private final CompoundCommand unmappingCmds = new CompoundCommand();
    private final List<Connection> movedConns = new ArrayList<Connection>();
    private final CompoundCommand modifiedConns = new CompoundCommand();
    private final CompoundCommand changedSubAppIEs = new CompoundCommand();
    private final CompoundCommand setUniqueName = new CompoundCommand();
    private Point offset;

    public AddElementsToSubAppCommand(SubApp targetSubApp, List<?> selection) {
        this.targetSubApp = targetSubApp;
        this.fillElementList(selection);
    }

    public boolean canExecute() {
        return !this.elementsToAdd.isEmpty() && FBNetworkHelper.targetSubappIsInSameFbNetwork(this.elementsToAdd, (SubApp)this.targetSubApp);
    }

    public void execute() {
        this.unmappingCmds.execute();
        EList fbNetwork = this.targetSubApp.getSubAppNetwork().getNetworkElements();
        this.offset = FBNetworkHelper.removeXYOffsetForFBNetwork(this.elementsToAdd);
        for (FBNetworkElement fbNetworkElement : this.elementsToAdd) {
            fbNetwork.add((Object)fbNetworkElement);
            this.checkElementConnections(fbNetworkElement);
            this.ensureUniqueName(fbNetworkElement);
        }
        this.setUniqueName.execute();
        this.modifiedConns.execute();
    }

    private void ensureUniqueName(FBNetworkElement element) {
        if (!NameRepository.isValidName((INamedElement)element, (String)element.getName())) {
            String uniqueName = NameRepository.createUniqueName((INamedElement)element, (String)element.getName());
            this.setUniqueName.add((Command)new ChangeNameCommand((INamedElement)element, uniqueName));
        }
    }

    public void redo() {
        this.unmappingCmds.redo();
        FBNetworkHelper.removeXYOffsetForFBNetwork(this.elementsToAdd);
        this.elementsToAdd.forEach(element -> {
            boolean bl = this.targetSubApp.getSubAppNetwork().getNetworkElements().add(element);
        });
        this.movedConns.forEach(con -> this.targetSubApp.getSubAppNetwork().addConnection(con));
        this.changedSubAppIEs.redo();
        this.setUniqueName.redo();
        this.modifiedConns.redo();
    }

    public void undo() {
        this.modifiedConns.undo();
        this.changedSubAppIEs.undo();
        this.movedConns.forEach(con -> this.targetSubApp.getFbNetwork().addConnection(con));
        FBNetworkHelper.moveFBNetworkByOffset(this.elementsToAdd, (int)this.getOriginalPositionX(), (int)this.getOriginalPositionY());
        this.elementsToAdd.forEach(element -> {
            boolean bl = this.targetSubApp.getFbNetwork().getNetworkElements().add(element);
        });
        this.setUniqueName.undo();
        this.unmappingCmds.undo();
    }

    private int getOriginalPositionX() {
        return this.offset.x - 150;
    }

    private int getOriginalPositionY() {
        return this.offset.y - 80;
    }

    private void fillElementList(List<?> selection) {
        for (Object fbNetworkElement : selection) {
            if (fbNetworkElement instanceof EditPart && ((EditPart)fbNetworkElement).getModel() instanceof FBNetworkElement) {
                this.addElement((FBNetworkElement)((EditPart)fbNetworkElement).getModel());
                continue;
            }
            if (!(fbNetworkElement instanceof FBNetworkElement)) continue;
            this.addElement((FBNetworkElement)fbNetworkElement);
        }
    }

    protected void addElement(FBNetworkElement element) {
        this.elementsToAdd.add(element);
        if (element.isMapped()) {
            this.unmappingCmds.add((Command)new UnmapCommand(element));
        }
    }

    private void checkElementConnections(FBNetworkElement fbNetworkElement) {
        for (IInterfaceElement ie : fbNetworkElement.getInterface().getAllInterfaceElements()) {
            if (ie.isIsInput()) {
                for (Connection con : ie.getInputConnections()) {
                    this.checkConnection(con, con.getSource(), ie);
                }
                continue;
            }
            for (Connection con : ie.getOutputConnections()) {
                this.checkConnection(con, con.getDestination(), ie);
            }
        }
    }

    private void checkConnection(Connection con, IInterfaceElement opposite, IInterfaceElement ownIE) {
        if (opposite.getFBNetworkElement() != null && this.elementsToAdd.contains(opposite.getFBNetworkElement())) {
            this.moveConIntoSubApp(con);
        } else if (opposite.getFBNetworkElement() != null && this.targetSubApp.equals(opposite.getFBNetworkElement())) {
            this.moveInterfaceCrossingConIntoSubApp(con, opposite, ownIE);
        } else {
            this.handleModifyConnection(con, ownIE);
        }
    }

    private void moveConIntoSubApp(Connection con) {
        this.targetSubApp.getSubAppNetwork().addConnection(con);
        this.movedConns.add(con);
    }

    private void moveInterfaceCrossingConIntoSubApp(Connection con, IInterfaceElement opposite, IInterfaceElement ownIE) {
        EList outCons;
        EList internalCons = opposite.isIsInput() ? opposite.getOutputConnections() : opposite.getInputConnections();
        EList eList = outCons = opposite.isIsInput() ? opposite.getInputConnections() : opposite.getOutputConnections();
        if (1 == outCons.size()) {
            this.modifiedConns.add((Command)new DeleteSubAppInterfaceElementCommand(opposite));
        } else {
            this.modifiedConns.add((Command)new DeleteConnectionCommand(con));
        }
        internalCons.forEach(intConn -> {
            AbstractConnectionCreateCommand cmd = AddElementsToSubAppCommand.getCreateConnectionCommand(this.targetSubApp.getSubAppNetwork(), opposite);
            cmd.setSource(opposite.isIsInput() ? ownIE : intConn.getSource());
            cmd.setDestination(opposite.isIsInput() ? intConn.getDestination() : ownIE);
            this.modifiedConns.add((Command)cmd);
        });
    }

    private void handleModifyConnection(Connection con, IInterfaceElement ie) {
        IInterfaceElement source = con.getSource();
        Optional<IInterfaceElement> reusablePin = this.targetSubApp.getInterface().getAllInterfaceElements().stream().filter(pin -> pin.getInputConnections().size() == 1).filter(pin -> ((Connection)pin.getInputConnections().get(0)).getSource().equals(source)).findFirst();
        boolean isNewPin = !reusablePin.isPresent() && !this.sourceToSubAppPin.containsKey(source);
        IInterfaceElement subAppIE = reusablePin.isPresent() ? reusablePin.get() : this.sourceToSubAppPin.computeIfAbsent(source, k -> this.createInterfaceElement(ie, AddElementsToSubAppCommand.generateSubAppIEName(ie)));
        this.createConnModificationCommands(con, subAppIE, isNewPin);
    }

    private IInterfaceElement createInterfaceElement(IInterfaceElement ie, String subAppIEName) {
        CreateSubAppInterfaceElementCommand cmd = new CreateSubAppInterfaceElementCommand(ie.getType(), this.targetSubApp.getInterface(), ie.isIsInput(), -1);
        cmd.execute();
        cmd.getCreatedElement().setName(subAppIEName);
        if (cmd.getMirroredElement() != null) {
            cmd.getMirroredElement().getCreatedElement().setName(subAppIEName);
        }
        this.changedSubAppIEs.add((Command)cmd);
        return cmd.getCreatedElement();
    }

    private static String generateSubAppIEName(IInterfaceElement ie) {
        return String.valueOf(ie.getFBNetworkElement().getName()) + "_" + ie.getName();
    }

    private void createConnModificationCommands(Connection con, IInterfaceElement subAppIE, boolean isNewPin) {
        this.modifiedConns.add((Command)new DeleteConnectionCommand(con));
        if (isNewPin) {
            this.createSubAppPinConnection(this.targetSubApp.getFbNetwork(), subAppIE, con, false);
            this.createSubAppPinConnection(this.targetSubApp.getSubAppNetwork(), subAppIE, con, true);
        } else if (subAppIE.isIsInput()) {
            this.createSubAppPinConnection(this.targetSubApp.getSubAppNetwork(), subAppIE, con, true);
        } else {
            this.createSubAppPinConnection(this.targetSubApp.getFbNetwork(), subAppIE, con, false);
        }
    }

    private void createSubAppPinConnection(FBNetwork network, IInterfaceElement ie, Connection con, boolean isInsideSubApp) {
        AbstractConnectionCreateCommand cmd = AddElementsToSubAppCommand.getCreateConnectionCommand(network, ie);
        if (ie.isIsInput()) {
            cmd.setSource(isInsideSubApp ? ie : con.getSource());
            cmd.setDestination(isInsideSubApp ? con.getDestination() : ie);
        } else {
            cmd.setSource(isInsideSubApp ? con.getSource() : ie);
            cmd.setDestination(isInsideSubApp ? ie : con.getDestination());
        }
        this.modifiedConns.add((Command)cmd);
    }

    private static AbstractConnectionCreateCommand getCreateConnectionCommand(FBNetwork fbNetwork, IInterfaceElement subAppIE) {
        Object cmd = null;
        cmd = subAppIE instanceof Event ? new EventConnectionCreateCommand(fbNetwork) : (subAppIE instanceof AdapterDeclaration ? new AdapterConnectionCreateCommand(fbNetwork) : new DataConnectionCreateCommand(fbNetwork));
        return cmd;
    }
}

