/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.application.actions.CopyEditPartsAction;
import org.eclipse.fordiac.ide.application.actions.CopyPasteMessage;
import org.eclipse.fordiac.ide.application.commands.CutAndPasteFromSubAppCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteFBNetworkElementCommand;
import org.eclipse.fordiac.ide.model.helpers.FBNetworkHelper;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.ui.actions.Clipboard;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class CutEditPartsAction
extends CopyEditPartsAction {
    public CutEditPartsAction(IEditorPart editor) {
        super(editor);
        this.setId(ActionFactory.CUT.getId());
        this.setText(Messages.CutEditPartsAction_Text);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT_DISABLED"));
    }

    @Override
    public void run() {
        List<Object> templates = this.getSelectedTemplates();
        CopyPasteMessage message = new CopyPasteMessage(CopyPasteMessage.CopyStatus.CUT_FROM_ROOT, templates);
        CutAndPasteFromSubAppCommand cutAndPasteFromSubAppCommand = CutEditPartsAction.isCutFromSubapp(templates);
        Command fbDeleteCommands = CutEditPartsAction.getFBDeleteCommands(templates);
        message.setDeleteCommandos(new CompoundCommand());
        message.getDeleteCommandos().add(fbDeleteCommands);
        if (cutAndPasteFromSubAppCommand != null) {
            this.execute(cutAndPasteFromSubAppCommand);
            message.setCutAndPasteFromSubAppCommandos(cutAndPasteFromSubAppCommand);
            message.setCopyInfo(CopyPasteMessage.CopyStatus.CUT_FROM_SUBAPP);
        } else {
            this.execute(fbDeleteCommands);
        }
        templates.add(this.getWorkbenchPart().getAdapter(FBNetwork.class));
        Clipboard.getDefault().setContents((Object)message);
    }

    private static Command getFBDeleteCommands(List<Object> templates) {
        CompoundCommand cmd = new CompoundCommand();
        for (Object obj : templates) {
            if (!(obj instanceof FBNetworkElement)) continue;
            cmd.add((Command)new DeleteFBNetworkElementCommand((FBNetworkElement)obj));
        }
        return cmd;
    }

    private static CutAndPasteFromSubAppCommand isCutFromSubapp(List<Object> templates) {
        FBNetworkElement parent = null;
        ArrayList<FBNetworkElement> elements = new ArrayList<FBNetworkElement>();
        for (Object obj : templates) {
            if (!(obj instanceof FBNetworkElement)) continue;
            FBNetworkElement fbNetworkElement = (FBNetworkElement)obj;
            if (CutEditPartsAction.isNotPartOfSameSubapp(parent, fbNetworkElement)) {
                return null;
            }
            elements.add(fbNetworkElement);
            parent = fbNetworkElement.getOuterFBNetworkElement();
        }
        return CutEditPartsAction.createCutAndPasteCommand(elements);
    }

    protected static boolean isNotPartOfSameSubapp(FBNetworkElement parent, FBNetworkElement fbNetworkElement) {
        return !fbNetworkElement.isNestedInSubApp() || parent != null && !parent.equals(fbNetworkElement.getOuterFBNetworkElement());
    }

    protected static CutAndPasteFromSubAppCommand createCutAndPasteCommand(List<FBNetworkElement> fbNetworkElements) {
        return new CutAndPasteFromSubAppCommand(fbNetworkElements, FBNetworkHelper.getTopLeftCornerOfFBNetwork(fbNetworkElements));
    }
}

