/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.internal;

import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.model.NameRepository;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.ui.providers.CreationCommand;
import org.eclipse.gef.commands.Command;

public abstract class CreateVariableCommand
extends Command
implements CreationCommand {
    private final LibraryElement type;
    private VarDeclaration varDecl;
    private DataType dataType;
    private String name;
    private final int index;

    protected CreateVariableCommand(LibraryElement type) {
        this(type, 0, null, null);
    }

    protected CreateVariableCommand(LibraryElement type, int index, String name, DataType dataType) {
        this.dataType = dataType;
        if (this.dataType == null) {
            this.dataType = IecTypes.ElementaryTypes.BOOL;
        }
        this.name = name;
        this.index = index;
        this.type = type;
    }

    protected abstract EList<VarDeclaration> getVariableList();

    protected abstract String getDefaultVarName();

    public void execute() {
        if (this.name == null) {
            this.name = this.getDefaultVarName();
        }
        this.varDecl = LibraryElementFactory.eINSTANCE.createVarDeclaration();
        this.varDecl.setType(this.dataType);
        this.varDecl.setTypeName(this.dataType.getName());
        this.varDecl.setComment("");
        this.varDecl.setArraySize(0);
        Value value = LibraryElementFactory.eINSTANCE.createValue();
        value.setValue("");
        this.varDecl.setValue(value);
        this.redo();
        this.varDecl.setName(NameRepository.createUniqueName((INamedElement)this.varDecl, (String)this.name));
    }

    public void undo() {
        this.getVariableList().remove((Object)this.varDecl);
    }

    public VarDeclaration getVarDeclaration() {
        return this.varDecl;
    }

    protected LibraryElement getType() {
        return this.type;
    }

    public void redo() {
        this.getVariableList().add(this.index, (Object)this.varDecl);
    }

    public Object getCreatedElement() {
        return this.getVarDeclaration();
    }
}

