/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.create;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.NameRepository;
import org.eclipse.fordiac.ide.model.commands.create.AdapterCreateCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.EventType;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterType;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.ui.providers.CreationCommand;
import org.eclipse.gef.commands.Command;

public class CreateInterfaceElementCommand
extends Command
implements CreationCommand {
    private IInterfaceElement newInterfaceElement;
    private final String name;
    private final DataType dataType;
    private final boolean isInput;
    private final int index;
    private int arraySize;
    private String value;
    private AdapterCreateCommand adapterCreateCmd;
    private EList<? extends IInterfaceElement> interfaceElementList;
    private final InterfaceList targetInterfaceList;

    public CreateInterfaceElementCommand(IInterfaceElement copySrc, boolean isInput, InterfaceList targetInterfaceList, int index) {
        this(copySrc.getType(), copySrc.getName(), targetInterfaceList, isInput, index);
        this.newInterfaceElement = (IInterfaceElement)EcoreUtil.copy((EObject)copySrc);
    }

    public CreateInterfaceElementCommand(DataType dataType, String name, InterfaceList interfaceList, boolean isInput, int index) {
        this.isInput = isInput;
        this.dataType = dataType;
        this.index = index;
        this.targetInterfaceList = interfaceList;
        this.name = name != null ? name : CreateInterfaceElementCommand.getNameProposal(dataType, isInput);
        this.value = "";
    }

    public CreateInterfaceElementCommand(DataType dataType, InterfaceList interfaceList, boolean isInput, int index) {
        this(dataType, CreateInterfaceElementCommand.getNameProposal(dataType, isInput), interfaceList, isInput, index);
    }

    public CreateInterfaceElementCommand(DataType dataType, String name, InterfaceList interfaceList, boolean isInput, int arraySize, String value, int index) {
        this(dataType, name, interfaceList, isInput, index);
        this.arraySize = arraySize;
        this.value = value != null ? value : "";
    }

    private static String getNameProposal(DataType dataType, boolean isInput) {
        if (dataType instanceof EventType) {
            return isInput ? "EI1" : "EO1";
        }
        if (dataType instanceof AdapterType) {
            return isInput ? "SOCKET1" : "PLUG1";
        }
        return isInput ? "DI1" : "DO1";
    }

    protected InterfaceList getInterfaceList() {
        return this.targetInterfaceList;
    }

    public boolean canExecute() {
        return (this.isValidCopySource() || this.canCreateValidNewElement()) && this.targetInterfaceList != null;
    }

    private boolean canCreateValidNewElement() {
        return this.dataType != null;
    }

    private boolean isValidCopySource() {
        return this.newInterfaceElement != null && this.newInterfaceElement.getType() != null;
    }

    private void selectInterface(InterfaceList interfaceList) {
        this.interfaceElementList = this.isInput ? (this.dataType instanceof EventType ? interfaceList.getEventInputs() : (this.dataType instanceof AdapterType ? interfaceList.getSockets() : interfaceList.getInputVars())) : (this.dataType instanceof EventType ? interfaceList.getEventOutputs() : (this.dataType instanceof AdapterType ? interfaceList.getPlugs() : interfaceList.getOutputVars()));
    }

    public void execute() {
        this.selectInterface(this.targetInterfaceList);
        if (this.newInterfaceElement == null) {
            this.createNewInterfaceElement();
        } else {
            this.finalizeCopyInterfaceElement();
        }
        this.createAdapterCreateCommand();
        this.insertElement();
        if (this.adapterCreateCmd != null) {
            this.adapterCreateCmd.execute();
        }
        this.newInterfaceElement.setName(NameRepository.createUniqueName((INamedElement)this.newInterfaceElement, (String)this.name));
    }

    private void finalizeCopyInterfaceElement() {
        this.newInterfaceElement.setIsInput(this.isInput);
    }

    private void createNewInterfaceElement() {
        if (this.dataType instanceof EventType) {
            this.newInterfaceElement = LibraryElementFactory.eINSTANCE.createEvent();
        } else if (this.dataType instanceof AdapterType) {
            this.newInterfaceElement = LibraryElementFactory.eINSTANCE.createAdapterDeclaration();
        } else {
            VarDeclaration varDeclaration = LibraryElementFactory.eINSTANCE.createVarDeclaration();
            varDeclaration.setArraySize(this.arraySize);
            if (this.isInput) {
                varDeclaration.setValue(LibraryElementFactory.eINSTANCE.createValue());
                varDeclaration.getValue().setValue(this.value);
            }
            this.newInterfaceElement = varDeclaration;
        }
        this.newInterfaceElement.setIsInput(this.isInput);
        this.newInterfaceElement.setType(this.dataType);
        this.newInterfaceElement.setTypeName(this.dataType.getName());
    }

    public void redo() {
        this.insertElement();
        if (this.adapterCreateCmd != null) {
            this.adapterCreateCmd.redo();
        }
    }

    public void undo() {
        this.interfaceElementList.remove((Object)this.newInterfaceElement);
        if (this.adapterCreateCmd != null && this.adapterCreateCmd.canExecute()) {
            this.adapterCreateCmd.undo();
        }
    }

    private void insertElement() {
        EList<? extends IInterfaceElement> temp = this.interfaceElementList;
        int insertionPos = this.index == -1 ? temp.size() : this.index;
        temp.add(insertionPos, (Object)this.newInterfaceElement);
    }

    private void createAdapterCreateCommand() {
        if (this.isInternalAdapterInCompositeFB()) {
            this.adapterCreateCmd = new AdapterCreateCommand(10, 10, (AdapterDeclaration)this.newInterfaceElement, (CompositeFBType)this.targetInterfaceList.eContainer());
        }
    }

    private boolean isInternalAdapterInCompositeFB() {
        return this.dataType instanceof AdapterType && this.targetInterfaceList.eContainer() instanceof CompositeFBType && !(this.targetInterfaceList.eContainer() instanceof SubAppType);
    }

    public IInterfaceElement getCreatedElement() {
        return this.newInterfaceElement;
    }

    protected CreateInterfaceElementCommand createMirroredInterfaceElement() {
        CreateInterfaceElementCommand mirroredCreateCmd = new CreateInterfaceElementCommand(this.newInterfaceElement, this.newInterfaceElement.isIsInput(), this.newInterfaceElement.getFBNetworkElement().getOpposite().getInterface(), this.index);
        mirroredCreateCmd.execute();
        mirroredCreateCmd.getCreatedElement().setName(this.getCreatedElement().getName());
        return mirroredCreateCmd;
    }
}

