/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.create;

import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableObject;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.ui.providers.CreationCommand;
import org.eclipse.gef.commands.Command;

public class AttributeCreateCommand
extends Command
implements CreationCommand {
    private final ConfigurableObject configurableObject;
    private Attribute attribute;
    private Attribute refElement;
    private final String name;
    private final String comment;
    private final String value;

    public AttributeCreateCommand(ConfigurableObject configurableObject) {
        this(configurableObject, "name", "comment", "value");
    }

    public AttributeCreateCommand(ConfigurableObject configurableObject, Attribute refElement) {
        this(configurableObject, "name", "comment", "value");
        this.refElement = refElement;
    }

    public AttributeCreateCommand(ConfigurableObject configurableObject, String name, String comment, String value) {
        this.configurableObject = configurableObject;
        this.name = name;
        this.comment = comment;
        this.value = value;
    }

    public boolean canExecute() {
        return this.configurableObject != null;
    }

    public void execute() {
        this.attribute = LibraryElementFactory.eINSTANCE.createAttribute();
        this.attribute.setName(this.name);
        this.attribute.setComment(this.comment);
        this.attribute.setValue(this.value);
        this.addAttribute();
    }

    public void undo() {
        this.configurableObject.getAttributes().remove((Object)this.attribute);
    }

    public void redo() {
        this.addAttribute();
    }

    private void addAttribute() {
        if (this.refElement == null) {
            this.configurableObject.getAttributes().add((Object)this.attribute);
        } else {
            int index = this.configurableObject.getAttributes().indexOf((Object)this.refElement) + 1;
            this.configurableObject.getAttributes().add(index, (Object)this.attribute);
        }
    }

    public Object getCreatedElement() {
        return this.attribute;
    }
}

