/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.create;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.fordiac.ide.model.CheckableStructTreeNode;
import org.eclipse.fordiac.ide.model.commands.change.ChangeStructCommand;
import org.eclipse.fordiac.ide.model.data.DataFactory;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.libraryElement.Demultiplexer;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.StructManipulator;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.gef.commands.Command;

public class AddDemuxPortCommand
extends Command {
    private Demultiplexer type;
    private final String oldVisibleChildren;
    private String newVisibleChildren;
    private final String varName;
    private Demultiplexer oldMux;
    private ChangeStructCommand cmd;
    private final CheckableStructTreeNode node;

    public AddDemuxPortCommand(Demultiplexer type, CheckableStructTreeNode node) {
        this.node = node;
        this.type = type;
        this.varName = node.getPinName();
        this.oldVisibleChildren = node.getRootNode().visibleToString();
    }

    public void execute() {
        this.node.updateNode(true);
        if (this.newVisibleChildren == null) {
            this.newVisibleChildren = this.node.getRootNode().visibleToString();
        }
        this.createChangeStructCommand();
        this.cmd.execute();
        this.oldMux = this.type;
        this.type = (Demultiplexer)this.cmd.getNewMux();
        this.setVisibleChildrenAttribute(this.newVisibleChildren);
    }

    private void createChangeStructCommand() {
        StructuredType configuredStruct = DataFactory.eINSTANCE.createStructuredType();
        configuredStruct.setName(this.type.getStructType().getName());
        List<String> visibleChildrenNames = Arrays.asList(this.newVisibleChildren.trim().split(","));
        ArrayList<VarDeclaration> varDecls = new ArrayList<VarDeclaration>();
        for (VarDeclaration varDeclaration : CheckableStructTreeNode.getVarDeclarations(visibleChildrenNames, (CheckableStructTreeNode)this.node)) {
            VarDeclaration variable = LibraryElementFactory.eINSTANCE.createVarDeclaration();
            variable.setName(varDeclaration.getName());
            variable.setType(varDeclaration.getType());
            varDecls.add(variable);
        }
        configuredStruct.getMemberVariables().addAll(varDecls);
        this.cmd = new ChangeStructCommand((StructManipulator)this.type, configuredStruct);
    }

    public boolean canExecute() {
        return this.varName != null && (this.oldVisibleChildren == null || Arrays.stream(this.oldVisibleChildren.split(",")).filter(name -> name.equals(this.varName)).findAny().isEmpty());
    }

    public void redo() {
        this.node.updateNode(true);
        this.cmd.redo();
        this.type = (Demultiplexer)this.cmd.getNewMux();
        this.setVisibleChildrenAttribute(this.newVisibleChildren);
    }

    public void undo() {
        this.node.updateNode(false);
        this.type = this.oldMux;
        this.cmd.undo();
        this.setVisibleChildrenAttribute(this.oldVisibleChildren);
    }

    private void setVisibleChildrenAttribute(String value) {
        this.type.setAttribute("VisibleChildren", "STRING", value, "");
    }

    public Demultiplexer getType() {
        return this.type;
    }
}

