/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.validation.handlers;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.ECC;
import org.eclipse.fordiac.ide.model.libraryElement.ECState;
import org.eclipse.fordiac.ide.model.libraryElement.ECTransition;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.validation.Activator;
import org.eclipse.fordiac.ide.validation.handlers.ConstraintHelper;
import org.eclipse.fordiac.ide.validation.handlers.OCLParser;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.expressions.Variable;

public final class ValidationHelper {
    public static void validate(INamedElement namedElement) {
        OCLJob job = new OCLJob("OCL validation", namedElement);
        job.schedule();
    }

    private ValidationHelper() {
        throw new UnsupportedOperationException();
    }

    private static class OCLJob
    extends Job {
        private final INamedElement namedElement;

        public OCLJob(String JobName, INamedElement namedElement) {
            super(JobName);
            this.namedElement = namedElement;
        }

        protected IStatus run(IProgressMonitor monitor) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
            int count = this.countObjects(subMonitor);
            List<Constraint> constraints = OCLParser.loadOCLConstraints(this.namedElement);
            subMonitor.setWorkRemaining(count * constraints.size());
            if (subMonitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            IResource iresource = OCLJob.getFile(this.namedElement);
            OCLJob.clearErrorMarkers(iresource);
            TreeIterator iterator = this.namedElement.eAllContents();
            while (iterator.hasNext()) {
                EObject object = (EObject)iterator.next();
                for (Constraint constraint : constraints) {
                    subMonitor.split(1);
                    if (subMonitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    String objectName = object.eClass().getName();
                    Variable context = constraint.getSpecification().getContextVariable();
                    String contextName = ((EClassifier)context.getType()).getName();
                    if (!contextName.equals(objectName) || Activator.getDefault().getOclInstance().check((Object)object, (Object)constraint)) continue;
                    try {
                        String[] properties = ConstraintHelper.getConstraintProperties(constraint.getName());
                        OCLJob.addValidationMarker(iresource, properties[0], properties[1], OCLJob.createHierarchicalName(object), object.hashCode());
                    }
                    catch (CoreException e) {
                        Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
                    }
                    subMonitor.setTaskName(MessageFormat.format("{0}: {1}", OCLJob.createHierarchicalName(object), constraint.getName()));
                }
            }
            return Status.OK_STATUS;
        }

        private static void clearErrorMarkers(IResource iresource) {
            try {
                if (iresource != null) {
                    iresource.deleteMarkers("org.eclipse.fordiac.ide.validation.ValidationMarker", true, 2);
                }
            }
            catch (CoreException e) {
                Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
            }
        }

        private int countObjects(SubMonitor subMonitor) {
            int count = 0;
            TreeIterator iterator = this.namedElement.eAllContents();
            while (iterator.hasNext()) {
                iterator.next();
                if (subMonitor.isCanceled()) {
                    return -1;
                }
                ++count;
            }
            return count;
        }

        private static void addValidationMarker(IResource iresource, String message, String severity, String location, int lineNumber) throws CoreException {
            if (iresource == null) {
                return;
            }
            IMarker imarker = iresource.createMarker("org.eclipse.fordiac.ide.validation.ValidationMarker");
            imarker.setAttribute("message", (Object)message);
            switch (severity) {
                case "ERROR": {
                    imarker.setAttribute("severity", 2);
                    break;
                }
                case "WARNING": {
                    imarker.setAttribute("severity", 1);
                    break;
                }
                case "INFO": {
                    imarker.setAttribute("severity", 0);
                    break;
                }
                default: {
                    imarker.setAttribute("severity", 0);
                }
            }
            imarker.setAttribute("location", (Object)location);
            imarker.setAttribute("lineNumber", (Object)lineNumber);
        }

        private static IResource getFile(INamedElement element) {
            if (element instanceof FBType) {
                return ((FBType)element).getPaletteEntry().getFile();
            }
            if (element instanceof Application || element instanceof SubApp) {
                return ((Application)element).getAutomationSystem().getSystemFile();
            }
            return null;
        }

        private static String createHierarchicalName(EObject object) {
            if (object instanceof VarDeclaration) {
                VarDeclaration varDeclaration = (VarDeclaration)object;
                FBNetworkElement element = varDeclaration.getFBNetworkElement();
                EObject runner = element.getFbNetwork().eContainer();
                StringBuilder builder = new StringBuilder(OCLJob.getApplicationHierarchy(runner));
                builder.append('.');
                builder.append(element.getName());
                builder.append('.');
                builder.append(varDeclaration.getName());
                return builder.toString();
            }
            if (object instanceof Connection) {
                StringBuilder builder = new StringBuilder(OCLJob.createHierarchicalName((EObject)((Connection)object).getSource()));
                builder.append(" -> ");
                builder.append(OCLJob.createHierarchicalName((EObject)((Connection)object).getDestination()));
                return builder.toString();
            }
            if (object instanceof FBNetwork) {
                FBNetwork element = (FBNetwork)object;
                EObject runner = element.eContainer();
                StringBuilder builder = new StringBuilder(OCLJob.getApplicationHierarchy(runner));
                return builder.toString();
            }
            if (object instanceof FBNetworkElement) {
                FBNetworkElement element = (FBNetworkElement)object;
                EObject runner = element.getFbNetwork().eContainer();
                StringBuilder builder = new StringBuilder(OCLJob.getApplicationHierarchy(runner));
                builder.append('.');
                builder.append(element.getName());
                return builder.toString();
            }
            if (object instanceof Event) {
                Event event = (Event)object;
                FBNetworkElement element = event.getFBNetworkElement();
                EObject runner = element.getFbNetwork().eContainer();
                StringBuilder builder = new StringBuilder(OCLJob.getApplicationHierarchy(runner));
                builder.append('.');
                builder.append(element.getName());
                builder.append('.');
                builder.append(event.getName());
                return builder.toString();
            }
            if (object instanceof ECState) {
                ECState state = (ECState)object;
                StringBuilder builder = new StringBuilder("ECC");
                builder.append('.');
                builder.append(state.getName());
                return builder.toString();
            }
            if (object instanceof ECC) {
                StringBuilder builder = new StringBuilder("ECC");
                return builder.toString();
            }
            if (object instanceof ECTransition) {
                ECTransition transition = (ECTransition)object;
                StringBuilder builder = new StringBuilder("ECC");
                builder.append('.');
                builder.append("Transition X:" + transition.getPosition().getX() + " Y:" + transition.getPosition().getY());
                return builder.toString();
            }
            return object.toString();
        }

        private static String getApplicationHierarchy(EObject runner) {
            int lastIndex;
            StringBuilder builder = new StringBuilder();
            while (runner instanceof SubApp) {
                SubApp parent = (SubApp)runner;
                builder.insert(0, '.');
                builder.insert(0, parent.getName());
                runner = parent.getFbNetwork().eContainer();
            }
            if (runner instanceof Application) {
                builder.insert(0, '.');
                builder.insert(0, ((Application)runner).getName());
            }
            int n = lastIndex = (lastIndex = builder.length()) == 0 ? 0 : lastIndex - 1;
            if (builder.charAt(lastIndex) == '.') {
                builder.deleteCharAt(lastIndex);
            }
            return builder.toString();
        }
    }
}

