/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.fbtester.model;

import org.eclipse.fordiac.ide.fbtester.model.testdata.TestData;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class TestDataLabelProvider
extends LabelProvider
implements ITableLabelProvider,
ITableColorProvider,
ILabelDecorator {
    private final Table table;

    public TestDataLabelProvider(FBType type, Table table) {
        this.table = table;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            DecorationOverlayIcon overlay = FordiacImage.createOverlayImage((Image)FordiacImage.ICON_TesterTemplate.getImage(), (ImageDescriptor)FordiacImage.ICON_OK.getImageDescriptor());
            return overlay.createImage();
        }
        return null;
    }

    public String getLabel(TestData data, int index) {
        TableColumn col = this.table.getColumn(index);
        String columnType = (String)col.getData("ColumnType");
        if (columnType.equals("Name")) {
            return data.getTestName();
        }
        if (columnType.equals("Event")) {
            return data.getEvent().getName();
        }
        if (columnType.equals("InputVariable")) {
            VarDeclaration varDecl = (VarDeclaration)col.getData("InputVariable");
            return data.getValueFor(varDecl.getName());
        }
        if (columnType.equals("OutputVariable")) {
            VarDeclaration varDecl = (VarDeclaration)col.getData("OutputVariable");
            return data.getResultFor(varDecl.getName());
        }
        if (columnType.equals("ExpectedEvents")) {
            return data.getOutputEvents();
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof TestData) {
            String result = this.getLabel((TestData)element, columnIndex);
            return result != null ? result : "";
        }
        return element.toString();
    }

    public Color getBackground(Object element, int columnIndex) {
        if (element instanceof TestData && this.getLabel((TestData)element, columnIndex) == null) {
            return Display.getCurrent().getSystemColor(22);
        }
        return null;
    }

    public Color getForeground(Object element, int columnIndex) {
        return null;
    }

    public Image decorateImage(Image image, Object element) {
        return null;
    }

    public String decorateText(String text, Object element) {
        return null;
    }
}

