/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtester.model.testdata.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.fordiac.ide.fbtester.model.testdata.TestData;
import org.eclipse.fordiac.ide.fbtester.model.testdata.TestdataFactory;
import org.eclipse.fordiac.ide.fbtester.model.testdata.TestdataPackage;
import org.eclipse.fordiac.ide.fbtester.model.testdata.ValuedVarDecl;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.With;

public class TestDataImpl
extends EObjectImpl
implements TestData {
    protected static final String TEST_NAME_EDEFAULT = "testName";
    protected String testName = "testName";
    protected Event event;
    protected static final String TEST_INTSTANCE_EDEFAULT = null;
    protected String testIntstance = TEST_INTSTANCE_EDEFAULT;
    protected EList<Event> eventOutputs;
    protected EList<ValuedVarDecl> values;
    protected EList<ValuedVarDecl> results;
    protected static final String LINE_EDEFAULT = null;
    protected String line = LINE_EDEFAULT;
    protected FBType type;

    protected TestDataImpl() {
    }

    protected EClass eStaticClass() {
        return TestdataPackage.Literals.TEST_DATA;
    }

    @Override
    public String getTestName() {
        return this.testName;
    }

    @Override
    public void setTestName(String newTestName) {
        String oldTestName = this.testName;
        this.testName = newTestName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldTestName, (Object)this.testName));
        }
    }

    @Override
    public Event getEvent() {
        if (this.event != null && this.event.eIsProxy()) {
            InternalEObject oldEvent = (InternalEObject)this.event;
            this.event = (Event)this.eResolveProxy(oldEvent);
            if (this.event != oldEvent && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 1, (Object)oldEvent, (Object)this.event));
            }
        }
        return this.event;
    }

    public Event basicGetEvent() {
        return this.event;
    }

    @Override
    public void setEvent(Event newEvent) {
        Event oldEvent = this.event;
        this.event = newEvent;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldEvent, (Object)this.event));
        }
    }

    @Override
    public String getTestIntstance() {
        return this.testIntstance;
    }

    @Override
    public void setTestIntstance(String newTestIntstance) {
        String oldTestIntstance = this.testIntstance;
        this.testIntstance = newTestIntstance;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldTestIntstance, (Object)this.testIntstance));
        }
    }

    @Override
    public EList<Event> getEventOutputs() {
        if (this.eventOutputs == null) {
            this.eventOutputs = new EObjectResolvingEList(Event.class, (InternalEObject)this, 3);
        }
        return this.eventOutputs;
    }

    @Override
    public EList<ValuedVarDecl> getValues() {
        if (this.values == null) {
            this.values = new EObjectResolvingEList(ValuedVarDecl.class, (InternalEObject)this, 4);
        }
        return this.values;
    }

    @Override
    public EList<ValuedVarDecl> getResults() {
        if (this.results == null) {
            this.results = new EObjectResolvingEList(ValuedVarDecl.class, (InternalEObject)this, 5);
        }
        return this.results;
    }

    @Override
    public String getLine() {
        return this.line;
    }

    @Override
    public void setLine(String newLine) {
        String oldLine = this.line;
        this.line = newLine;
        this.parseData(this.line);
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldLine, (Object)this.line));
        }
    }

    @Override
    public FBType getType() {
        if (this.type != null && this.type.eIsProxy()) {
            InternalEObject oldType = (InternalEObject)this.type;
            this.type = (FBType)this.eResolveProxy(oldType);
            if (this.type != (FBType)oldType && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 7, (Object)oldType, (Object)this.type));
            }
        }
        return this.type;
    }

    public FBType basicGetType() {
        return this.type;
    }

    @Override
    public void setType(FBType newType) {
        FBType oldType = this.type;
        this.type = newType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldType, (Object)this.type));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getTestName();
            }
            case 1: {
                if (resolve) {
                    return this.getEvent();
                }
                return this.basicGetEvent();
            }
            case 2: {
                return this.getTestIntstance();
            }
            case 3: {
                return this.getEventOutputs();
            }
            case 4: {
                return this.getValues();
            }
            case 5: {
                return this.getResults();
            }
            case 6: {
                return this.getLine();
            }
            case 7: {
                if (resolve) {
                    return this.getType();
                }
                return this.basicGetType();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setTestName((String)newValue);
                return;
            }
            case 1: {
                this.setEvent((Event)newValue);
                return;
            }
            case 2: {
                this.setTestIntstance((String)newValue);
                return;
            }
            case 3: {
                this.getEventOutputs().clear();
                this.getEventOutputs().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.getValues().clear();
                this.getValues().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.getResults().clear();
                this.getResults().addAll((Collection)newValue);
                return;
            }
            case 6: {
                this.setLine((String)newValue);
                return;
            }
            case 7: {
                this.setType((FBType)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setTestName(TEST_NAME_EDEFAULT);
                return;
            }
            case 1: {
                this.setEvent(null);
                return;
            }
            case 2: {
                this.setTestIntstance(TEST_INTSTANCE_EDEFAULT);
                return;
            }
            case 3: {
                this.getEventOutputs().clear();
                return;
            }
            case 4: {
                this.getValues().clear();
                return;
            }
            case 5: {
                this.getResults().clear();
                return;
            }
            case 6: {
                this.setLine(LINE_EDEFAULT);
                return;
            }
            case 7: {
                this.setType(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return TEST_NAME_EDEFAULT == null ? this.testName != null : !TEST_NAME_EDEFAULT.equals(this.testName);
            }
            case 1: {
                return this.event != null;
            }
            case 2: {
                return TEST_INTSTANCE_EDEFAULT == null ? this.testIntstance != null : !TEST_INTSTANCE_EDEFAULT.equals(this.testIntstance);
            }
            case 3: {
                return this.eventOutputs != null && !this.eventOutputs.isEmpty();
            }
            case 4: {
                return this.values != null && !this.values.isEmpty();
            }
            case 5: {
                return this.results != null && !this.results.isEmpty();
            }
            case 6: {
                return LINE_EDEFAULT == null ? this.line != null : !LINE_EDEFAULT.equals(this.line);
            }
            case 7: {
                return this.type != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (testName: ");
        result.append(this.testName);
        result.append(", testIntstance: ");
        result.append(this.testIntstance);
        result.append(", line: ");
        result.append(this.line);
        result.append(')');
        return result.toString();
    }

    private void parseData(String line) {
        String[] lineArray = line.split(";(?=(?:[^\"]*\"[^\"]*\")*(?![^\"]*\"))");
        if (lineArray.length > 1) {
            this.setTestName(lineArray[0]);
            this.setTestIntstance(lineArray[1]);
        }
        int currentPos = 0;
        if (this.type.getInterfaceList() != null) {
            int i;
            int nrOfInputs = Integer.parseInt(lineArray[2]);
            if (lineArray.length > nrOfInputs * 2 + 2) {
                int nrOfValues = Integer.parseInt(lineArray[2]);
                currentPos = 3;
                i = 0;
                while (i < nrOfValues) {
                    String port = lineArray[currentPos];
                    String val = lineArray[++currentPos];
                    ++currentPos;
                    VarDeclaration varDec = this.type.getInterfaceList().getVariable(port);
                    if (varDec != null) {
                        ValuedVarDecl data = TestdataFactory.eINSTANCE.createValuedVarDecl();
                        data.setValue(val);
                        data.setVarDeclaration(varDec);
                        this.getValues().add((Object)data);
                    }
                    ++i;
                }
            }
            this.event = this.type.getInterfaceList().getEvent(lineArray[currentPos]);
            int nrOfEvents = Integer.parseInt(lineArray[++currentPos]);
            ++currentPos;
            i = 0;
            while (i < nrOfEvents) {
                Event outputEvent = this.type.getInterfaceList().getEvent(lineArray[currentPos]);
                this.getEventOutputs().add((Object)outputEvent);
                int nrOfValues = Integer.parseInt(lineArray[++currentPos]);
                ++currentPos;
                int j = 0;
                while (j < nrOfValues) {
                    VarDeclaration outputVar = this.type.getInterfaceList().getVariable(lineArray[currentPos]);
                    String result = lineArray[++currentPos];
                    ValuedVarDecl variable = TestdataFactory.eINSTANCE.createValuedVarDecl();
                    variable.setValue(result);
                    variable.setVarDeclaration(outputVar);
                    this.getResults().add((Object)variable);
                    ++j;
                }
                ++i;
            }
        }
    }

    @Override
    public String getValueFor(String text) {
        for (ValuedVarDecl valueVarDecl : this.getValues()) {
            if (!valueVarDecl.getVarDeclaration().getName().equals(text)) continue;
            return valueVarDecl.getValue();
        }
        return null;
    }

    @Override
    public void setValueFor(String text, String value) {
        for (ValuedVarDecl valueVarDecl : this.getValues()) {
            if (!valueVarDecl.getVarDeclaration().getName().equals(text)) continue;
            valueVarDecl.setValue(value);
        }
    }

    @Override
    public String getResultFor(String text) {
        for (ValuedVarDecl valueVarDecl : this.getResults()) {
            if (valueVarDecl.getVarDeclaration() == null || !valueVarDecl.getVarDeclaration().getName().equals(text)) continue;
            return valueVarDecl.getValue();
        }
        return null;
    }

    @Override
    public void setResultFor(String text, String value) {
        for (ValuedVarDecl valueVarDecl : this.getResults()) {
            if (!valueVarDecl.getVarDeclaration().getName().equals(text)) continue;
            valueVarDecl.setValue(value);
        }
    }

    @Override
    public String getOutputEvents() {
        String events = "";
        int i = 0;
        while (i < this.getEventOutputs().size()) {
            Event e = (Event)this.getEventOutputs().get(i);
            events = String.valueOf(events) + e.getName();
            if (i + 1 < this.getEventOutputs().size()) {
                events = String.valueOf(events) + ", ";
            }
            ++i;
        }
        return events;
    }

    @Override
    public String _getLine() {
        String dataLine = String.valueOf(this.getTestName()) + ";";
        dataLine = String.valueOf(dataLine) + this.type.getName();
        dataLine = String.valueOf(dataLine) + ";";
        Event event = null;
        if (!this.type.getInterfaceList().getEventInputs().isEmpty()) {
            event = (Event)this.type.getInterfaceList().getEventInputs().get(0);
        }
        dataLine = String.valueOf(dataLine) + event.getWith().size() + ";";
        for (With with : event.getWith()) {
            VarDeclaration variable = with.getVariables();
            dataLine = String.valueOf(dataLine) + variable.getName() + ";" + this.getValueFor(variable.getName()) + ";";
        }
        dataLine = String.valueOf(dataLine) + event.getName() + ";";
        if (!this.type.getInterfaceList().getEventOutputs().isEmpty()) {
            dataLine = String.valueOf(dataLine) + "1;";
            dataLine = String.valueOf(dataLine) + ((Event)this.type.getInterfaceList().getEventOutputs().get(0)).getName();
            dataLine = String.valueOf(dataLine) + ";";
        } else {
            dataLine = String.valueOf(dataLine) + "0;";
        }
        if (!this.type.getInterfaceList().getOutputVars().isEmpty()) {
            dataLine = String.valueOf(dataLine) + this.type.getInterfaceList().getOutputVars().size();
            dataLine = String.valueOf(dataLine) + ";";
            for (VarDeclaration outVar : this.type.getInterfaceList().getOutputVars()) {
                dataLine = String.valueOf(dataLine) + outVar.getName() + ";" + this.getResultFor(outVar.getName()) + ";";
            }
        }
        return dataLine;
    }
}

