/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.ui.widget;

import java.util.List;
import org.eclipse.fordiac.ide.ui.providers.CommandProvider;
import org.eclipse.fordiac.ide.ui.providers.CreationCommand;
import org.eclipse.fordiac.ide.ui.providers.CreationCommandProvider;
import org.eclipse.fordiac.ide.ui.widget.CommandExecutor;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class AddDeleteWidget {
    private Button createButton;
    private Button deleteButton;
    private Composite container;

    public void createControls(Composite parent, FormToolkit widgetFactory) {
        this.container = AddDeleteWidget.createContainer(widgetFactory, parent);
        this.createAddButton(widgetFactory, this.container);
        this.createDeleteButton(widgetFactory, this.container);
        this.setButtonEnablement(false);
    }

    public void setVisible(boolean visible) {
        AddDeleteWidget.setVisible(visible, (Control)this.container);
    }

    private static void setVisible(boolean visible, Control widget) {
        widget.setVisible(visible);
        if (widget.getLayoutData() != null) {
            ((GridData)widget.getLayoutData()).exclude = !visible;
        } else {
            widget.setLayoutData((Object)GridDataFactory.fillDefaults().exclude(!visible).create());
        }
        widget.getParent().pack();
    }

    public void setVisibleCreateButton(boolean visible) {
        AddDeleteWidget.setVisible(visible, (Control)this.createButton);
    }

    public void setVisibleDeleteButton(boolean visible) {
        AddDeleteWidget.setVisible(visible, (Control)this.deleteButton);
    }

    protected void createDeleteButton(FormToolkit widgetFactory, Composite container) {
        this.deleteButton = widgetFactory.createButton(container, "", 8);
        this.deleteButton.setToolTipText("Delete selected interface element");
        this.deleteButton.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"));
        this.deleteButton.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
    }

    protected void createAddButton(FormToolkit widgetFactory, Composite container) {
        this.createButton = widgetFactory.createButton(container, "", 8);
        this.createButton.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD"));
        this.createButton.setToolTipText("Create element");
        this.createButton.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
    }

    protected static Composite createContainer(FormToolkit widgetFactory, Composite parent) {
        Composite container = widgetFactory.createComposite(parent, 0);
        GridData buttonCompLayoutData = new GridData(0x1000000, 128, false, false);
        container.setLayoutData((Object)buttonCompLayoutData);
        container.setLayout((Layout)new GridLayout(1, true));
        return container;
    }

    public void setButtonEnablement(boolean enable) {
        this.deleteButton.setEnabled(enable);
        this.deleteButton.setImage(enable ? PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE") : PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE_DISABLED"));
    }

    public void setCreateButtonEnablement(boolean enable) {
        this.createButton.setEnabled(enable);
    }

    public void addCreateListener(Listener createListener) {
        this.createButton.addListener(13, createListener);
    }

    public void addDeleteListener(Listener deleteListener) {
        this.deleteButton.addListener(13, deleteListener);
    }

    public void bindToTableViewer(TableViewer viewer, CommandExecutor executor, CreationCommandProvider addCommand, CommandProvider deleteCommand) {
        Listener createListener = AddDeleteWidget.getAddListener(viewer, executor, addCommand);
        Listener deleteListener = AddDeleteWidget.getDeleteListener(viewer, executor, deleteCommand);
        this.bindToTableViewer(viewer, createListener, deleteListener);
    }

    public void bindToTableViewer(TableViewer viewer, final Listener createListener, final Listener deleteListener) {
        this.addCreateListener(createListener);
        this.addDeleteListener(deleteListener);
        viewer.addSelectionChangedListener(ev -> this.setButtonEnablement(!viewer.getSelection().isEmpty()));
        viewer.getTable().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000009 && e.stateMask == 0) {
                    createListener.handleEvent(null);
                } else if (e.character == '\u007f' && e.stateMask == 0) {
                    deleteListener.handleEvent(null);
                }
            }
        });
    }

    public static Listener getSelectionListener(TableViewer viewer, CommandExecutor executor, CommandProvider commandProvider) {
        return ev -> {
            if (!viewer.getStructuredSelection().isEmpty()) {
                AddDeleteWidget.executeCompoundCommandForList(viewer, viewer.getStructuredSelection().toList(), executor, commandProvider);
            }
        };
    }

    protected static void executeCompoundCommandForList(TableViewer viewer, List<Object> selection, CommandExecutor executor, CommandProvider commandProvider) {
        CompoundCommand cmd = new CompoundCommand();
        selection.stream().forEach(elem -> cmd.add(commandProvider.getCommand(elem)));
        executor.executeCommand((Command)cmd);
        viewer.refresh();
    }

    public static Listener getDeleteListener(TableViewer viewer, CommandExecutor executor, CommandProvider commandProvider) {
        return ev -> {
            if (!viewer.getStructuredSelection().isEmpty()) {
                int pos = viewer.getTable().getSelectionIndices()[0];
                AddDeleteWidget.executeCompoundCommandForList(viewer, viewer.getStructuredSelection().toList(), executor, commandProvider);
                int itemCnt = viewer.getTable().getItemCount();
                if (pos <= itemCnt) {
                    if (pos == itemCnt) {
                        --pos;
                    }
                    viewer.getTable().forceFocus();
                    viewer.getTable().setSelection(pos);
                    viewer.setSelection(viewer.getSelection());
                }
            }
        };
    }

    private static Listener getAddListener(TableViewer viewer, CommandExecutor executor, CreationCommandProvider commandProvider) {
        return ev -> {
            CreationCommand cmd = commandProvider.getCommand(AddDeleteWidget.getReferencedElement(viewer));
            executor.executeCommand((Command)cmd);
            viewer.refresh();
            StructuredSelection selection = new StructuredSelection(cmd.getCreatedElement());
            viewer.setSelection((ISelection)selection);
        };
    }

    private static Object getReferencedElement(TableViewer viewer) {
        if (!viewer.getStructuredSelection().isEmpty()) {
            return viewer.getStructuredSelection().toList().get(viewer.getStructuredSelection().size() - 1);
        }
        return null;
    }
}

