/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.datatypeeditor.widgets;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.fordiac.ide.datatypeeditor.Messages;
import org.eclipse.fordiac.ide.model.commands.change.ChangeArraySizeCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCommentCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeDataTypeCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeNameCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeValueCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeVariableOrderCommand;
import org.eclipse.fordiac.ide.model.commands.create.CreateMemberVariableCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteMemberVariableCommand;
import org.eclipse.fordiac.ide.model.commands.insert.InsertVariableCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.edit.providers.DataLabelProvider;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeLibrary;
import org.eclipse.fordiac.ide.model.ui.editors.DataTypeDropdown;
import org.eclipse.fordiac.ide.model.ui.widgets.OpenStructMenu;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.ui.widget.AddDeleteReorderListWidget;
import org.eclipse.fordiac.ide.ui.widget.CommandExecutor;
import org.eclipse.fordiac.ide.ui.widget.I4diacTableUtil;
import org.eclipse.fordiac.ide.ui.widget.TableWidgetFactory;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class StructViewingComposite
extends Composite
implements CommandExecutor,
I4diacTableUtil {
    private static final String NAME = "NAME";
    private static final String TYPE = "DATATYPE";
    private static final String INIT = "INITIAL_VALUE";
    private static final String COMMENT = "COMMENT";
    private static final String ARRAY = "ARRAY_SIZE";
    private TableViewer structViewer;
    private DataTypeDropdown typeDropDown;
    private final DataTypeLibrary dataTypeLibrary;
    private final CommandStack cmdStack;
    private final IWorkbenchPart part;
    private final StructuredType dataType;

    public StructViewingComposite(Composite parent, int style, CommandStack cmdStack, StructuredType dataType, DataTypeLibrary dataTypeLibrary, IWorkbenchPart part) {
        super(parent, style);
        this.cmdStack = cmdStack;
        this.dataType = dataType;
        this.dataTypeLibrary = dataTypeLibrary;
        this.part = part;
    }

    public void createPartControl(Composite parent) {
        TabbedPropertySheetWidgetFactory widgetFactory = new TabbedPropertySheetWidgetFactory();
        parent.setLayout((Layout)new GridLayout(2, false));
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        StructViewingComposite.showLabel(parent);
        AddDeleteReorderListWidget buttons = new AddDeleteReorderListWidget();
        buttons.createControls(parent, (FormToolkit)widgetFactory);
        this.showTable(parent);
        buttons.bindToTableViewer(this.structViewer, (CommandExecutor)this, ref -> new CreateMemberVariableCommand(this.getType(), this.getInsertionIndex(), this.getVarName(), this.getDataType()), ref -> new DeleteMemberVariableCommand(this.getType(), (VarDeclaration)ref), ref -> new ChangeVariableOrderCommand(this.getType().getMemberVariables(), (VarDeclaration)ref, true), ref -> new ChangeVariableOrderCommand(this.getType().getMemberVariables(), (VarDeclaration)ref, false));
        this.part.getSite().setSelectionProvider((ISelectionProvider)this);
        StructViewingComposite.createContextMenu(this.structViewer);
    }

    private static void showLabel(Composite parent) {
        Label label = new Label(parent, 0x1000000);
        label.setText(Messages.StructViewingComposite_Headline);
    }

    private void showTable(Composite parent) {
        this.structViewer = TableWidgetFactory.createPropertyTableViewer((Composite)parent);
        StructViewingComposite.configureTableLayout(this.structViewer.getTable());
        this.structViewer.setCellEditors(this.createCellEditors(this.structViewer.getTable()));
        this.structViewer.setColumnProperties(new String[]{NAME, TYPE, COMMENT, INIT, ARRAY});
        this.structViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.structViewer.setLabelProvider((IBaseLabelProvider)new DataLabelProvider());
        this.structViewer.setCellModifier((ICellModifier)new StructCellModifier());
        this.structViewer.setInput((Object)this.dataType.getMemberVariables());
    }

    private DataType getDataType() {
        VarDeclaration memVar = this.getLastSelectedVariable();
        return memVar != null ? memVar.getType() : null;
    }

    private String getVarName() {
        VarDeclaration memVar = this.getLastSelectedVariable();
        return memVar != null ? memVar.getName() : null;
    }

    private int getInsertionIndex() {
        VarDeclaration memVar = this.getLastSelectedVariable();
        if (memVar == null) {
            return this.getType().getMemberVariables().size();
        }
        return this.getType().getMemberVariables().indexOf((Object)memVar) + 1;
    }

    private VarDeclaration getLastSelectedVariable() {
        IStructuredSelection selection = this.structViewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return null;
        }
        return (VarDeclaration)selection.toList().get(selection.toList().size() - 1);
    }

    private StructuredType getType() {
        return this.dataType;
    }

    private CellEditor[] createCellEditors(Table table) {
        this.typeDropDown = new DataTypeDropdown(this.dataTypeLibrary, this.structViewer){

            protected List<DataType> getDataTypesSorted() {
                return super.getDataTypesSorted().stream().filter(Objects::nonNull).filter(type -> !type.getName().equals(StructViewingComposite.this.getType().getName())).filter(type -> !(type instanceof StructuredType) || StructViewingComposite.this.isValidStruct((StructuredType)type)).collect(Collectors.toList());
            }
        };
        return new CellEditor[]{new TextCellEditor((Composite)table), this.typeDropDown, new TextCellEditor((Composite)table), new TextCellEditor((Composite)table), new TextCellEditor((Composite)table)};
    }

    private boolean isValidStruct(StructuredType type) {
        return type.getMemberVariables().stream().filter(memVar -> memVar.getType() instanceof StructuredType).noneMatch(memVar -> memVar.getTypeName().equals(this.getType().getName()) || !this.isValidStruct(this.dataTypeLibrary.getStructuredType(memVar.getTypeName())));
    }

    private static void configureTableLayout(Table table) {
        TableColumn column1 = new TableColumn(table, 16384);
        column1.setText(FordiacMessages.Name);
        TableColumn column2 = new TableColumn(table, 16384);
        column2.setText(FordiacMessages.Type);
        TableColumn column3 = new TableColumn(table, 16384);
        column3.setText(FordiacMessages.Comment);
        TableColumn column4 = new TableColumn(table, 16384);
        column4.setText(FordiacMessages.InitialValue);
        TableColumn column5 = new TableColumn(table, 16384);
        column5.setText(FordiacMessages.ArraySize);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(3, 30));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(2, 30));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(2, 20));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(5, 50));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(2, 20));
        table.setLayout((Layout)layout);
    }

    public void executeCommand(Command cmd) {
        this.cmdStack.execute(cmd);
    }

    public TableViewer getViewer() {
        return this.structViewer;
    }

    public void addEntry(Object entry, int index, CompoundCommand cmd) {
        if (entry instanceof VarDeclaration) {
            VarDeclaration varEntry = (VarDeclaration)entry;
            cmd.add((Command)new InsertVariableCommand(this.dataType.getMemberVariables(), varEntry, index));
        }
    }

    public void executeCompoundCommand(CompoundCommand cmd) {
        this.executeCommand((Command)cmd);
    }

    public Object removeEntry(int index, CompoundCommand cmd) {
        VarDeclaration entry = (VarDeclaration)this.getEntry(index);
        cmd.add((Command)new DeleteMemberVariableCommand(this.getType(), entry));
        return entry;
    }

    public DataType getStruct() {
        return this.dataType;
    }

    public Object getEntry(int index) {
        return this.getType().getMemberVariables().get(index);
    }

    private static void createContextMenu(TableViewer viewer) {
        OpenStructMenu.addTo((TableViewer)viewer);
    }

    public ISelection getSelection() {
        return new StructuredSelection((Object)this);
    }

    private final class StructCellModifier
    implements ICellModifier {
        private StructCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            VarDeclaration memVar = (VarDeclaration)element;
            switch (property) {
                case "NAME": {
                    return memVar.getName();
                }
                case "DATATYPE": {
                    return memVar.getTypeName();
                }
                case "COMMENT": {
                    return memVar.getComment();
                }
                case "INITIAL_VALUE": {
                    return memVar.getValue() == null ? "" : memVar.getValue().getValue();
                }
                case "ARRAY_SIZE": {
                    return memVar.getArraySize() > 0 ? Integer.toString(memVar.getArraySize()) : "";
                }
            }
            return "Could not load";
        }

        public void modify(Object element, String property, Object value) {
            TableItem tableItem = (TableItem)element;
            VarDeclaration data = (VarDeclaration)tableItem.getData();
            ChangeArraySizeCommand cmd = null;
            switch (property) {
                case "NAME": {
                    cmd = new ChangeNameCommand((INamedElement)data, value.toString());
                    break;
                }
                case "DATATYPE": {
                    DataType type = StructViewingComposite.this.typeDropDown.getType((String)value);
                    if (type == null) {
                        return;
                    }
                    cmd = new ChangeDataTypeCommand(data, type);
                    break;
                }
                case "COMMENT": {
                    cmd = new ChangeCommentCommand((INamedElement)data, value.toString());
                    break;
                }
                case "INITIAL_VALUE": {
                    cmd = new ChangeValueCommand(data, value.toString());
                    break;
                }
                case "ARRAY_SIZE": {
                    cmd = new ChangeArraySizeCommand(data, value.toString());
                    break;
                }
            }
            StructViewingComposite.this.executeCommand((Command)cmd);
            StructViewingComposite.this.structViewer.refresh((Object)data);
        }
    }
}

