/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.datatypeeditor.editors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.datatypeeditor.Activator;
import org.eclipse.fordiac.ide.datatypeeditor.Messages;
import org.eclipse.fordiac.ide.datatypeeditor.widgets.StructViewingComposite;
import org.eclipse.fordiac.ide.model.Palette.DataTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.data.AnyDerivedType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.dataexport.AbstractTypeExporter;
import org.eclipse.fordiac.ide.model.dataimport.DataTypeImporter;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.systemmanagement.changelistener.IEditorFileChangeListener;
import org.eclipse.fordiac.ide.ui.widget.TableWidgetFactory;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackEvent;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.RedoAction;
import org.eclipse.gef.ui.actions.UndoAction;
import org.eclipse.gef.ui.actions.UpdateAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class DataTypeEditor
extends EditorPart
implements CommandStackEventListener,
ITabbedPropertySheetPageContributor,
ISelectionListener,
IEditorFileChangeListener {
    private final CommandStack commandStack = new CommandStack();
    private StructViewingComposite editComposite;
    private Composite errorComposite;
    private boolean importFailed;
    private boolean outsideWorkspace;
    private ActionRegistry actionRegistry;
    private final List<String> selectionActions = new ArrayList<String>();
    private final List<String> stackActions = new ArrayList<String>();
    private final List<String> propertyActions = new ArrayList<String>();
    private DataTypePaletteEntry dataTypePaletteEntry;
    private final AtomicReference<StructuredType> dataType = new AtomicReference();
    private final Adapter adapter = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            Object feature = notification.getFeature();
            if (feature != null && notification.getFeatureID(feature.getClass()) == 0) {
                Display.getDefault().asyncExec(() -> {
                    if (DataTypeEditor.this.dataTypePaletteEntry != null) {
                        DataTypeEditor.this.setPartName(DataTypeEditor.this.dataTypePaletteEntry.getFile().getName());
                        DataTypeEditor.this.setInput((IEditorInput)new FileEditorInput(DataTypeEditor.this.dataTypePaletteEntry.getFile()));
                    }
                });
            }
        }
    };

    public void stackChanged(CommandStackEvent event) {
        this.updateActions(this.stackActions);
        this.firePropertyChange(257);
        this.editComposite.getViewer().refresh();
    }

    public String getContributorId() {
        return "org.eclipse.fordiac.ide.datatypeeditor.editors.DataTypeEditor";
    }

    public void dispose() {
        this.getCommandStack().removeCommandStackEventListener((CommandStackEventListener)this);
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
        this.getActionRegistry().dispose();
        this.removeListenerFromDataTypeObj();
        super.dispose();
    }

    protected void firePropertyChange(int property) {
        super.firePropertyChange(property);
        this.updateActions(this.propertyActions);
    }

    public void doSave(IProgressMonitor monitor) {
        this.removeListenerFromDataTypeObj();
        this.dataTypePaletteEntry.setType((LibraryElement)EcoreUtil.copy((EObject)this.dataType.get()));
        AbstractTypeExporter.saveType((PaletteEntry)this.dataTypePaletteEntry);
        this.addListenerToDataTypeObj();
        this.commandStack.markSaveLocation();
        this.firePropertyChange(257);
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.importType(input);
        this.setInput(input);
        this.setSite((IWorkbenchPartSite)site);
        this.addListenerToDataTypeObj();
        site.getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
        this.getCommandStack().addCommandStackEventListener((CommandStackEventListener)this);
        this.initializeActionRegistry();
        this.setActionHandlers(site);
    }

    private void addListenerToDataTypeObj() {
        if (this.dataTypePaletteEntry != null && this.dataTypePaletteEntry.getType() != null) {
            this.dataTypePaletteEntry.getType().eAdapters().add((Object)this.adapter);
        }
    }

    private void removeListenerFromDataTypeObj() {
        if (this.dataTypePaletteEntry != null && this.dataTypePaletteEntry.getType() != null && this.dataTypePaletteEntry.getType().eAdapters().contains((Object)this.adapter)) {
            this.dataTypePaletteEntry.getType().eAdapters().remove((Object)this.adapter);
        }
    }

    private void importType(IEditorInput input) throws PartInitException {
        if (input instanceof FileEditorInput) {
            IFile file = ((FileEditorInput)input).getFile();
            try {
                this.importFailed = this.importTypeBasedOnFile(file);
            }
            catch (Exception e) {
                throw new PartInitException(e.getMessage(), (Throwable)e);
            }
        } else if (input instanceof FileStoreEditorInput) {
            this.importFailed = true;
            this.outsideWorkspace = true;
        }
    }

    private boolean importTypeBasedOnFile(IFile file) throws CoreException {
        file.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
        if (file.exists()) {
            this.dataTypePaletteEntry = (DataTypePaletteEntry)TypeLibrary.getPaletteEntryForFile((IFile)file);
            this.setPartName(this.dataTypePaletteEntry.getFile().getName());
            DataTypeImporter importer = new DataTypeImporter(file);
            importer.loadElement();
            return this.updateDatatTypeObject(importer);
        }
        return true;
    }

    private boolean updateDatatTypeObject(DataTypeImporter importer) {
        AnyDerivedType element = importer.getElement();
        if (element instanceof StructuredType) {
            if (!this.dataType.compareAndSet(null, (StructuredType)element)) {
                this.dataType.get().getMemberVariables().clear();
                this.dataType.get().getMemberVariables().addAll((Collection)((StructuredType)element).getMemberVariables());
            }
            this.dataTypePaletteEntry.setType((LibraryElement)EcoreUtil.copy((EObject)this.dataType.get()));
            return false;
        }
        return true;
    }

    private void setActionHandlers(IEditorSite site) {
        ActionRegistry registry = this.getActionRegistry();
        IActionBars bars = site.getActionBars();
        String id = ActionFactory.UNDO.getId();
        bars.setGlobalActionHandler(id, registry.getAction((Object)id));
        id = ActionFactory.REDO.getId();
        bars.setGlobalActionHandler(id, registry.getAction((Object)id));
        id = ActionFactory.DELETE.getId();
        bars.setGlobalActionHandler(id, registry.getAction((Object)id));
        bars.updateActionBars();
    }

    public boolean isDirty() {
        return this.getCommandStack().isDirty();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        if (this.dataType.get() != null && !this.importFailed) {
            this.editComposite = new StructViewingComposite(parent, 1, this.commandStack, this.dataType.get(), this.dataTypePaletteEntry.getTypeLibrary().getDataTypeLibrary(), (IWorkbenchPart)this);
            this.editComposite.createPartControl(parent);
            TableWidgetFactory.enableCopyPasteCut((Object)((Object)this));
        } else if (this.importFailed) {
            this.createErrorComposite(parent, Messages.ErrorCompositeMessage);
            if (this.outsideWorkspace) {
                MessageDialog.openError((Shell)this.getSite().getShell().getShell(), (String)Messages.MessageDialogTitle_OutsideWorkspaceError, (String)Messages.MessageDialogContent_OutsideWorkspaceError);
            }
        }
    }

    private void createErrorComposite(Composite parent, String errorText) {
        this.errorComposite = new Composite(parent, 0);
        this.errorComposite.setLayout((Layout)new GridLayout(1, false));
        Label label = new Label(this.errorComposite, 0x1000000);
        label.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.headerfont"));
        label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        label.setText(errorText);
    }

    public void setFocus() {
        if (this.editComposite == null) {
            this.errorComposite.setFocus();
        } else {
            this.editComposite.setFocus();
        }
    }

    public CommandStack getCommandStack() {
        return this.commandStack;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (((Object)((Object)this)).equals(this.getSite().getPage().getActiveEditor())) {
            this.updateActions(this.selectionActions);
            this.firePropertyChange(257);
        }
    }

    private void createActions() {
        ActionRegistry registry = this.getActionRegistry();
        UndoAction action = new UndoAction((IEditorPart)this);
        registry.registerAction((IAction)action);
        this.getStackActions().add(action.getId());
        action = new RedoAction((IEditorPart)this);
        registry.registerAction((IAction)action);
        this.getStackActions().add(action.getId());
    }

    public <T> T getAdapter(Class<T> key) {
        if (key == IPropertySheetPage.class) {
            return key.cast(new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this));
        }
        if (key == CommandStack.class) {
            return key.cast(this.getCommandStack());
        }
        if (key == ActionRegistry.class) {
            return key.cast(this.getActionRegistry());
        }
        return (T)super.getAdapter(key);
    }

    private List<String> getStackActions() {
        return this.stackActions;
    }

    private void initializeActionRegistry() {
        this.createActions();
        this.updateActions(this.propertyActions);
        this.updateActions(this.stackActions);
    }

    private void updateActions(List<String> actionIds) {
        ActionRegistry registry = this.getActionRegistry();
        actionIds.forEach(id -> {
            IAction action = registry.getAction(id);
            if (action instanceof UpdateAction) {
                ((UpdateAction)action).update();
            }
        });
    }

    private ActionRegistry getActionRegistry() {
        if (this.actionRegistry == null) {
            this.actionRegistry = new ActionRegistry();
        }
        return this.actionRegistry;
    }

    public void reloadFile() {
        try {
            this.removeListenerFromDataTypeObj();
            this.importType(this.getEditorInput());
            this.setInput((IEditorInput)new FileEditorInput(this.dataTypePaletteEntry.getFile()));
            this.editComposite.getViewer().refresh();
            this.addListenerToDataTypeObj();
        }
        catch (PartInitException e) {
            Activator.getDefault().logError("Error during refreshing struct table after file change detection: " + e.toString());
        }
    }

    public IFile getFile() {
        Assert.isNotNull((Object)((FileEditorInput)this.getEditorInput()).getFile());
        return ((FileEditorInput)this.getEditorInput()).getFile();
    }

    public void updateEditorInput(FileEditorInput newInput) {
        this.setInput((IEditorInput)newInput);
        this.setTitleToolTip(newInput.getFile().getFullPath().toOSString());
    }
}

