#include <string.h>
#include <stdint.h>
#include <stdio.h>
#include <errno.h>

#include <drm/xe_drm.h>
enum {
	OTHER_GPU,
	XE_IGPU,
	XE_DGPU,
};

/* Mock open(2) so we can test multiple devices configurations */
int
open (const char *pathname,
      int         flags)
{
	if (!strcmp(pathname, "OTHER_GPU"))
		return OTHER_GPU;
	if (!strcmp (pathname, "XE_IGPU"))
		return XE_IGPU;
	if (!strcmp (pathname, "XE_DGPU"))
		return XE_DGPU;

	return -1;
}

/* open64 may be used for large file support */
int
open64 (const char *pathname,
        int         flags)
{
	return open (pathname, flags);
}

int
ioctl (int                         fd,
       unsigned long               op,
       struct drm_xe_device_query *query)
{
	if (op != DRM_IOCTL_XE_DEVICE_QUERY)
		return EINVAL;
	if (fd == OTHER_GPU)
		return ENODEV;

	if (query->size == 0) {
		query->size = sizeof(struct drm_xe_query_config);
	} else {
		struct drm_xe_query_config *config = (struct drm_xe_query_config*)query->data;
		config->info[DRM_XE_QUERY_CONFIG_FLAGS] = fd == XE_DGPU ? DRM_XE_QUERY_CONFIG_FLAG_HAS_VRAM : 0;
	}

	return 0;
}
