.\" Copyright © 2005-2010  Roger Leigh <rleigh@codelibre.net>
.\"
.\" schroot is free software: you can redistribute it and/or modify it
.\" under the terms of the GNU General Public License as published by
.\" the Free Software Foundation, either version 3 of the License, or
.\" (at your option) any later version.
.\"
.\" schroot is distributed in the hope that it will be useful, but
.\" WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
.\" General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see
.\" <http://www.gnu.org/licenses/>.
.\"
.so config.man
.TH SCHROOT-SCRIPT-CONFIG 5 "\*[RELEASE_DATE]" "Version \*[VERSION]" "Debian sbuild"
.SH NAME
schroot-script-config \- schroot chroot setup script configuration
.SH DESCRIPTION
\fBschroot\fP uses scripts to set up and then clean up the chroot
environment.  These scripts may be customised using the \f[CI]script\-config\fP
key in \fI\*[SCHROOT_CONF]\fP.  This key specifies a file which the setup scripts
will source when they are run.  The file is a Bourne shell script, and in
consequence may contain any valid shell code, in addition to simple variable
assignments.  This will, for example, allow behaviour to be customised
according to the specific chroot type or name.
.PP
This file is deprecated, but is still used if present; it will be obsoleted and
removed in a future release.  All the settings in this file are now settable
using configuration keys in \fIschroot.conf\fP, as detailed below.  Existing
configuration should be modified to use these keys in place of this file.
.SH ENVIRONMENT
The environment is the same as for all setup scripts, described in
.BR schroot-setup (5).
.SH VARIABLES
The following variables may be set to configure setup script behaviour.  Note
that new variables may be added in future releases.  Third-party extensions to
schroot which add their own setup scripts may add additional variables which
are not documented here; consult the extension documentation for further
details.
.TP
SETUP_COPYFILES
A file containing a list of files to copy into the chroot (one file per line).
The file will have the same absolute location inside the chroot.  Note that
this is settable using the \f[CI]setup.copyfiles\fP key.
.TP
SETUP_FSTAB
The filesystem table file to be used to mount filesystems within the chroot.
The format of this file is the same as for \fI/etc/fstab\fP, documented in
.BR fstab (5).
The only difference is that the mountpoint path \fIfs_dir\fP is relative to the
chroot, rather than the root.  Note that this is settable using the
\f[CI]setup.fstab\fP key.  Also note that mountpoints are canonicalised on the
host, which will ensure that absolute symlinks point inside the chroot, but
complex paths containing multiple symlinks may be resolved incorrectly; it is
advised to not use nested symlinks as mountpoints.
.TP
SETUP_NSSDATABASES
A file listing the system databases to copy into the chroot.  The default
databases are \[oq]passwd\[cq], \[oq]shadow\[cq], \[oq]group\[cq],
\[oq]services\[cq], \[oq]protocols\[cq], \[oq]networks\[cq], and
\[oq]hosts\[cq].  \[oq]gshadow\[cq] is not yet copied by default, due to not
being supported by all but the most recent version of the GNU C library.  The
databases are copied using
.BR getent (1)
so all database sources listed in \fI/etc/nsswitch.conf\fP will be used for
each database.  Note that this is settable using the
\f[CI]setup.nssdatabases\fP key.
.so authors.man
.so copyright.man
.SH SEE ALSO
.BR sbuild (1),
.BR schroot (1),
.BR sh (1),
.BR schroot.conf (5),
.BR schroot\-setup (5).
.\"#
.\"# The following sets edit modes for GNU EMACS
.\"# Local Variables:
.\"# mode:nroff
.\"# fill-column:79
.\"# End:
